/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.logic;

import java.math.BigInteger;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;

public class BoolType
extends AbstractIntegerType<BoolType>
implements BooleanType<BoolType> {
    boolean value;

    public BoolType() {
        this(false);
    }

    public BoolType(boolean value) {
        this.value = value;
    }

    public <T extends BooleanType<T>> BoolType(T type) {
        this(type.get());
    }

    @Override
    public BoolType createVariable() {
        return new BoolType();
    }

    @Override
    public BoolType copy() {
        return new BoolType(this);
    }

    @Override
    public void set(BoolType c) {
        this.value = c.get();
    }

    @Override
    public int compareTo(BoolType o) {
        if (this.value) {
            return o.value ? 0 : 1;
        }
        return o.value ? -1 : 0;
    }

    @Override
    public boolean get() {
        return this.value;
    }

    @Override
    public void set(boolean value) {
        this.value = value;
    }

    @Override
    public void and(boolean b) {
        this.value &= b;
    }

    @Override
    public void or(boolean b) {
        this.value |= b;
    }

    @Override
    public void xor(boolean b) {
        this.value ^= b;
    }

    @Override
    public void and(BoolType c) {
        this.and(c.value);
    }

    @Override
    public void or(BoolType c) {
        this.or(c.value);
    }

    @Override
    public void xor(BoolType c) {
        this.xor(c.value);
    }

    @Override
    public void not() {
        this.value = !this.value;
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int getBitsPerPixel() {
        return 1;
    }

    @Override
    public int getInteger() {
        return this.get() ? 1 : 0;
    }

    @Override
    public long getIntegerLong() {
        return this.get() ? 1L : 0L;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.get() ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public void setInteger(int f) {
        this.set(f >= 1);
    }

    @Override
    public void setInteger(long f) {
        this.set(f >= 1L);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.compareTo(BigInteger.ZERO) > 0);
    }

    @Override
    public boolean valueEquals(BoolType t) {
        return this.get() == t.get();
    }
}

