/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.loops.LoopUtils;
import net.imglib2.loops.SyncedPositionables;
import net.imglib2.util.Intervals;

public class LoopBuilder<T> {
    private final Dimensions dimensions;
    private final RandomAccessibleInterval<?>[] images;

    private LoopBuilder(RandomAccessibleInterval<?> ... images) {
        this.images = images;
        this.dimensions = new FinalInterval(images[0]);
        Arrays.asList(images).forEach(this::checkDimensions);
    }

    private void checkDimensions(Interval interval) {
        long[] b;
        long[] a = Intervals.dimensionsAsLongArray(this.dimensions);
        if (!Arrays.equals(a, b = Intervals.dimensionsAsLongArray(interval))) {
            throw new IllegalArgumentException("Dimensions do not fit.");
        }
    }

    public static <A> LoopBuilder<Consumer<A>> setImages(RandomAccessibleInterval<A> a) {
        return new LoopBuilder<Consumer<A>>(a);
    }

    public static <A, B> LoopBuilder<BiConsumer<A, B>> setImages(RandomAccessibleInterval<A> a, RandomAccessibleInterval<B> b) {
        return new LoopBuilder<BiConsumer<A, B>>(a, b);
    }

    public static <A, B, C> LoopBuilder<TriConsumer<A, B, C>> setImages(RandomAccessibleInterval<A> a, RandomAccessibleInterval<B> b, RandomAccessibleInterval<C> c) {
        return new LoopBuilder<TriConsumer<A, B, C>>(a, b, c);
    }

    public void forEachPixel(T action) {
        Objects.requireNonNull(action);
        List samplers = Stream.of(this.images).map(this::initRandomAccess).collect(Collectors.toList());
        Positionable synced = SyncedPositionables.create(samplers);
        LoopUtils.createIntervalLoop(synced, this.dimensions, RunnableFactory.bindActionToSamplers(action, samplers)).run();
    }

    private RandomAccess<?> initRandomAccess(RandomAccessibleInterval<?> image) {
        RandomAccess ra = image.randomAccess();
        ra.setPosition(Intervals.minAsLongArray(image));
        return ra;
    }

    private static class RunnableFactory {
        private static final List<ClassCopyProvider<Runnable>> factories = Arrays.asList(new ClassCopyProvider<Runnable>(ConsumerRunnable.class, Runnable.class, new Class[0]), new ClassCopyProvider<Runnable>(BiConsumerRunnable.class, Runnable.class, new Class[0]), new ClassCopyProvider<Runnable>(TriConsumerRunnable.class, Runnable.class, new Class[0]));

        private RunnableFactory() {
        }

        public static Runnable bindActionToSamplers(Object action, List<? extends Sampler<?>> samplers) {
            Object[] arguments = Stream.concat(Stream.of(action), samplers.stream()).toArray();
            for (ClassCopyProvider<Runnable> factory : factories) {
                if (!factory.matches(arguments)) continue;
                List key = Stream.of(arguments).map(Object::getClass).collect(Collectors.toList());
                return factory.newInstanceForKey(key, arguments);
            }
            throw new IllegalArgumentException();
        }

        public static class TriConsumerRunnable<A, B, C>
        implements Runnable {
            private final TriConsumer<A, B, C> action;
            private final Sampler<A> samplerA;
            private final Sampler<B> samplerB;
            private final Sampler<C> samplerC;

            public TriConsumerRunnable(TriConsumer<A, B, C> action, Sampler<A> samplerA, Sampler<B> samplerB, Sampler<C> samplerC) {
                this.action = action;
                this.samplerA = samplerA;
                this.samplerB = samplerB;
                this.samplerC = samplerC;
            }

            @Override
            public void run() {
                this.action.accept(this.samplerA.get(), this.samplerB.get(), this.samplerC.get());
            }
        }

        public static class BiConsumerRunnable<A, B>
        implements Runnable {
            private final BiConsumer<A, B> action;
            private final Sampler<A> samplerA;
            private final Sampler<B> samplerB;

            public BiConsumerRunnable(BiConsumer<A, B> action, Sampler<A> samplerA, Sampler<B> samplerB) {
                this.action = action;
                this.samplerA = samplerA;
                this.samplerB = samplerB;
            }

            @Override
            public void run() {
                this.action.accept(this.samplerA.get(), this.samplerB.get());
            }
        }

        public static class ConsumerRunnable<A>
        implements Runnable {
            private final Consumer<A> action;
            private final Sampler<A> samplerA;

            public ConsumerRunnable(Consumer<A> action, Sampler<A> samplerA) {
                this.action = action;
                this.samplerA = samplerA;
            }

            @Override
            public void run() {
                this.action.accept(this.samplerA.get());
            }
        }
    }

    public static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

