/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import java.util.Arrays;
import net.imglib2.Positionable;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Util;

public class CellGrid {
    private final int n;
    private final long[] dimensions;
    private final int[] cellDimensions;
    private final long[] numCells;
    private final int[] borderSize;
    private final int hashcode;

    public CellGrid(long[] dimensions, int[] cellDimensions) {
        this.n = dimensions.length;
        this.dimensions = (long[])dimensions.clone();
        this.cellDimensions = (int[])cellDimensions.clone();
        this.numCells = new long[this.n];
        this.borderSize = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.numCells[d] = (dimensions[d] - 1L) / (long)cellDimensions[d] + 1L;
            this.borderSize[d] = (int)(dimensions[d] - (this.numCells[d] - 1L) * (long)cellDimensions[d]);
        }
        this.hashcode = 31 * Arrays.hashCode(dimensions) + Arrays.hashCode(cellDimensions);
    }

    public CellGrid(CellGrid grid) {
        this.n = grid.n;
        this.dimensions = (long[])grid.dimensions.clone();
        this.cellDimensions = (int[])grid.cellDimensions.clone();
        this.numCells = (long[])grid.numCells.clone();
        this.borderSize = (int[])grid.borderSize.clone();
        this.hashcode = grid.hashcode;
    }

    public int numDimensions() {
        return this.n;
    }

    public long[] getGridDimensions() {
        return (long[])this.numCells.clone();
    }

    public void gridDimensions(long[] s) {
        for (int i = 0; i < this.n; ++i) {
            s[i] = this.numCells[i];
        }
    }

    public long gridDimension(int d) {
        return this.numCells[d];
    }

    public long[] getImgDimensions() {
        return (long[])this.dimensions.clone();
    }

    public void imgDimensions(long[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.dimensions[i];
        }
    }

    public long imgDimension(int d) {
        return this.dimensions[d];
    }

    public void cellDimensions(int[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.cellDimensions[i];
        }
    }

    public int cellDimension(int d) {
        return this.cellDimensions[d];
    }

    public void getCellDimensions(long index, long[] cellMin, int[] cellDims) {
        for (int d = 0; d < this.n; ++d) {
            long j = index / this.numCells[d];
            long gridPos = index - j * this.numCells[d];
            index = j;
            cellDims[d] = gridPos == this.numCells[d] - 1L ? this.borderSize[d] : this.cellDimensions[d];
            cellMin[d] = gridPos * (long)this.cellDimensions[d];
        }
    }

    public void getCellDimensions(long[] cellGridPosition, long[] cellMin, int[] cellDims) {
        for (int d = 0; d < this.n; ++d) {
            cellDims[d] = cellGridPosition[d] + 1L == this.numCells[d] ? this.borderSize[d] : this.cellDimensions[d];
            cellMin[d] = cellGridPosition[d] * (long)this.cellDimensions[d];
        }
    }

    public void getCellGridPositionFlat(long index, long[] cellGridPosition) {
        IntervalIndexer.indexToPosition(index, this.numCells, cellGridPosition);
    }

    public void getCellPosition(long[] position, long[] cellPos) {
        for (int d = 0; d < this.n; ++d) {
            cellPos[d] = position[d] / (long)this.cellDimensions[d];
        }
    }

    public void getCellPosition(long[] position, Positionable cellPos) {
        for (int d = 0; d < this.n; ++d) {
            cellPos.setPosition(position[d] / (long)this.cellDimensions[d], d);
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CellGrid) {
            CellGrid other = (CellGrid)obj;
            return Arrays.equals(this.dimensions, other.dimensions) && Arrays.equals(this.cellDimensions, other.cellDimensions);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( dims = " + Util.printCoordinates(this.dimensions) + ", cellDims = " + Util.printCoordinates(this.cellDimensions) + " )";
    }
}

