/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import java.io.Serializable;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;

public class Cell<A>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final int n;
    protected final int[] dimensions;
    protected final int[] steps;
    protected final long[] min;
    protected final long[] max;
    private final int numPixels;
    private final A data;

    public Cell(int[] dimensions, long[] min, A data) {
        this.n = dimensions.length;
        this.dimensions = (int[])dimensions.clone();
        this.steps = new int[this.n];
        IntervalIndexer.createAllocationSteps(dimensions, this.steps);
        this.min = (long[])min.clone();
        this.max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = min[d] + (long)dimensions[d] - 1L;
        }
        this.numPixels = (int)Intervals.numElements(dimensions);
        this.data = data;
    }

    public A getData() {
        return this.data;
    }

    public long size() {
        return this.numPixels;
    }

    public long indexToGlobalPosition(int index, int d) {
        return (long)IntervalIndexer.indexToPosition(index, this.dimensions, this.steps, d) + this.min[d];
    }

    public void indexToGlobalPosition(int index, long[] position) {
        IntervalIndexer.indexToPosition(index, this.dimensions, position);
        for (int d = 0; d < position.length; ++d) {
            int n = d;
            position[n] = position[n] + this.min[d];
        }
    }

    public int globalPositionToIndex(long[] position) {
        return IntervalIndexer.positionWithOffsetToIndex(position, this.dimensions, this.min);
    }

    public long min(int d) {
        return this.min[d];
    }

    public void min(long[] minimum) {
        for (int d = 0; d < this.n; ++d) {
            minimum[d] = this.min[d];
        }
    }

    public int dimension(int d) {
        return this.dimensions[d];
    }

    public void dimensions(int[] dim) {
        for (int d = 0; d < this.n; ++d) {
            dim[d] = this.dimensions[d];
        }
    }
}

