/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img;

import java.util.function.Supplier;
import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.util.Util;

public abstract class ImgFactory<T> {
    public abstract Img<T> create(long[] var1, T var2);

    public Img<T> create(Dimensions dim, T type) {
        long[] size = new long[dim.numDimensions()];
        dim.dimensions(size);
        return this.create(size, type);
    }

    public Img<T> create(int[] dim, T type) {
        return this.create(Util.int2long(dim), type);
    }

    public abstract <S> ImgFactory<S> imgFactory(S var1) throws IncompatibleTypeException;

    public Img<T> create(Supplier<T> typeSupplier, long ... dim) {
        return this.create(dim, typeSupplier.get());
    }

    public Img<T> create(Supplier<T> typeSupplier, Dimensions dim) {
        return this.create(dim, typeSupplier.get());
    }

    public Img<T> create(Supplier<T> typeSupplier, int[] dim) {
        return this.create(dim, typeSupplier.get());
    }

    public <S> ImgFactory<S> imgFactory(Supplier<S> typeSupplier) throws IncompatibleTypeException {
        return this.imgFactory(typeSupplier.get());
    }
}

