/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.TypeIdentity;
import net.imglib2.converter.read.ConvertedIterableInterval;
import net.imglib2.converter.read.ConvertedRandomAccessible;
import net.imglib2.converter.read.ConvertedRandomAccessibleInterval;
import net.imglib2.converter.read.ConvertedRealRandomAccessible;
import net.imglib2.converter.read.ConvertedRealRandomAccessibleRealInterval;
import net.imglib2.converter.readwrite.ARGBChannelSamplerConverter;
import net.imglib2.converter.readwrite.SamplerConverter;
import net.imglib2.converter.readwrite.WriteConvertedIterableInterval;
import net.imglib2.converter.readwrite.WriteConvertedIterableRandomAccessibleInterval;
import net.imglib2.converter.readwrite.WriteConvertedRandomAccessible;
import net.imglib2.converter.readwrite.WriteConvertedRandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import net.imglib2.view.composite.NumericComposite;
import net.imglib2.view.composite.RealComposite;

public class Converters {
    public static final <A, B extends Type<B>> RandomAccessible<B> convert(RandomAccessible<A> source, Converter<? super A, ? super B> converter, B b) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRandomAccessible<A, B>(source, converter, b);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessible<A, B> convert(RandomAccessible<A> source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedRandomAccessible<A, B>(source, converter);
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> convert(RandomAccessibleInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRandomAccessibleInterval<A, B>(source, converter, b);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessibleInterval<A, B> convert(RandomAccessibleInterval<A> source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedRandomAccessibleInterval<A, B>(source, converter);
    }

    public static final <A, B extends Type<B>> IterableInterval<B> convert(IterableInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedIterableInterval<A, B>(source, converter, b);
    }

    public static final <A, B extends Type<B>> WriteConvertedIterableInterval<A, B> convert(IterableInterval<A> source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedIterableInterval<A, B>(source, converter);
    }

    public static final <A, B extends Type<B>, S extends RandomAccessible<A> & IterableInterval<A>> WriteConvertedIterableRandomAccessibleInterval<A, B, S> convertRandomAccessibleIterableInterval(S source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedIterableRandomAccessibleInterval<A, B, S>(source, converter);
    }

    public static final <A, B extends Type<B>> RealRandomAccessibleRealInterval<B> convert(RealRandomAccessibleRealInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRealRandomAccessibleRealInterval<A, B>(source, converter, b);
    }

    public static final <A, B extends Type<B>> RealRandomAccessible<B> convert(RealRandomAccessible<A> source, Converter<? super A, ? super B> converter, B b) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRealRandomAccessible<A, B>(source, converter, b);
    }

    public static final WriteConvertedRandomAccessibleInterval<ARGBType, UnsignedByteType> argbChannel(RandomAccessibleInterval<ARGBType> source, int channel) {
        return Converters.convert(source, new ARGBChannelSamplerConverter(channel));
    }

    public static final WriteConvertedRandomAccessible<ARGBType, UnsignedByteType> argbChannel(RandomAccessible<ARGBType> source, int channel) {
        return Converters.convert(source, new ARGBChannelSamplerConverter(channel));
    }

    public static final RandomAccessibleInterval<UnsignedByteType> argbChannels(RandomAccessibleInterval<ARGBType> source) {
        return Views.stack(Converters.argbChannel(source, 0), Converters.argbChannel(source, 1), Converters.argbChannel(source, 2), Converters.argbChannel(source, 3));
    }

    public static final RandomAccessibleInterval<UnsignedByteType> argbChannels(RandomAccessibleInterval<ARGBType> source, int ... channels) {
        ArrayList<WriteConvertedRandomAccessibleInterval<ARGBType, UnsignedByteType>> hyperSlices = new ArrayList<WriteConvertedRandomAccessibleInterval<ARGBType, UnsignedByteType>>();
        for (int channel : channels) {
            hyperSlices.add(Converters.argbChannel(source, channel));
        }
        return Views.stack(hyperSlices);
    }

    public static final <A extends RealType<A>, B extends Type<B>> RandomAccessibleInterval<B> composeReal(List<RandomAccessibleInterval<A>> components, Converter<RealComposite<A>, B> composer, B targetType) {
        return Converters.convert(Views.collapseReal(Views.stack(components)), composer, targetType);
    }

    public static final <A extends RealType<A>, B extends Type<B>> RandomAccessibleInterval<B> composeReal(List<RandomAccessibleInterval<A>> components, Converter<RealComposite<A>, B> composer, Supplier<B> targetTypeSupplier) {
        return Converters.composeReal(components, composer, (Type)targetTypeSupplier.get());
    }

    public static final <A extends NumericType<A>, B extends Type<B>> RandomAccessibleInterval<B> composeNumeric(List<RandomAccessibleInterval<A>> components, Converter<NumericComposite<A>, B> composer, B targetType) {
        return Converters.convert(Views.collapseNumeric(Views.stack(components)), composer, targetType);
    }

    public static final <A extends NumericType<A>, B extends Type<B>> RandomAccessibleInterval<B> composeNumeric(List<RandomAccessibleInterval<A>> components, Converter<NumericComposite<A>, B> composer, Supplier<B> targetTypeSupplier) {
        return Converters.composeNumeric(components, composer, (Type)targetTypeSupplier.get());
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> compose(List<RandomAccessibleInterval<A>> components, Converter<Composite<A>, B> composer, B targetType) {
        return Converters.convert(Views.collapse(Views.stack(components)), composer, targetType);
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> compose(List<RandomAccessibleInterval<A>> components, Converter<Composite<A>, B> composer, Supplier<B> targetTypeSupplier) {
        return Converters.compose(components, composer, (Type)targetTypeSupplier.get());
    }
}

