/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.BubbleChartBuilder;
import org.knowm.xchart.BubbleSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.AxisPair;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_Bubble;
import org.knowm.xchart.internal.chartpart.Plot_Bubble;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.BubbleStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class BubbleChart
extends Chart<BubbleStyler, BubbleSeries> {
    public BubbleChart(int width, int height) {
        super(width, height, new BubbleStyler());
        this.axisPair = new AxisPair(this);
        this.plot = new Plot_Bubble(this);
        this.legend = new Legend_Bubble(this);
    }

    public BubbleChart(int width, int height, Theme theme) {
        this(width, height);
        ((BubbleStyler)this.styler).setTheme(theme);
    }

    public BubbleChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public BubbleChart(BubbleChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
        this.setXAxisTitle(chartBuilder.xAxisTitle);
        this.setYAxisTitle(chartBuilder.yAxisTitle);
    }

    public BubbleSeries addSeries(String seriesName, double[] xData, double[] yData, double[] bubbleData) {
        return this.addSeries(seriesName, Utils.getNumberListFromDoubleArray(xData), Utils.getNumberListFromDoubleArray(yData), Utils.getNumberListFromDoubleArray(bubbleData));
    }

    public BubbleSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> bubbleData) {
        BubbleSeries series;
        this.sanityCheck(seriesName, xData, yData, bubbleData);
        if (xData != null) {
            if (xData.size() != yData.size()) {
                throw new IllegalArgumentException("X and Y-Axis sizes are not the same!!!");
            }
            series = new BubbleSeries(seriesName, xData, yData, bubbleData);
        } else {
            series = new BubbleSeries(seriesName, Utils.getGeneratedData(yData.size()), yData, bubbleData);
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    public BubbleSeries updateBubbleSeries(String seriesName, List<?> newXData, List<? extends Number> newYData, List<? extends Number> newBubbleData) {
        Map seriesMap = this.getSeriesMap();
        BubbleSeries series = (BubbleSeries)seriesMap.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< not found!!!");
        }
        if (newXData == null) {
            ArrayList<Integer> generatedXData = new ArrayList<Integer>();
            for (int i = 1; i <= newYData.size(); ++i) {
                generatedXData.add(i);
            }
            series.replaceData(generatedXData, newYData, newBubbleData);
        } else {
            series.replaceData(newXData, newYData, newBubbleData);
        }
        return series;
    }

    public BubbleSeries updateXYSeries(String seriesName, double[] newXData, double[] newYData, double[] newBubbleData) {
        return this.updateBubbleSeries(seriesName, Utils.getNumberListFromDoubleArray(newXData), Utils.getNumberListFromDoubleArray(newYData), Utils.getNumberListFromDoubleArray(newBubbleData));
    }

    private void sanityCheck(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> bubbleData) {
        if (this.seriesMap.keySet().contains(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        if (yData == null) {
            throw new IllegalArgumentException("Y-Axis data cannot be null!!! >" + seriesName);
        }
        if (yData.size() == 0) {
            throw new IllegalArgumentException("Y-Axis data cannot be empty!!! >" + seriesName);
        }
        if (xData != null && xData.size() == 0) {
            throw new IllegalArgumentException("X-Axis data cannot be empty!!! >" + seriesName);
        }
        if (bubbleData.size() != yData.size()) {
            throw new IllegalArgumentException("Bubble Data and Y-Axis sizes are not the same!!! >" + seriesName);
        }
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (BubbleSeries bubbleSeries : this.getSeriesMap().values()) {
            BubbleSeries.BubbleSeriesRenderStyle seriesType = bubbleSeries.getBubbleSeriesRenderStyle();
            if (seriesType != null) continue;
            bubbleSeries.setBubbleSeriesRenderStyle(((BubbleStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g);
        this.axisPair.paint(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((BubbleStyler)this.getStyler()).getSeriesColors(), ((BubbleStyler)this.getStyler()).getSeriesMarkers(), ((BubbleStyler)this.getStyler()).getSeriesLines());
        for (BubbleSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            float lineWidth = -1.0f;
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() != null) continue;
            series.setFillColor(seriesColorMarkerLineStyle.getColor());
        }
    }
}

