/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.html.HTMLDocument;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;
import org.scijava.search.SearchAction;
import org.scijava.search.SearchEvent;
import org.scijava.search.SearchOperation;
import org.scijava.search.SearchResult;
import org.scijava.search.SearchService;
import org.scijava.search.Searcher;
import org.scijava.thread.ThreadService;

public class SwingSearchBar
extends JTextField {
    private static final String DEFAULT_MESSAGE = "Click here to search";
    private static final Color ACTIVE_FONT_COLOR = new Color(0, 0, 0);
    private static final Color INACTIVE_FONT_COLOR = new Color(150, 150, 150);
    private static final Color SELECTED_RESULT_COLOR = new Color(186, 218, 255);
    private static final String CONTEXT_COLOR = "#8C745E";
    private static final int ICON_SIZE = 16;
    private static final int PAD = 5;
    private final DocumentListener documentListener;
    private final JToolBar buttons;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private PluginService pluginService;
    private SwingSearchPanel searchPanel;
    private String searchText;
    private int resultLimit = 8;
    private boolean mouseoverEnabled;

    public SwingSearchBar(Context context) {
        super(DEFAULT_MESSAGE, 12);
        context.inject(this);
        this.setText(DEFAULT_MESSAGE);
        this.setForeground(INACTIVE_FONT_COLOR);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.addActionListener(e -> this.searchPanel.runDefaultAction());
        this.addKeyListener(new SearchBarKeyAdapter());
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingSearchBar.this.search();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingSearchBar.this.search();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingSearchBar.this.search();
            }
        };
        this.getDocument().addDocumentListener(this.documentListener);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SwingSearchBar.DEFAULT_MESSAGE.equals(SwingSearchBar.this.getText())) {
                    SwingSearchBar.this.setText("");
                }
                SwingSearchBar.this.setForeground(ACTIVE_FONT_COLOR);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SwingSearchBar.this.getText().equals("")) {
                    SwingSearchBar.this.reset();
                }
            }
        });
        this.buttons = new JToolBar();
        this.buttons.setFloatable(false);
    }

    public void activate() {
        this.threadService.queue(() -> {
            this.setText("");
            this.requestFocus();
        });
    }

    public void close() {
        this.reset();
        this.loseFocus();
    }

    public int getResultLimit() {
        return this.resultLimit;
    }

    public void setResultLimit(int resultLimit) {
        if (resultLimit <= 0) {
            return;
        }
        this.resultLimit = resultLimit;
    }

    public boolean isMouseoverEnabled() {
        return this.mouseoverEnabled;
    }

    public void setMouseoverEnabled(boolean mouseoverEnabled) {
        this.mouseoverEnabled = mouseoverEnabled;
    }

    public void addButton(String label, String tooltip, ActionListener action) {
        JButton button = new JButton(label);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        if (action != null) {
            button.addActionListener(action);
        }
        this.buttons.add(button);
    }

    protected void showPanel(Container panel) {
        this.assertDispatchThread();
        Window w = this.window();
        JDialog dialog = new JDialog(w, "Quick Search");
        dialog.setContentPane(panel);
        dialog.pack();
        int x = w.getLocation().x;
        int y = w.getLocation().y + w.getHeight() + 1;
        dialog.setLocation(x, y);
        dialog.setFocusableWindowState(false);
        this.threadService.queue(() -> {
            dialog.setVisible(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.grabFocus();
            this.requestFocus();
            dialog.setFocusableWindowState(true);
        });
    }

    protected void hidePanel(Container panel) {
        this.assertDispatchThread();
        Window w = SwingUtilities.getWindowAncestor(panel);
        if (w != null) {
            w.dispose();
        }
    }

    protected void loseFocus() {
        this.assertDispatchThread();
        this.window().requestFocusInWindow();
    }

    protected void runAction(SearchAction action, boolean isDefault) {
        this.assertDispatchThread();
        this.threadService.run(() -> action.run());
    }

    protected void reset() {
        this.assertDispatchThread();
        if (this.searchPanel == null) {
            this.loseFocus();
            this.getDocument().removeDocumentListener(this.documentListener);
            this.setText(DEFAULT_MESSAGE);
            this.setForeground(INACTIVE_FONT_COLOR);
            this.getDocument().addDocumentListener(this.documentListener);
        } else {
            this.hidePanel(this.searchPanel);
            this.searchPanel = null;
            this.setText("");
            this.requestFocusInWindow();
        }
    }

    private void assertDispatchThread() {
        if (!this.threadService.isDispatchThread()) {
            throw new IllegalStateException("Current thread is not EDT");
        }
    }

    private Window window() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private void search() {
        this.assertDispatchThread();
        if (this.searchPanel == null) {
            if (this.getText().equals("") || this.getText().equals(DEFAULT_MESSAGE)) {
                return;
            }
            this.searchPanel = new SwingSearchPanel(this.threadService.context());
            this.showPanel(this.searchPanel);
        }
        this.searchPanel.search(this.getText());
    }

    private class SearchResultHeader
    implements SearchResult {
        private final Searcher searcher;
        private final int resultCount;

        public SearchResultHeader(Searcher searcher, int resultCount) {
            this.searcher = searcher;
            this.resultCount = resultCount;
        }

        public int resultCount() {
            return this.resultCount;
        }

        public Searcher searcher() {
            return this.searcher;
        }

        @Override
        public String name() {
            return this.searcher.title();
        }

        @Override
        public String iconPath() {
            return null;
        }

        @Override
        public Map<String, String> properties() {
            return null;
        }
    }

    private class SearchBarKeyAdapter
    extends KeyAdapter {
        private SearchBarKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 38: {
                    if (SwingSearchBar.this.searchPanel != null) {
                        SwingSearchBar.this.searchPanel.up();
                    }
                    e.consume();
                    break;
                }
                case 40: {
                    if (SwingSearchBar.this.searchPanel != null) {
                        SwingSearchBar.this.searchPanel.down();
                    }
                    e.consume();
                    break;
                }
                case 9: {
                    if (SwingSearchBar.this.searchPanel != null) {
                        SwingSearchBar.this.searchPanel.requestFocus();
                    }
                    e.consume();
                    break;
                }
                case 10: {
                    if (SwingSearchBar.this.searchPanel != null) {
                        SwingSearchBar.this.searchPanel.runDefaultAction();
                    }
                    e.consume();
                    break;
                }
                case 27: {
                    SwingSearchBar.this.reset();
                    break;
                }
                case 76: {
                    if (SwingSearchBar.this.hasFocus()) break;
                    SwingSearchBar.this.requestFocusInWindow();
                    SwingSearchBar.this.selectAll();
                }
            }
        }
    }

    private class SwingSearchPanel
    extends JPanel {
        private final SearchOperation operation;
        private final Map<Class<?>, SearchEvent> allResults;
        private final Map<Class<?>, JCheckBox> headerCheckboxes;
        private final JList<SearchResult> resultsList;
        @Parameter
        private SearchService searchService;

        public SwingSearchPanel(Context context) {
            context.inject(this);
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(800, 300));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.operation = this.searchService.search(event -> SwingSearchBar.this.threadService.queue(() -> this.update(event)));
            this.allResults = new HashMap();
            this.headerCheckboxes = new HashMap();
            this.resultsList = new JList();
            this.resultsList.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
                if (this.isHeader((SearchResult)value)) {
                    Searcher searcher = ((SearchResultHeader)value).searcher();
                    Container parent = this.getParent();
                    String resultSizeStr = "";
                    int resCount = ((SearchResultHeader)value).resultCount();
                    if (resCount > SwingSearchBar.this.resultLimit) {
                        resultSizeStr = resultSizeStr + " <span style='color: #8C745E;'>(" + SwingSearchBar.this.resultLimit + "/" + resCount + ")";
                    }
                    JCheckBox headerBox = new JCheckBox("<html>" + searcher.title() + resultSizeStr, this.searchService.enabled(searcher));
                    headerBox.setFont(this.smaller(headerBox.getFont(), 2));
                    if (parent != null) {
                        headerBox.setBackground(parent.getBackground());
                    }
                    this.headerCheckboxes.put(searcher.getClass(), headerBox);
                    JPanel headerInnerPane = new JPanel();
                    headerInnerPane.setLayout(new GridLayout(1, 1));
                    headerInnerPane.add(headerBox);
                    if (parent != null) {
                        headerInnerPane.setBackground(parent.getBackground());
                    }
                    JPanel headerOuterPane = new JPanel();
                    headerOuterPane.setLayout(new GridLayout(1, 1));
                    headerOuterPane.add(headerInnerPane);
                    headerOuterPane.setBackground(list.getBackground());
                    headerOuterPane.setBorder(new EmptyBorder(index == 0 ? 0 : 5, 0, 0, 0));
                    return headerOuterPane;
                }
                JPanel item = new JPanel();
                item.setLayout(new BoxLayout(item, 0));
                item.setBorder(new EmptyBorder(1, 5, 0, 5));
                item.add(this.icon(value.iconPath()));
                item.add(Box.createHorizontalStrut(3));
                JLabel name = new JLabel();
                Font f = name.getFont();
                name.setFont(f.deriveFont(f.getStyle() & 0xFFFFFFFE));
                name.setText("<html>" + value.identifier() + "&nbsp;&nbsp;<span style='color: " + SwingSearchBar.CONTEXT_COLOR + ";'>" + value.context() + "</span>");
                name.setBackground(null);
                item.add(name);
                item.setBackground(isSelected ? SELECTED_RESULT_COLOR : list.getBackground());
                return item;
            });
            this.resultsList.setBorder(new EmptyBorder(0, 0, 0, 0));
            JScrollPane resultsPane = new JScrollPane(this.resultsList);
            resultsPane.setHorizontalScrollBarPolicy(31);
            resultsPane.setBorder(null);
            JPanel detailsPane = new JPanel();
            JLabel detailsTitle = new JLabel();
            JPanel detailsProps = new JPanel();
            JScrollPane detailsScrollPane = new JScrollPane(detailsProps);
            JPanel detailsButtons = new JPanel();
            detailsScrollPane.setHorizontalScrollBarPolicy(31);
            detailsScrollPane.setBorder(null);
            detailsProps.setLayout((LayoutManager)new MigLayout("wrap 1, ins 0, wmin 0, hmin 0", "[grow]", ""));
            detailsButtons.setLayout((LayoutManager)new MigLayout("fill, ins 5 0 0 0"));
            detailsPane.setLayout((LayoutManager)new MigLayout("wrap, ins 0 5 5 5, fill, wmin 0, hmin 0, hmax 100%, wmax 100%", "[grow]", "[fill][fill,grow][fill]"));
            this.resultsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SearchResult result = (SearchResult)SwingSearchPanel.this.resultsList.getSelectedValue();
                    if (SwingSearchPanel.this.isHeader(result)) {
                        Searcher s = ((SearchResultHeader)result).searcher();
                        SwingSearchPanel.this.searchService.setEnabled(s, !SwingSearchPanel.this.searchService.enabled(s));
                        SwingSearchBar.this.search();
                    } else if (result != null && e.getClickCount() > 1) {
                        SwingSearchPanel.this.runDefaultAction();
                    }
                }
            });
            if (SwingSearchBar.this.mouseoverEnabled) {
                this.resultsList.addMouseMotionListener(new MouseMotionAdapter(){
                    private SearchResult lastSelected;

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        int index = SwingSearchPanel.this.resultsList.locationToIndex(e.getPoint());
                        SearchResult selected = (SearchResult)SwingSearchPanel.this.resultsList.getModel().getElementAt(index);
                        if (this.lastSelected != selected) {
                            this.lastSelected = selected;
                            if (this.lastSelected != null && !SwingSearchPanel.this.isHeader(this.lastSelected)) {
                                SwingSearchPanel.this.resultsList.setSelectedValue(this.lastSelected, false);
                            }
                        }
                    }
                });
            }
            this.resultsList.addListSelectionListener(lse -> {
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                SearchResult result = this.resultsList.getSelectedValue();
                if (this.isHeader(result)) {
                    SwingSearchBar.this.threadService.queue(() -> this.down());
                    return;
                }
                if (result == null) {
                    detailsTitle.setText("");
                    detailsProps.removeAll();
                    detailsButtons.removeAll();
                    detailsPane.validate();
                    detailsPane.repaint();
                    return;
                }
                detailsTitle.setText("<html><h2>" + this.highlightSearchUnderline(this.escapeHtml(result.name()), SwingSearchBar.this.searchText) + "</h2>");
                detailsProps.removeAll();
                result.properties().forEach((k, v) -> {
                    if (v == "") {
                        return;
                    }
                    if (k == null) {
                        JTextPane textPane = new JTextPane();
                        textPane.setContentType("text/html");
                        textPane.setText(this.highlightSearchBold((String)v, SwingSearchBar.this.searchText));
                        Font font = UIManager.getFont("Label.font");
                        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
                        ((HTMLDocument)textPane.getDocument()).getStyleSheet().addRule(bodyRule);
                        textPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
                        textPane.setEditable(false);
                        textPane.setOpaque(false);
                        detailsProps.add((Component)textPane, "growx, wmax 100%");
                    } else {
                        JLabel keyLabel = new JLabel("<html><strong style=\"color: gray;\">" + k + "&nbsp;&nbsp;</strong>");
                        keyLabel.setFont(this.smaller(keyLabel.getFont(), 1));
                        detailsProps.add((Component)keyLabel, "growx, pad 0 0 10 0");
                        JTextArea valueField = new JTextArea();
                        valueField.setText((String)v);
                        valueField.setLineWrap(true);
                        valueField.setWrapStyleWord(true);
                        valueField.setEditable(false);
                        valueField.setBackground(null);
                        valueField.setBorder(null);
                        detailsProps.add((Component)valueField, "growx, wmax 100%");
                    }
                });
                detailsButtons.removeAll();
                List<SearchAction> actions = this.searchService.actions(result);
                boolean first = true;
                for (SearchAction action : actions) {
                    JButton button = new JButton(action.toString());
                    boolean isDefault = first;
                    button.addActionListener(ae -> SwingSearchBar.this.runAction(action, isDefault));
                    button.addKeyListener(new SearchBarKeyAdapter());
                    if (first) {
                        detailsButtons.add((Component)button, "grow, spanx");
                        JRootPane rootPane = this.getRootPane();
                        if (rootPane != null) {
                            rootPane.setDefaultButton(button);
                        }
                        first = false;
                        continue;
                    }
                    detailsButtons.add((Component)button, "growx");
                }
                detailsPane.validate();
                detailsPane.repaint();
            });
            detailsPane.add((Component)SwingSearchBar.this.buttons, "pos n 0 100% n");
            detailsPane.add((Component)detailsTitle, "growx, pad 0 0 0 -20");
            detailsPane.add((Component)detailsScrollPane, "growx, hmin 0, wmin 0");
            detailsPane.add((Component)detailsButtons, "growx");
            this.resultsList.addKeyListener(new SearchBarKeyAdapter());
            JSplitPane splitPane = new JSplitPane(1);
            splitPane.setLeftComponent(resultsPane);
            splitPane.setRightComponent(detailsPane);
            detailsPane.setMinimumSize(new Dimension(0, 0));
            resultsPane.setMinimumSize(new Dimension(0, 0));
            splitPane.setBorder(null);
            this.add((Component)splitPane, "Center");
        }

        public void search(String text) {
            SwingSearchBar.this.assertDispatchThread();
            SwingSearchBar.this.searchText = text;
            this.operation.search(text);
        }

        private void update(SearchEvent event) {
            SwingSearchBar.this.assertDispatchThread();
            if (event.exclusive()) {
                this.allResults.clear();
            }
            this.allResults.put(event.searcher().getClass(), event);
            this.rebuild();
        }

        private void up() {
            this.select(index -> (index + this.rowCount() - 1) % this.rowCount());
        }

        private void down() {
            this.select(index -> (index + 1) % this.rowCount());
        }

        private void select(Function<Integer, Integer> stepper) {
            SwingSearchBar.this.assertDispatchThread();
            if (this.resultCount() == 0) {
                return;
            }
            int index = this.resultsList.getSelectedIndex();
            while (this.isHeader(this.result(index = stepper.apply(index).intValue()))) {
            }
            this.select(index);
        }

        private int rowCount() {
            return this.resultsList.getModel().getSize();
        }

        private int resultCount() {
            int count = 0;
            for (int i = 0; i < this.resultsList.getModel().getSize(); ++i) {
                SearchResult result = this.resultsList.getModel().getElementAt(i);
                if (this.isHeader(result)) continue;
                ++count;
            }
            return count;
        }

        private Font smaller(Font font, int decrement) {
            return new Font(font.getFontName(), font.getStyle(), font.getSize() - decrement);
        }

        private void runDefaultAction() {
            SearchResult result;
            SwingSearchBar.this.assertDispatchThread();
            SearchResult selectedResult = this.resultsList.getSelectedValue();
            if (selectedResult == null) {
                int firstResultIndex = this.firstResultIndex();
                if (firstResultIndex < 0) {
                    return;
                }
                result = this.result(firstResultIndex);
            } else {
                result = selectedResult;
            }
            List<SearchAction> actions = this.searchService.actions(result);
            if (actions.isEmpty()) {
                return;
            }
            SwingSearchBar.this.runAction(actions.get(0), true);
        }

        private void rebuild() {
            SwingSearchBar.this.assertDispatchThread();
            SearchResult previous = this.resultsList.getSelectedValue();
            List searchers = this.allResults.values().stream().map(event -> event.searcher()).collect(Collectors.toList());
            SwingSearchBar.this.pluginService.sort(searchers, Searcher.class);
            DefaultListModel<SearchResult> listModel = new DefaultListModel<SearchResult>();
            for (Searcher searcher : searchers) {
                List<SearchResult> completeResults = this.allResults.get(searcher.getClass()).results();
                if (completeResults == null) continue;
                int resultCount = completeResults.size();
                listModel.addElement(new SearchResultHeader(searcher, resultCount));
                if (completeResults.isEmpty()) continue;
                List results = completeResults.stream().limit(SwingSearchBar.this.resultLimit).collect(Collectors.toList());
                for (SearchResult result : results) {
                    listModel.addElement(result);
                }
            }
            this.resultsList.setModel(listModel);
            if (!SwingSearchBar.this.searchText.isEmpty()) {
                if (previous == null) {
                    if (listModel.getSize() > 0) {
                        this.resultsList.setSelectedIndex(this.firstResultIndex());
                    }
                } else if (listModel.contains(previous)) {
                    this.resultsList.setSelectedValue(previous, true);
                }
            }
        }

        private Component icon(String iconPath) {
            if (iconPath == null || iconPath.isEmpty()) {
                return this.emptyIcon();
            }
            URL iconURL = this.getClass().getResource(iconPath);
            if (iconURL == null) {
                return this.emptyIcon();
            }
            ImageIcon icon = new ImageIcon(iconURL);
            if (icon.getIconWidth() != 16 || icon.getIconHeight() != 16) {
                return this.emptyIcon();
            }
            return new JLabel(icon);
        }

        private Component emptyIcon() {
            return Box.createRigidArea(new Dimension(16, 16));
        }

        private boolean isHeader(SearchResult value) {
            return value instanceof SearchResultHeader;
        }

        private SearchResult result(int index) {
            SwingSearchBar.this.assertDispatchThread();
            return this.resultsList.getModel().getElementAt(index);
        }

        private int firstResultIndex() {
            SwingSearchBar.this.assertDispatchThread();
            for (int i = 0; i < this.rowCount(); ++i) {
                if (this.isHeader(this.result(i))) continue;
                return i;
            }
            return -1;
        }

        private void select(int i) {
            SwingSearchBar.this.assertDispatchThread();
            this.resultsList.setSelectedIndex(i);
            this.resultsList.ensureIndexIsVisible(this.isFirstNonHeader(i) ? 0 : i);
        }

        private boolean isFirstNonHeader(int index) {
            SwingSearchBar.this.assertDispatchThread();
            for (int i = index - 1; i >= 0; --i) {
                if (this.isHeader(this.result(i))) continue;
                return false;
            }
            return true;
        }

        private String highlightSearchUnderline(String text, String search) {
            return this.highlightSearch(text, search, "<u>", "</u>");
        }

        private String highlightSearchBold(String text, String search) {
            return this.highlightSearch(text, search, "<b>", "</b>");
        }

        private String highlightSearch(String text, String search, String before, String after) {
            String[] terms = search.split(" ");
            String output = new String(text);
            for (String term : terms) {
                ArrayList<Integer> res = new ArrayList<Integer>();
                int index = output.toLowerCase().indexOf(term);
                while (index >= 0) {
                    res.add(index);
                    index = output.toLowerCase().indexOf(term, index + 1);
                }
                for (int i = res.size() - 1; i >= 0; --i) {
                    int index2 = (Integer)res.get(i);
                    output = output.substring(0, index2) + before + output.substring(index2, index2 + term.length()) + after + output.substring(index2 + term.length(), output.length());
                }
            }
            return output;
        }

        private String escapeHtml(String s) {
            StringBuilder out = new StringBuilder(Math.max(16, s.length()));
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                    out.append("&#");
                    out.append((int)c);
                    out.append(';');
                    continue;
                }
                out.append(c);
            }
            return out.toString();
        }
    }
}

