/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.module;

import java.util.LinkedHashMap;
import java.util.Map;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.input.Accelerator;
import org.scijava.module.ModuleInfo;
import org.scijava.search.SearchResult;
import org.scijava.search.module.ModuleSearcher;

public class ModuleSearchResult
implements SearchResult {
    private final ModuleInfo info;
    private final Map<String, String> props;

    public ModuleSearchResult(ModuleInfo info, String baseDir) {
        this.info = info;
        this.props = new LinkedHashMap<String, String>();
        MenuPath menuPath = info.getMenuPath();
        if (menuPath != null && !menuPath.isEmpty()) {
            Accelerator accelerator;
            this.props.put("Menu path", this.getMenuPath(true));
            MenuEntry menuLeaf = menuPath.getLeaf();
            if (menuLeaf != null && (accelerator = menuLeaf.getAccelerator()) != null) {
                this.props.put("Shortcut", accelerator.toString());
            }
        }
        this.props.put("Identifier", info.getIdentifier());
        this.props.put("Location", ModuleSearcher.location(info, baseDir));
    }

    public ModuleInfo info() {
        return this.info;
    }

    @Override
    public String name() {
        return ModuleSearcher.title(this.info);
    }

    @Override
    public String identifier() {
        return this.name();
    }

    @Override
    public String context() {
        return "/" + this.getMenuPath(this.name() != "" + this.info.getMenuPath().getLeaf(), "/");
    }

    @Override
    public String iconPath() {
        return ModuleSearcher.iconPath(this.info);
    }

    @Override
    public Map<String, String> properties() {
        return this.props;
    }

    private String getMenuPath(boolean includeLeaf) {
        return this.getMenuPath(includeLeaf, " \u203a ");
    }

    private String getMenuPath(boolean includeLeaf, String separator) {
        MenuPath menuPath = this.info.getMenuPath();
        if (menuPath == null) {
            return "";
        }
        return menuPath.getMenuString(includeLeaf).replace(" > ", separator);
    }
}

