/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.PatternSyntaxException;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;
import org.scijava.search.SearchEvent;
import org.scijava.search.SearchListener;
import org.scijava.search.SearchOperation;
import org.scijava.search.SearchResult;
import org.scijava.search.SearchService;
import org.scijava.search.Searcher;
import org.scijava.thread.ThreadService;
import org.scijava.util.DebugUtils;

public class DefaultSearchOperation
implements SearchOperation {
    private static final int DELAY = 200;
    private final SearchListener[] listeners;
    private final List<SearchAttempt> currentSearches = new ArrayList<SearchAttempt>();
    @Parameter
    private SearchService searchService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private LogService log;
    private boolean active = true;
    private String query;
    private boolean fuzzy;
    private long lastModifyTime;

    public DefaultSearchOperation(Context context, SearchListener ... callbacks) {
        this.listeners = callbacks;
        context.inject(this);
        this.threadService.run(() -> {
            while (this.active) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException exc) {
                    this.log.error(exc);
                }
                if (this.lastModifyTime == 0L || System.currentTimeMillis() - this.lastModifyTime < 200L) continue;
                this.lastModifyTime = 0L;
                this.cancelCurrentSearches();
                for (Searcher searcher : this.searchers()) {
                    SearchAttempt search = new SearchAttempt(searcher);
                    this.currentSearches.add(search);
                    this.threadService.run(search);
                }
            }
            this.cancelCurrentSearches();
        });
    }

    @Override
    public void setFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
        this.refreshModifyTime();
    }

    @Override
    public void search(String text) {
        this.query = text;
        this.refreshModifyTime();
    }

    @Override
    public void terminate() {
        this.active = false;
    }

    private List<Searcher> searchers() {
        List<Searcher> searchers = this.pluginService.createInstancesOfType(Searcher.class);
        Optional<Searcher> exclusive = searchers.stream().filter(searcher -> searcher.exclusive(this.query)).findFirst();
        return exclusive.isPresent() ? Collections.singletonList(exclusive.get()) : searchers;
    }

    private void cancelCurrentSearches() {
        this.currentSearches.forEach(search -> search.invalidate());
        this.currentSearches.clear();
    }

    private void refreshModifyTime() {
        this.lastModifyTime = System.currentTimeMillis();
    }

    private class SearchAttempt
    implements Runnable {
        private final Searcher searcher;
        private boolean valid = true;

        private SearchAttempt(Searcher searcher) {
            this.searcher = searcher;
        }

        public void invalidate() {
            this.valid = false;
        }

        @Override
        public void run() {
            List<Object> results;
            boolean exclusive = this.searcher.exclusive(DefaultSearchOperation.this.query);
            boolean supported = this.searcher.supports(DefaultSearchOperation.this.query);
            boolean enabled = DefaultSearchOperation.this.searchService.enabled(this.searcher);
            if (!this.valid) {
                return;
            }
            try {
                results = !supported ? null : (!enabled ? Collections.emptyList() : this.searcher.search(DefaultSearchOperation.this.query, DefaultSearchOperation.this.fuzzy));
            }
            catch (Throwable t) {
                results = Collections.singletonList(new SearchResult(){
                    private final Map<String, String> props = Collections.singletonMap(null, this.errorMessage());

                    @Override
                    public String name() {
                        return "<error>";
                    }

                    @Override
                    public String iconPath() {
                        return null;
                    }

                    @Override
                    public Map<String, String> properties() {
                        return this.props;
                    }

                    private String errorMessage() {
                        if (t instanceof PatternSyntaxException) {
                            return this.pre(t.getMessage());
                        }
                        return this.pre(DebugUtils.getStackTrace(t));
                    }

                    private String pre(String s) {
                        return "<pre style=\"font-size: 0.9em\">" + s + "</pre>";
                    }
                });
            }
            if (!this.valid) {
                return;
            }
            for (SearchListener l : DefaultSearchOperation.this.listeners) {
                l.searchCompleted(new SearchEvent(this.searcher, results, exclusive));
            }
        }
    }
}

