/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imglib2.roi.AngleRegionOfInterest;
import org.scijava.Context;

public class AngleOverlay
extends AbstractROIOverlay<AngleRegionOfInterest> {
    private static final long serialVersionUID = 1L;

    public AngleOverlay() {
        super(new AngleRegionOfInterest(new double[2], new double[2], new double[2]));
    }

    public AngleOverlay(Context context) {
        super(context, new AngleRegionOfInterest(new double[2], new double[2], new double[2]));
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    public AngleOverlay(Context context, double[] ctr, double[] end1, double[] end2) {
        super(context, new AngleRegionOfInterest(new double[ctr.length], new double[end1.length], new double[end2.length]));
        assert (ctr.length == end1.length);
        assert (ctr.length == end2.length);
        AngleRegionOfInterest roi = (AngleRegionOfInterest)this.getRegionOfInterest();
        roi.setCenter(ctr);
        roi.setPoint1(end1);
        roi.setPoint2(end2);
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    public void getCenter(double[] pt) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).getCenter(pt);
    }

    public void getPoint1(double[] pt) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).getPoint1(pt);
    }

    public void getPoint2(double[] pt) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).getPoint2(pt);
    }

    public void setCenter(double[] pt) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).setCenter(pt);
    }

    public void setPoint1(double[] pt) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).setPoint1(pt);
    }

    public void setPoint2(double[] pt) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).setPoint2(pt);
    }

    public double getCenter(int dim) {
        return ((AngleRegionOfInterest)this.getRegionOfInterest()).getCenter(dim);
    }

    public double getPoint1(int dim) {
        return ((AngleRegionOfInterest)this.getRegionOfInterest()).getPoint1(dim);
    }

    public double getPoint2(int dim) {
        return ((AngleRegionOfInterest)this.getRegionOfInterest()).getPoint2(dim);
    }

    public void setCenter(double val, int dim) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).setCenter(val, dim);
    }

    public void setPoint1(double val, int dim) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).setPoint1(val, dim);
    }

    public void setPoint2(double val, int dim) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).setPoint2(val, dim);
    }

    @Override
    public int numDimensions() {
        return ((AngleRegionOfInterest)this.getRegionOfInterest()).numDimensions();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        super.writeExternal(out);
        AngleRegionOfInterest roi = (AngleRegionOfInterest)this.getRegionOfInterest();
        int numDims = roi.numDimensions();
        out.writeInt(numDims);
        for (i = 0; i < numDims; ++i) {
            out.writeDouble(roi.getPoint1(i));
        }
        for (i = 0; i < numDims; ++i) {
            out.writeDouble(roi.getCenter(i));
        }
        for (i = 0; i < numDims; ++i) {
            out.writeDouble(roi.getPoint2(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nDimensions = in.readInt();
        double[][] pts = new double[3][nDimensions];
        for (int i = 0; i < pts.length; ++i) {
            for (int j = 0; j < nDimensions; ++j) {
                pts[i][j] = in.readDouble();
            }
        }
        AngleRegionOfInterest roi = (AngleRegionOfInterest)this.getRegionOfInterest();
        roi.setPoint1(pts[0]);
        roi.setCenter(pts[1]);
        roi.setPoint2(pts[2]);
    }

    @Override
    public void move(double[] deltas) {
        ((AngleRegionOfInterest)this.getRegionOfInterest()).move(deltas);
    }
}

