/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.convert;

import java.lang.reflect.Type;
import net.imagej.Dataset;
import net.imglib2.img.Img;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ConversionUtils;
import org.scijava.util.GenericUtils;

@Plugin(type=Converter.class, priority=1.0)
public class DatasetToImgConverter
extends AbstractConverter<Dataset, Img> {
    public <T> T convert(Object src, Class<T> dest) {
        Dataset data = (Dataset)src;
        return (T)data.getImgPlus().getImg();
    }

    public Class<Img> getOutputType() {
        return Img.class;
    }

    public Class<Dataset> getInputType() {
        return Dataset.class;
    }

    public boolean canConvert(Object src, Type dest) {
        if (src == null) {
            return false;
        }
        Class destClass = GenericUtils.getClass((Type)dest);
        return this.canConvert(src, destClass);
    }

    public boolean canConvert(Object src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        Class<?> srcClass = src.getClass();
        if (Dataset.class.isAssignableFrom(srcClass)) {
            Dataset data = (Dataset)src;
            srcClass = data.getImgPlus().getImg().getClass();
            return ConversionUtils.canCast(srcClass, dest);
        }
        return false;
    }
}

