/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.fileloader;

import com.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class CsvPlotReader {
    public static String TIME_COLUMN = "time";

    public List<Map<String, Object>> read(String fileName) throws IOException {
        String[] row;
        CSVReader reader = new CSVReader((Reader)new FileReader(fileName));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String[] header = this.getHeader(reader);
        while ((row = reader.readNext()) != null) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            int index = 0;
            for (String hc : header) {
                if (hc.equals(TIME_COLUMN)) {
                    entry.put(hc, this.convertDate(row[index++]));
                    continue;
                }
                entry.put(hc, this.convertToNumber(row[index++]));
            }
            result.add(entry);
        }
        return result;
    }

    private Object convertToNumber(Object value) {
        if (value instanceof String && NumberUtils.isCreatable((String)((String)value))) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (Exception exception) {
                try {
                    return new BigInteger((String)value);
                }
                catch (Exception exception2) {
                    return Float.valueOf(Float.parseFloat((String)value));
                }
            }
        }
        return value;
    }

    private Object convertDate(Object x) {
        if (x instanceof Number) {
            return x;
        }
        if (x instanceof Date) {
            Date date = (Date)x;
            return date;
        }
        if (x instanceof String) {
            Date inputDate = null;
            try {
                inputDate = new SimpleDateFormat("yyyy-MM-dd").parse((String)x);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("time column accepts String date in a following format yyyy-MM-dd");
            }
            return inputDate;
        }
        throw new IllegalArgumentException("time column accepts numbers or java.util.Date objects or String date in a following format yyyy-MM-dd");
    }

    private String[] getHeader(CSVReader reader) throws IOException {
        return reader.readNext();
    }
}

