/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.twosigma.beakerx.CodeCell;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jupyter.Displayer;
import jupyter.Displayers;

public class BeakerxToStringDisplayer
extends Displayer<Object> {
    private static final BeakerxToStringDisplayer INSTANCE = new BeakerxToStringDisplayer();

    BeakerxToStringDisplayer() {
    }

    public static Displayer<Object> get() {
        return INSTANCE;
    }

    public Map<String, String> display(Object obj) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (obj.getClass().isArray()) {
            result.put("text/plain", this.displayArray(obj));
        } else if (obj instanceof CodeCell) {
            StringBuilder sb = new StringBuilder("Cell Type:" + ((CodeCell)obj).getCellType()).append(System.getProperty("line.separator"));
            sb.append("Execution Count:").append(((CodeCell)obj).getExecutionCount()).append(System.getProperty("line.separator"));
            sb.append("Metadata:").append(((CodeCell)obj).getMetadata()).append(System.getProperty("line.separator"));
            sb.append("Source:").append(((CodeCell)obj).getSource());
            result.put("text/plain", sb.toString());
        } else {
            result.put("text/plain", obj.toString());
        }
        return result;
    }

    private String displayArray(Object obj) {
        Class<?> type = obj.getClass().getComponentType();
        if (type == Boolean.TYPE) {
            return Arrays.toString((boolean[])obj);
        }
        if (type == Byte.TYPE) {
            return Arrays.toString((byte[])obj);
        }
        if (type == Short.TYPE) {
            return Arrays.toString((short[])obj);
        }
        if (type == Integer.TYPE) {
            return Arrays.toString((int[])obj);
        }
        if (type == Long.TYPE) {
            return Arrays.toString((long[])obj);
        }
        if (type == Float.TYPE) {
            return Arrays.toString((float[])obj);
        }
        if (type == Double.TYPE) {
            return Arrays.toString((double[])obj);
        }
        if (type == Character.TYPE) {
            return Arrays.toString((char[])obj);
        }
        Object[] arr = (Object[])obj;
        StringBuilder sb = new StringBuilder();
        sb.append("[").append((String)Displayers.display((Object)arr[0]).get("text/plain"));
        for (int i = 1; i < arr.length; ++i) {
            String asText = (String)Displayers.display((Object)arr[i]).get("text/plain");
            sb.append(", ").append(asText);
        }
        sb.append("]");
        return sb.toString();
    }
}

