/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.javascript;

import java.lang.reflect.InvocationTargetException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.AdaptedScriptLanguage;
import org.scijava.script.ScriptLanguage;
import org.scijava.util.ClassUtils;

@Plugin(type=ScriptLanguage.class, name="JavaScript")
public class JavaScriptScriptLanguage
extends AdaptedScriptLanguage {
    @Parameter
    private LogService log;

    public JavaScriptScriptLanguage() {
        super("javascript");
    }

    public boolean isNashorn() {
        return this.getEngineName().contains("Nashorn");
    }

    public boolean isRhino() {
        return this.getEngineName().contains("Rhino");
    }

    public boolean isOpenJDK() {
        String vmName = System.getProperty("java.vm.name");
        return vmName != null && vmName.startsWith("OpenJDK");
    }

    public ScriptEngine getScriptEngine() {
        ScriptEngine engine = super.getScriptEngine();
        try {
            if (this.isNashorn()) {
                engine.eval("load(\"nashorn:mozilla_compat.js\");");
            }
            if (this.isRhino()) {
                engine.eval("function load(path) {\n  importClass(Packages." + this.contextClass(engine) + ");\n  importClass(Packages.java.io.FileReader);\n  var cx = Context.getCurrentContext();\n  cx.evaluateReader(this, new FileReader(path), path, 1, null);\n}");
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return engine;
    }

    public Object decode(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        String packageName = objectClass.getPackage().getName();
        Class wrapperClass = ClassUtils.loadClass((String)(packageName + ".Wrapper"));
        if (wrapperClass == null || !wrapperClass.isAssignableFrom(objectClass)) {
            return object;
        }
        try {
            return wrapperClass.getMethod("unwrap", new Class[0]).invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException exc) {
            this.log.warn((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            this.log.warn((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            this.log.warn((Throwable)exc);
        }
        catch (NoSuchMethodException exc) {
            this.log.warn((Throwable)exc);
        }
        return null;
    }

    private String contextClass(ScriptEngine engine) {
        if (this.isNashorn()) {
            return "jdk.nashorn.internal.runtime.Context";
        }
        String engineClassName = engine.getClass().getName();
        if (this.isRhino()) {
            if (engineClassName.startsWith("com.sun.")) {
                if (this.isOpenJDK()) {
                    return "sun.org.mozilla.javascript.Context";
                }
                return "sun.org.mozilla.javascript.internal.Context";
            }
            return "org.mozilla.javascript.Context";
        }
        throw new UnsupportedOperationException("Unknown JavaScript flavor: " + engineClassName);
    }
}

