/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.renyiEntropy;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.RenyiEntropy.class, priority=100.0)
public class ComputeRenyiEntropyThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.RenyiEntropy {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        int beta3;
        int beta2;
        int beta1;
        int tmp_var;
        double tot_ent;
        double ent_obj;
        double ent_back;
        int it;
        int ih;
        long[] histogram = hist.toLongArray();
        double[] norm_histo = new double[histogram.length];
        double[] P1 = new double[histogram.length];
        double[] P2 = new double[histogram.length];
        int total = 0;
        for (ih = 0; ih < histogram.length; ++ih) {
            total = (int)((long)total + histogram[ih]);
        }
        for (ih = 0; ih < histogram.length; ++ih) {
            norm_histo[ih] = (double)histogram[ih] / (double)total;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        for (ih = 1; ih < histogram.length; ++ih) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
        }
        int first_bin = 0;
        for (ih = 0; ih < histogram.length; ++ih) {
            if (Math.abs(P1[ih]) < 2.220446049250313E-16) continue;
            first_bin = ih;
            break;
        }
        int last_bin = histogram.length - 1;
        for (ih = histogram.length - 1; ih >= first_bin; --ih) {
            if (Math.abs(P2[ih]) < 2.220446049250313E-16) continue;
            last_bin = ih;
            break;
        }
        int threshold = 0;
        double max_ent = 0.0;
        for (it = first_bin; it <= last_bin; ++it) {
            ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                if (histogram[ih] == 0L) continue;
                ent_back -= norm_histo[ih] / P1[it] * Math.log(norm_histo[ih] / P1[it]);
            }
            ent_obj = 0.0;
            for (ih = it + 1; ih < histogram.length; ++ih) {
                if (histogram[ih] == 0L) continue;
                ent_obj -= norm_histo[ih] / P2[it] * Math.log(norm_histo[ih] / P2[it]);
            }
            tot_ent = ent_back + ent_obj;
            if (!(max_ent < tot_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        int t_star2 = threshold;
        threshold = 0;
        max_ent = 0.0;
        double alpha = 0.5;
        double term = 1.0 / (1.0 - alpha);
        for (it = first_bin; it <= last_bin; ++it) {
            ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                ent_back += Math.sqrt(norm_histo[ih] / P1[it]);
            }
            ent_obj = 0.0;
            for (ih = it + 1; ih < histogram.length; ++ih) {
                ent_obj += Math.sqrt(norm_histo[ih] / P2[it]);
            }
            tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
            if (!(tot_ent > max_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        int t_star1 = threshold;
        threshold = 0;
        max_ent = 0.0;
        alpha = 2.0;
        term = 1.0 / (1.0 - alpha);
        for (it = first_bin; it <= last_bin; ++it) {
            ent_back = 0.0;
            for (ih = 0; ih <= it; ++ih) {
                ent_back += norm_histo[ih] * norm_histo[ih] / (P1[it] * P1[it]);
            }
            ent_obj = 0.0;
            for (ih = it + 1; ih < histogram.length; ++ih) {
                ent_obj += norm_histo[ih] * norm_histo[ih] / (P2[it] * P2[it]);
            }
            tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
            if (!(tot_ent > max_ent)) continue;
            max_ent = tot_ent;
            threshold = it;
        }
        int t_star3 = threshold;
        if (t_star2 < t_star1) {
            tmp_var = t_star1;
            t_star1 = t_star2;
            t_star2 = tmp_var;
        }
        if (t_star3 < t_star2) {
            tmp_var = t_star2;
            t_star2 = t_star3;
            t_star3 = tmp_var;
        }
        if (t_star2 < t_star1) {
            tmp_var = t_star1;
            t_star1 = t_star2;
            t_star2 = tmp_var;
        }
        if (Math.abs(t_star1 - t_star2) <= 5) {
            if (Math.abs(t_star2 - t_star3) <= 5) {
                beta1 = 1;
                beta2 = 2;
                beta3 = 1;
            } else {
                beta1 = 0;
                beta2 = 1;
                beta3 = 3;
            }
        } else if (Math.abs(t_star2 - t_star3) <= 5) {
            beta1 = 3;
            beta2 = 1;
            beta3 = 0;
        } else {
            beta1 = 1;
            beta2 = 2;
            beta3 = 1;
        }
        double omega = P1[t_star3] - P1[t_star1];
        int opt_threshold = (int)((double)t_star1 * (P1[t_star1] + 0.25 * omega * (double)beta1) + 0.25 * (double)t_star2 * omega * (double)beta2 + (double)t_star3 * (P2[t_star3] + 0.25 * omega * (double)beta3));
        return opt_threshold;
    }
}

