/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.thread.chunker;

import java.util.ArrayList;
import java.util.concurrent.Future;
import net.imagej.ops.Ops;
import net.imagej.ops.thread.chunker.AbstractChunker;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Thread.Chunker.class, priority=-10000.0)
public class ChunkerInterleaved
extends AbstractChunker {
    @Parameter
    public LogService logService;
    private String cancellationMsg;

    public void run() {
        final int numThreads = Runtime.getRuntime().availableProcessors();
        final int numStepsFloor = (int)(this.numberOfElements / (long)numThreads);
        final int remainder = (int)this.numberOfElements - numStepsFloor * numThreads;
        ArrayList<Future> futures = new ArrayList<Future>(numThreads);
        int i = 0;
        while (i < numThreads) {
            final int j = i++;
            futures.add(this.threadService.run(new Runnable(){

                @Override
                public void run() {
                    if (j < remainder) {
                        ChunkerInterleaved.this.chunkable.execute(j, numThreads, numStepsFloor + 1);
                    } else {
                        ChunkerInterleaved.this.chunkable.execute(j, numThreads, numStepsFloor);
                    }
                }
            }));
        }
        for (Future future : futures) {
            try {
                if (this.isCanceled()) break;
                future.get();
            }
            catch (Exception e) {
                this.logService.error((Throwable)e);
                this.cancellationMsg = e.getMessage();
                break;
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.cancellationMsg != null;
    }

    @Override
    public String getCancelReason() {
        return this.cancellationMsg;
    }
}

