/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.thin;

import net.imagej.ops.morphology.thin.Abstract3x3NeighbourhoodThinning;
import net.imagej.ops.morphology.thin.ThinningStrategy;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.type.logic.BitType;
import org.scijava.plugin.Plugin;

@Plugin(type=ThinningStrategy.class, name="GuoHall")
public class GuoHallThinningStrategy
extends Abstract3x3NeighbourhoodThinning {
    public GuoHallThinningStrategy() {
    }

    public GuoHallThinningStrategy(boolean foreground) {
        super(foreground);
    }

    @Override
    public boolean removePixel(long[] position, RandomAccessible<BitType> accessible, int iteration) {
        boolean oddEvenCheck;
        int sectorsTwo;
        RandomAccess access = accessible.randomAccess();
        access.setPosition(position);
        boolean[] vals = this.getNeighbourhood((RandomAccess<BitType>)access);
        int simpleConnectedNeighbours = 0;
        if (vals[1] == this.m_background && (vals[2] == this.m_foreground || vals[3] == this.m_foreground)) {
            ++simpleConnectedNeighbours;
        }
        if (vals[3] == this.m_background && (vals[4] == this.m_foreground || vals[5] == this.m_foreground)) {
            ++simpleConnectedNeighbours;
        }
        if (vals[5] == this.m_background && (vals[6] == this.m_foreground || vals[7] == this.m_foreground)) {
            ++simpleConnectedNeighbours;
        }
        if (vals[7] == this.m_background && (vals[8] == this.m_foreground || vals[1] == this.m_foreground)) {
            ++simpleConnectedNeighbours;
        }
        if (simpleConnectedNeighbours != 1) {
            return false;
        }
        int sectorsOne = this.countSectors(vals, -1);
        int minSectors = Math.min(sectorsOne, sectorsTwo = this.countSectors(vals, 1));
        if (2 > minSectors || minSectors > 3) {
            return false;
        }
        if (iteration % 2 == 1) {
            oddEvenCheck = (vals[1] == this.m_foreground || vals[2] == this.m_foreground || vals[4] == this.m_background) && vals[3] == this.m_foreground;
        } else {
            boolean bl = oddEvenCheck = (vals[5] == this.m_foreground || vals[6] == this.m_foreground || vals[8] == this.m_background) && vals[7] == this.m_foreground;
        }
        return !oddEvenCheck;
    }

    private int countSectors(boolean[] vals, int offset) {
        int res = 0;
        for (int i = 1; i < vals.length - 1; i += 2) {
            if (i + offset == 0) {
                if (vals[1] != this.m_foreground && vals[8] != this.m_foreground) continue;
                ++res;
                continue;
            }
            if (vals[i] != this.m_foreground && vals[i + offset] != this.m_foreground) continue;
            ++res;
        }
        return res;
    }

    @Override
    public int getIterationsPerCycle() {
        return 2;
    }

    @Override
    public ThinningStrategy copy() {
        return new GuoHallThinningStrategy(this.m_foreground);
    }
}

