/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.close;

import java.util.List;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.map.Maps;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCF;
import net.imagej.ops.special.hybrid.BinaryHybridCF;
import net.imagej.ops.special.hybrid.Hybrids;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Morphology.Close.class)
public class ListClose<T extends RealType<T>>
extends AbstractBinaryHybridCF<RandomAccessibleInterval<T>, List<Shape>, IterableInterval<T>>
implements Ops.Morphology.Close,
Contingent {
    private T maxVal;
    private UnaryFunctionOp<Interval, Img<T>> imgCreator;
    private BinaryHybridCF<RandomAccessibleInterval<T>, List<Shape>, IterableInterval<T>> dilateComputer;
    private BinaryHybridCF<RandomAccessibleInterval<T>, List<Shape>, IterableInterval<T>> erodeComputer;

    @Override
    public boolean conforms() {
        return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (IterableInterval)this.out());
    }

    @Override
    public void initialize() {
        this.maxVal = (RealType)((RealType)Util.getTypeFromInterval((Interval)((Interval)this.in()))).createVariable();
        this.maxVal.setReal(this.maxVal.getMaxValue());
        this.imgCreator = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, this.in(), this.maxVal.createVariable());
        this.dilateComputer = Hybrids.binaryCF(this.ops(), Ops.Morphology.Dilate.class, this.out(), this.in1(), this.in2(), false);
        this.erodeComputer = Hybrids.binaryCF(this.ops(), Ops.Morphology.Erode.class, this.out(), this.in1(), this.in2(), false);
    }

    @Override
    public IterableInterval<T> createOutput(RandomAccessibleInterval<T> in1, List<Shape> in2) {
        return (IterableInterval)this.erodeComputer.createOutput(in1, in2);
    }

    @Override
    public void compute(RandomAccessibleInterval<T> in1, List<Shape> in2, IterableInterval<T> out) {
        Img<T> buffer = this.imgCreator.calculate((Interval)out);
        this.dilateComputer.compute(in1, in2, (IterableInterval<T>)buffer);
        this.erodeComputer.compute((RandomAccessibleInterval<T>)Views.interval((RandomAccessible)Views.extendValue(buffer, this.maxVal), out), in2, out);
    }
}

