/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter;

import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import org.scijava.plugin.Parameter;

public abstract class AbstractFilterF<I extends RealType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K>, C extends ComplexType<C> & NativeType<C>>
extends AbstractBinaryFunctionOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> {
    @Parameter(required=false)
    private long[] borderSize = null;
    @Parameter(required=false)
    private OutOfBoundsFactory<I, RandomAccessibleInterval<I>> obfInput;
    @Parameter(required=false)
    private OutOfBoundsFactory<K, RandomAccessibleInterval<K>> obfKernel;
    @Parameter(required=false)
    private Type<O> outType;
    private BinaryFunctionOp<RandomAccessibleInterval<I>, Dimensions, RandomAccessibleInterval<I>> padOp;
    private BinaryFunctionOp<RandomAccessibleInterval<K>, Dimensions, RandomAccessibleInterval<K>> padKernelOp;

    public BinaryFunctionOp<RandomAccessibleInterval<I>, Dimensions, RandomAccessibleInterval<I>> getPadOp() {
        return this.padOp;
    }

    public void setPadOp(BinaryFunctionOp<RandomAccessibleInterval<I>, Dimensions, RandomAccessibleInterval<I>> padOp) {
        this.padOp = padOp;
    }

    public BinaryFunctionOp<RandomAccessibleInterval<K>, Dimensions, RandomAccessibleInterval<K>> getPadKernelOp() {
        return this.padKernelOp;
    }

    public void setPadKernelOp(BinaryFunctionOp<RandomAccessibleInterval<K>, Dimensions, RandomAccessibleInterval<K>> padKernelOp) {
        this.padKernelOp = padKernelOp;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.obfInput == null) {
            this.obfInput = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        }
    }

    public RandomAccessibleInterval<O> createOutput(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel) {
        if (this.outType == null) {
            if (((RealType)Util.getTypeFromInterval(input)).getClass() == ((RealType)Util.getTypeFromInterval(kernel)).getClass()) {
                Type temp;
                this.outType = temp = ((RealType)Util.getTypeFromInterval(input)).createVariable();
            } else {
                FloatType temp = new FloatType();
                this.outType = (Type)temp;
            }
        }
        return this.ops().create().img((Dimensions)input, (NativeType)this.outType.createVariable());
    }

    @Override
    public RandomAccessibleInterval<O> calculate(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel) {
        int d;
        RandomAccessibleInterval<O> output = this.createOutput(input, kernel);
        int numDimensions = input.numDimensions();
        long[] paddedSize = new long[numDimensions];
        if (this.borderSize == null) {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = (int)input.dimension(d) + (int)kernel.dimension(d) - 1;
            }
        } else {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = Math.max(kernel.dimension(d) + 2L * this.borderSize[d], input.dimension(d) + 2L * this.borderSize[d]);
            }
        }
        RandomAccessibleInterval<I> paddedInput = this.padOp.calculate(input, (Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<K> paddedKernel = this.padKernelOp.calculate(kernel, (Dimensions)new FinalDimensions(paddedSize));
        this.computeFilter(paddedInput, paddedKernel, output, paddedSize);
        return output;
    }

    protected abstract void computeFilter(RandomAccessibleInterval<I> var1, RandomAccessibleInterval<K> var2, RandomAccessibleInterval<O> var3, long[] var4);

    protected long[] getBorderSize() {
        return this.borderSize;
    }

    protected OutOfBoundsFactory<I, RandomAccessibleInterval<I>> getOBFInput() {
        return this.obfInput;
    }

    protected void setOBFInput(OutOfBoundsFactory<I, RandomAccessibleInterval<I>> objInput) {
        this.obfInput = objInput;
    }

    protected OutOfBoundsFactory<K, RandomAccessibleInterval<K>> getOBFKernel() {
        return this.obfKernel;
    }

    protected void setOBFKernel(OutOfBoundsFactory<K, RandomAccessibleInterval<K>> obfKernel) {
        this.obfKernel = obfKernel;
    }

    protected Type<O> getOutType() {
        return this.outType;
    }
}

