/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.hog;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.create.img.CreateImgFromDimsAndType;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imagej.ops.thread.chunker.CursorBasedChunk;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import net.imglib2.view.composite.GenericComposite;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.HoG.HistogramOfOrientedGradients.class)
public class HistogramOfOrientedGradients2D<T extends RealType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.HoG.HistogramOfOrientedGradients,
Contingent {
    @Parameter(required=true)
    private int numOrientations;
    @Parameter(required=true)
    private int spanOfNeighborhood;
    private UnaryFunctionOp<FinalInterval, RandomAccessibleInterval> createOp;
    private UnaryFunctionOp<FinalInterval, RandomAccessibleInterval> createImgOp;
    private Converter<T, FloatType> converterToFloat;
    private Converter<GenericComposite<FloatType>, FloatType> converterGetMax;
    private ExecutorService es;
    @Parameter
    private ThreadService ts;

    @Override
    public void initialize() {
        this.es = this.ts.getExecutorService();
        this.createOp = Functions.unary(this.ops(), CreateImgFromDimsAndType.class, RandomAccessibleInterval.class, new FinalInterval(new long[]{((RandomAccessibleInterval)this.in()).dimension(0), ((RandomAccessibleInterval)this.in()).dimension(1), this.numOrientations}), new FloatType());
        this.createImgOp = Functions.unary(this.ops(), CreateImgFromDimsAndType.class, RandomAccessibleInterval.class, new FinalInterval(new long[]{((RandomAccessibleInterval)this.in()).dimension(0), ((RandomAccessibleInterval)this.in()).dimension(1)}), new FloatType());
        this.converterToFloat = new Converter<T, FloatType>(){

            public void convert(T arg0, FloatType arg1) {
                arg1.setReal(arg0.getRealFloat());
            }
        };
        this.converterGetMax = new Converter<GenericComposite<FloatType>, FloatType>(){

            public void convert(GenericComposite<FloatType> input, FloatType output) {
                int idx = 0;
                float max = 0.0f;
                int i = 0;
                while ((long)i < ((RandomAccessibleInterval)HistogramOfOrientedGradients2D.this.in()).dimension(2)) {
                    if (Math.abs(((FloatType)input.get((long)i)).getRealFloat()) > max) {
                        max = Math.abs(((FloatType)input.get((long)i)).getRealFloat());
                        idx = i;
                    }
                    ++i;
                }
                output.setReal(((FloatType)input.get((long)idx)).getRealFloat());
            }
        };
    }

    @Override
    public RandomAccessibleInterval<T> createOutput(RandomAccessibleInterval<T> in) {
        return this.createOp.calculate(new FinalInterval(new long[]{((RandomAccessibleInterval)this.in()).dimension(0), ((RandomAccessibleInterval)this.in()).dimension(1), this.numOrientations}));
    }

    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == 2 || ((RandomAccessibleInterval)this.in()).numDimensions() == 3;
    }

    @Override
    public void compute(RandomAccessibleInterval<T> in, RandomAccessibleInterval<T> out) {
        RandomAccessible convertedIn = Converters.convert((RandomAccessible)Views.extendMirrorDouble(in), this.converterToFloat, (Type)new FloatType());
        RandomAccessibleInterval derivative0 = this.createImgOp.calculate();
        RandomAccessibleInterval derivative1 = this.createImgOp.calculate();
        if (in.numDimensions() == 2) {
            PartialDerivative.gradientCentralDifference((RandomAccessible)convertedIn, (RandomAccessibleInterval)derivative0, (int)0);
            PartialDerivative.gradientCentralDifference((RandomAccessible)convertedIn, (RandomAccessibleInterval)derivative1, (int)1);
        } else {
            ArrayList<RandomAccessibleInterval> listDerivs0 = new ArrayList<RandomAccessibleInterval>();
            ArrayList<RandomAccessibleInterval> listDerivs1 = new ArrayList<RandomAccessibleInterval>();
            int i = 0;
            while ((long)i < in.dimension(2)) {
                RandomAccessibleInterval deriv0 = this.createImgOp.calculate();
                RandomAccessibleInterval deriv1 = this.createImgOp.calculate();
                PartialDerivative.gradientCentralDifference((RandomAccessible)Views.interval((RandomAccessible)convertedIn, (long[])new long[]{0L, 0L, i}, (long[])new long[]{in.max(0), in.max(1), i}), (RandomAccessibleInterval)deriv0, (int)0);
                PartialDerivative.gradientCentralDifference((RandomAccessible)Views.interval((RandomAccessible)convertedIn, (long[])new long[]{0L, 0L, i}, (long[])new long[]{in.max(0), in.max(1), i}), (RandomAccessibleInterval)deriv1, (int)1);
                listDerivs0.add(deriv0);
                listDerivs1.add(deriv1);
                ++i;
            }
            derivative0 = Converters.convert((RandomAccessibleInterval)Views.collapse((RandomAccessibleInterval)Views.stack(listDerivs0)), this.converterGetMax, (Type)new FloatType());
            derivative1 = Converters.convert((RandomAccessibleInterval)Views.collapse((RandomAccessibleInterval)Views.stack(listDerivs1)), this.converterGetMax, (Type)new FloatType());
        }
        final RandomAccessibleInterval finalderivative0 = derivative0;
        final RandomAccessibleInterval finalderivative1 = derivative1;
        final RandomAccessibleInterval angles = this.createImgOp.calculate();
        final RandomAccessibleInterval magnitudes = this.createImgOp.calculate();
        CursorBasedChunk chunkable = new CursorBasedChunk(){

            @Override
            public void execute(int startIndex, int stepSize, int numSteps) {
                Cursor cursorAngles = Views.flatIterable((RandomAccessibleInterval)angles).localizingCursor();
                Cursor cursorMagnitudes = Views.flatIterable((RandomAccessibleInterval)magnitudes).localizingCursor();
                Cursor cursorDerivative0 = Views.flatIterable((RandomAccessibleInterval)finalderivative0).localizingCursor();
                Cursor cursorDerivative1 = Views.flatIterable((RandomAccessibleInterval)finalderivative1).localizingCursor();
                3.setToStart(cursorAngles, startIndex);
                3.setToStart(cursorMagnitudes, startIndex);
                3.setToStart(cursorDerivative0, startIndex);
                3.setToStart(cursorDerivative1, startIndex);
                for (int i = 0; i < numSteps; ++i) {
                    float x = ((FloatType)cursorDerivative0.get()).getRealFloat();
                    float y = ((FloatType)cursorDerivative1.get()).getRealFloat();
                    ((FloatType)cursorAngles.get()).setReal(HistogramOfOrientedGradients2D.this.getAngle(x, y));
                    ((FloatType)cursorMagnitudes.get()).setReal(HistogramOfOrientedGradients2D.this.getMagnitude(x, y));
                    cursorAngles.jumpFwd((long)stepSize);
                    cursorMagnitudes.jumpFwd((long)stepSize);
                    cursorDerivative0.jumpFwd((long)stepSize);
                    cursorDerivative1.jumpFwd((long)stepSize);
                }
            }
        };
        this.ops().thread().chunker(chunkable, Views.flatIterable((RandomAccessibleInterval)magnitudes).size());
        ArrayList<ComputeDescriptor> listCallables = new ArrayList<ComputeDescriptor>();
        RectangleShape shape = new RectangleShape(this.spanOfNeighborhood, false);
        RectangleShape.NeighborhoodsAccessible neighborHood = shape.neighborhoodsRandomAccessible((RandomAccessible)angles);
        int i = 0;
        while ((long)i < in.dimension(0)) {
            listCallables.add(new ComputeDescriptor((RandomAccessibleInterval<FloatType>)Views.interval((RandomAccessible)convertedIn, in), i, (RandomAccess<FloatType>)angles.randomAccess(), (RandomAccess<FloatType>)magnitudes.randomAccess(), (RandomAccess<FloatType>)out.randomAccess(), (RandomAccess<Neighborhood<FloatType>>)neighborHood.randomAccess()));
            ++i;
        }
        try {
            this.es.invokeAll(listCallables);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        listCallables.clear();
    }

    private double getAngle(double x, double y) {
        float angle = (float)Math.toDegrees(Math.atan2(x, y));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private double getMagnitude(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    private class ComputeDescriptor
    implements Callable<Void> {
        private final RandomAccessibleInterval<FloatType> in;
        private final long i;
        private final RandomAccess<FloatType> raAngles;
        private final RandomAccess<FloatType> raMagnitudes;
        private final RandomAccess<FloatType> raOut;
        private final RandomAccess<Neighborhood<FloatType>> raNeighbor;

        public ComputeDescriptor(RandomAccessibleInterval<FloatType> in, long i, RandomAccess<FloatType> raAngles, RandomAccess<FloatType> raMagnitudes, RandomAccess<FloatType> raOut, RandomAccess<Neighborhood<FloatType>> raNeighbor) {
            this.in = in;
            this.i = i;
            this.raAngles = raAngles;
            this.raMagnitudes = raMagnitudes;
            this.raOut = raOut;
            this.raNeighbor = raNeighbor;
        }

        @Override
        public Void call() throws Exception {
            FinalInterval interval = new FinalInterval(new long[]{this.in.dimension(0), this.in.dimension(1)});
            int j = 0;
            while ((long)j < this.in.dimension(1)) {
                this.raNeighbor.setPosition(new long[]{this.i, j});
                Cursor cursorNeighborHood = ((Neighborhood)this.raNeighbor.get()).cursor();
                while (cursorNeighborHood.hasNext()) {
                    cursorNeighborHood.next();
                    if (!Intervals.contains((Interval)interval, (Localizable)cursorNeighborHood)) continue;
                    this.raAngles.setPosition((Localizable)cursorNeighborHood);
                    this.raMagnitudes.setPosition((Localizable)cursorNeighborHood);
                    this.raOut.setPosition(new long[]{this.i, j, (int)((double)(((FloatType)this.raAngles.get()).getRealFloat() / (float)(360 / HistogramOfOrientedGradients2D.this.numOrientations)) - 0.5)});
                    ((FloatType)this.raOut.get()).add((FloatType)this.raMagnitudes.get());
                }
                ++j;
            }
            return null;
        }
    }
}

