/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.deconvolve;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.correlate.CorrelateFFTC;
import net.imagej.ops.map.MapBinaryInplace1s;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.inplace.AbstractBinaryInplace1Op;
import net.imagej.ops.special.inplace.AbstractUnaryInplaceOp;
import net.imagej.ops.special.inplace.BinaryInplace1Op;
import net.imagej.ops.special.inplace.Inplaces;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Deconvolve.NormalizationFactor.class, priority=-100.0)
public class NonCirculantNormalizationFactor<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
extends AbstractUnaryInplaceOp<RandomAccessibleInterval<O>>
implements Ops.Deconvolve.NormalizationFactor {
    @Parameter
    private Dimensions k;
    @Parameter
    private Dimensions l;
    @Parameter
    RandomAccessibleInterval<C> fftInput;
    @Parameter
    RandomAccessibleInterval<C> fftKernel;
    @Parameter
    private Interval imgConvolutionInterval;
    private Img<O> normalization = null;
    private UnaryFunctionOp<Dimensions, Img<O>> create;
    private BinaryComputerOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> correlater;
    private DivideHandleZeroMap<O> divide;

    @Override
    public void initialize() {
        this.create = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, Dimensions.class, new Object[]{Util.getTypeFromInterval((Interval)((Interval)this.out()))});
        this.correlater = Computers.binary(this.ops(), CorrelateFFTC.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{this.fftInput, this.fftKernel, true, false});
        this.divide = new DivideHandleZeroMap();
        this.divide.setEnvironment(this.ops());
        this.divide.initialize();
    }

    @Override
    public void mutate(RandomAccessibleInterval<O> arg) {
        if (this.normalization == null) {
            this.normalization = this.create.calculate((Dimensions)this.imgConvolutionInterval);
            this.createNormalizationImageSemiNonCirculant();
        }
        this.divide.mutate1((IterableInterval<O>)this.normalization, (IterableInterval<O>)Views.iterable(arg));
    }

    protected void createNormalizationImageSemiNonCirculant() {
        int d;
        int length = this.k.numDimensions();
        long[] n = new long[length];
        long[] nFFT = new long[length];
        for (d = 0; d < length; ++d) {
            n[d] = this.k.dimension(d) + this.l.dimension(d) - 1L;
        }
        for (d = 0; d < length; ++d) {
            nFFT[d] = this.imgConvolutionInterval.dimension(d);
        }
        FinalDimensions fd = new FinalDimensions(nFFT);
        this.normalization = this.create.calculate((Dimensions)fd);
        Point size = new Point(length);
        long[] sizel = new long[length];
        for (int d2 = 0; d2 < length; ++d2) {
            size.setPosition(this.k.dimension(d2), d2);
            sizel[d2] = this.k.dimension(d2);
        }
        Point start = new Point(length);
        long[] startl = new long[length];
        long[] endl = new long[length];
        for (int d3 = 0; d3 < length; ++d3) {
            start.setPosition((nFFT[d3] - this.k.dimension(d3)) / 2L, d3);
            startl[d3] = (nFFT[d3] - this.k.dimension(d3)) / 2L;
            endl[d3] = startl[d3] + sizel[d3] - 1L;
        }
        Point maskSize = new Point(length);
        long[] maskSizel = new long[length];
        for (int d4 = 0; d4 < length; ++d4) {
            maskSize.setPosition(Math.min(n[d4], nFFT[d4]), d4);
            maskSizel[d4] = Math.min(n[d4], nFFT[d4]);
        }
        Point maskStart = new Point(length);
        long[] maskStartl = new long[length];
        for (int d5 = 0; d5 < length; ++d5) {
            maskStart.setPosition(Math.max(0L, nFFT[d5] - n[d5]) / 2L, d5);
            maskStartl[d5] = Math.max(0L, nFFT[d5] - n[d5]) / 2L;
        }
        IntervalView temp = Views.interval(this.normalization, (Interval)new FinalInterval(startl, endl));
        Cursor normCursor = Views.iterable((RandomAccessibleInterval)temp).cursor();
        while (normCursor.hasNext()) {
            normCursor.fwd();
            ((RealType)normCursor.get()).setReal(1.0);
        }
        Img<O> tempImg = this.create.calculate((Dimensions)fd);
        this.correlater.compute((RandomAccessibleInterval<Img<O>>)this.normalization, (RandomAccessibleInterval<Img<O>>)tempImg);
        this.normalization = tempImg;
        Cursor cursorN = this.normalization.cursor();
        while (cursorN.hasNext()) {
            cursorN.fwd();
            if (!(((RealType)cursorN.get()).getRealFloat() <= 0.001f)) continue;
            ((RealType)cursorN.get()).setReal(1.0f);
        }
    }

    private static class DivideHandleZeroOp<I extends RealType<I> & NumericType<I>, O extends RealType<O> & NumericType<O>>
    extends AbstractBinaryInplace1Op<I, I> {
        private DivideHandleZeroOp() {
        }

        @Override
        public void mutate1(I input, I outin) {
            RealType tmp = (RealType)outin.copy();
            if (outin.getRealFloat() > 0.0f) {
                tmp.set(outin);
                tmp.div(input);
                outin.set((Type)tmp);
            } else {
                outin.setReal(0.0);
            }
        }
    }

    private static class DivideHandleZeroMap<T extends RealType<T>>
    extends AbstractBinaryInplace1Op<IterableInterval<T>, IterableInterval<T>> {
        private BinaryInplace1Op<T, T, T> divide;
        private BinaryInplace1Op<IterableInterval<T>, IterableInterval<T>, IterableInterval<T>> map;

        private DivideHandleZeroMap() {
        }

        @Override
        public void initialize() {
            this.divide = new DivideHandleZeroOp();
            this.divide.setEnvironment(this.ops());
            this.divide.initialize();
            this.map = Inplaces.binary1(this.ops(), MapBinaryInplace1s.IIAndII.class, IterableInterval.class, IterableInterval.class, new Object[]{this.divide});
        }

        @Override
        public void mutate1(IterableInterval<T> input1, IterableInterval<T> input2) {
            this.map.mutate1(input1, input2);
        }
    }
}

