/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.commands.filter;

import java.util.Arrays;
import net.imagej.ops.OpService;
import net.imglib2.Dimensions;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Process>Filters>Frangi Vesselness")
public class FrangiVesselness<T extends RealType<T>>
implements Command {
    @Parameter
    private LogService log;
    @Parameter
    private OpService opService;
    @Parameter
    private Img<T> input;
    @Parameter(label="Apply Gaussian at each scale:")
    private boolean doGauss;
    @Parameter(label="Spacing", description="Relative distance between the observed data points")
    private String spacingString = "1, 1";
    @Parameter(label="Scale", description="Used as the sigma for the Gaussian filter, and as the scale for the vesselness filter.")
    private String scaleString = "2, 5";
    @Parameter(type=ItemIO.OUTPUT)
    private Img<FloatType> result;
    private double[] spacing;
    private int[] scales;
    private String regex = "(,|\\s)\\s*";

    private double[] checkDimensions(String in, int expectedDims, String arrName) {
        double[] result = Arrays.stream(in.split(this.regex)).mapToDouble(Double::parseDouble).toArray();
        if (result.length > expectedDims) {
            result = Arrays.copyOf(result, this.input.numDimensions());
            this.log.warn((Object)("Too many values were passed in " + arrName + " array. Removing " + (expectedDims - result.length) + " value(s)."));
        } else if (result.length < expectedDims) {
            int actual = result.length;
            result = Arrays.copyOf(result, expectedDims);
            Arrays.fill(result, actual, result.length, result[actual - 1]);
            this.log.warn((Object)("Not enough values were passed in the " + arrName + " array. The remaining indices were filled with the last value given."));
        }
        return result;
    }

    public void run() {
        this.spacing = this.checkDimensions(this.spacingString, this.input.numDimensions(), "Spacings");
        this.scales = Arrays.stream(this.scaleString.split(this.regex)).mapToInt(Integer::parseInt).toArray();
        IntervalView resultDims = Views.addDimension(this.input, (long)0L, (long)(this.scales.length - 1));
        this.result = this.opService.create().img((Dimensions)resultDims, new FloatType());
        for (int s = 0; s < this.scales.length; ++s) {
            Img<T> vesselnessInput = this.doGauss ? this.opService.filter().gauss(this.input, (double)this.scales[s]) : this.input;
            IntervalView scaleResult = Views.hyperSlice(this.result, (int)(this.result.numDimensions() - 1), (long)s);
            this.opService.filter().frangiVesselness(scaleResult, vesselnessInput, this.spacing, this.scales[s]);
        }
    }
}

