/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.cached;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.CustomOpEnvironment;
import net.imagej.ops.Op;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpRef;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.UnaryHybridCF;
import org.scijava.cache.CacheService;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.util.GenericUtils;

public class CachedOpEnvironment
extends CustomOpEnvironment {
    @Parameter
    private CacheService cs;
    private Collection<Class<?>> ignoredOps;

    public CachedOpEnvironment(OpEnvironment parent) {
        this(parent, null, new ArrayList());
    }

    public CachedOpEnvironment(OpEnvironment parent, Collection<? extends OpInfo> prioritizedInfos) {
        this(parent, prioritizedInfos, new ArrayList());
    }

    public CachedOpEnvironment(OpEnvironment parent, Collection<? extends OpInfo> prioritizedInfos, Collection<Class<?>> ignoredOps) {
        super(parent, prioritizedInfos);
        if (prioritizedInfos != null) {
            for (OpInfo opInfo : prioritizedInfos) {
                opInfo.cInfo().setPriority(Double.POSITIVE_INFINITY);
            }
        }
        this.ignoredOps = ignoredOps;
    }

    @Override
    public Op op(OpRef ref) {
        CachedFunctionOp cachedOp;
        Op op = super.op(ref);
        for (Class<?> ignored : this.ignoredOps) {
            for (Type t : ref.getTypes()) {
                Class raw = GenericUtils.getClass((Type)t);
                if (!ignored.isAssignableFrom(raw)) continue;
                return op;
            }
        }
        if (op instanceof UnaryHybridCF) {
            cachedOp = this.wrapUnaryHybrid((UnaryHybridCF)op);
        } else if (op instanceof UnaryFunctionOp) {
            cachedOp = this.wrapUnaryFunction((UnaryFunctionOp)op);
        } else {
            return op;
        }
        this.getContext().inject(cachedOp);
        return cachedOp;
    }

    private <I, O> CachedFunctionOp<I, O> wrapUnaryFunction(UnaryFunctionOp<I, O> op) {
        return new CachedFunctionOp<I, O>(op, this.otherArgs(op, 1));
    }

    private <I, O> CachedHybridOp<I, O> wrapUnaryHybrid(UnaryHybridCF<I, O> op) {
        return new CachedHybridOp<I, O>(op, this.otherArgs(op, 2));
    }

    private Object[] otherArgs(Op op, int offset) {
        CommandInfo cInfo = this.info(op).cInfo();
        Module module = cInfo.createModule((Command)op);
        ArrayList<Object> args = new ArrayList<Object>();
        int i = 0;
        for (ModuleItem input : cInfo.inputs()) {
            if (i++ < offset) continue;
            args.add(input.getValue(module));
        }
        return args.toArray();
    }

    private class Hash {
        private final int hash;

        public Hash(Object o1, Object o2, Object[] args) {
            this.hash = Objects.hash(o1, o2.getClass(), Arrays.hashCode(args));
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Hash) {
                return this.hash == ((Hash)obj).hash;
            }
            return false;
        }
    }

    class CachedHybridOp<I, O>
    extends CachedFunctionOp<I, O>
    implements UnaryHybridCF<I, O> {
        @Parameter
        private CacheService cache;
        private final UnaryHybridCF<I, O> delegate;
        private final Object[] args;

        public CachedHybridOp(UnaryHybridCF<I, O> delegate, Object[] args) {
            super(delegate, args);
            this.delegate = delegate;
            this.args = args;
        }

        @Override
        public O calculate(I input) {
            Hash hash = new Hash(input, this.delegate, this.args);
            Object output = this.cache.get((Object)hash);
            if (output == null) {
                output = this.createOutput(input);
                this.compute(input, output);
                this.cache.put((Object)hash, output);
            }
            return (O)output;
        }

        @Override
        public O createOutput(I input) {
            return (O)this.delegate.createOutput(input);
        }

        @Override
        public void compute(I input, O output) {
            this.delegate.compute(input, output);
        }

        @Override
        public void setOutput(O output) {
            this.delegate.setOutput(output);
        }

        @Override
        public CachedHybridOp<I, O> getIndependentInstance() {
            return this;
        }
    }

    class CachedFunctionOp<I, O>
    extends AbstractOp
    implements UnaryFunctionOp<I, O> {
        @Parameter
        private CacheService cache;
        private final UnaryFunctionOp<I, O> delegate;
        private final Object[] args;

        public CachedFunctionOp(UnaryFunctionOp<I, O> delegate, Object[] args) {
            this.delegate = delegate;
            this.args = args;
        }

        @Override
        public O calculate(I input) {
            Hash hash = new Hash(input, this.delegate, this.args);
            Object output = this.cache.get((Object)hash);
            if (output == null) {
                output = this.delegate.calculate(input);
                this.cache.put((Object)hash, output);
            }
            return (O)output;
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        @Override
        public I in() {
            return (I)this.delegate.in();
        }

        @Override
        public void setInput(I input) {
            this.delegate.setInput(input);
        }

        @Override
        public O out() {
            return (O)this.delegate.out();
        }

        @Override
        public void initialize() {
            this.delegate.initialize();
        }

        @Override
        public CachedFunctionOp<I, O> getIndependentInstance() {
            return this;
        }
    }
}

