/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Localize;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CleanFormatter
extends Formatter {
    private static String s_prefix = "";
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private static final String NL = System.getProperty("line.separator");
    private Level lastLevel = Level.INFO;
    private static DateFormat s_time_formatter = new SimpleDateFormat("HH:mm:ss.SSS");

    public static void setWarningPrefix(String prefix) {
        s_prefix = prefix;
    }

    @Override
    public synchronized String format(LogRecord record) {
        String message = this.formatMessage(record);
        if (message == null) {
            return null;
        }
        if (message.length() == 0) {
            return message;
        }
        if ((message = Localize.filter(message, record.getResourceBundle())).endsWith("\\")) {
            message = message.substring(0, message.length() - 1);
        } else if (!message.matches("^\\s*(" + NL + ")?$")) {
            message = message + NL;
        }
        Level level = record.getLevel();
        if (!level.equals(Level.INFO)) {
            if (level.equals(Level.WARNING)) {
                message = !message.contains("WARNING") ? CleanFormatter.prependToLines(s_prefix + level + ": ", message) : s_prefix + message;
            } else if (level.equals(Level.SEVERE)) {
                message = CleanFormatter.prependToLines(level + ": ", message);
                if (!this.lastLevel.equals(Level.SEVERE)) {
                    message = s_prefix + "**** SEVERE WARNING **** (" + record.getSourceClassName() + "." + record.getSourceMethodName() + " " + CleanFormatter.getTimeStamp(record.getMillis()) + " " + "#" + record.getThreadID() + ")" + NL + message;
                }
            } else if (level.equals(Level.FINE) || level.equals(Level.FINER) || level.equals(Level.FINEST)) {
                String shortPackage = record.getLoggerName();
                int index = shortPackage.lastIndexOf(46);
                if (index > 0) {
                    shortPackage = shortPackage.substring(index + 1);
                }
                message = CleanFormatter.prependToLines(level + " " + shortPackage + ": ", message);
            } else {
                message = CleanFormatter.prependToLines(level + " " + s_time_formatter.format(new Date()) + " " + record.getLoggerName() + ": ", message);
            }
        }
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            message = message + sw.toString();
        }
        this.lastLevel = level;
        return message;
    }

    public static String prependToLines(String prepend, String lines) {
        if (lines == null) {
            return null;
        }
        if (prepend == null) {
            return lines;
        }
        StringBuilder result = new StringBuilder();
        boolean hasFinalNL = lines.endsWith(NL);
        StringTokenizer divided = new StringTokenizer(lines, NL);
        while (divided.hasMoreTokens()) {
            result.append(prepend);
            result.append(divided.nextToken());
            if (!divided.hasMoreTokens() && !hasFinalNL) continue;
            result.append(NL);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTimeStamp(Date date) {
        DateFormat dateFormat = TIMESTAMP_FORMAT;
        synchronized (dateFormat) {
            return TIMESTAMP_FORMAT.format(date);
        }
    }

    private static String getTimeStamp(long date) {
        return CleanFormatter.getTimeStamp(new Date(date));
    }
}

