/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.Gradient;

public class RadialGradient
implements Gradient {
    private double cx;
    private double cy;
    private double fx;
    private double fy;
    private double r;
    private boolean isRelativeToFigureBounds = true;
    private double[] stopOffsets;
    private Color[] stopColors;
    private AffineTransform transform;
    private double[] stopOpacities;

    public RadialGradient() {
    }

    public RadialGradient(double cx, double cy, double fx, double fy, double r, double[] stopOffsets, Color[] stopColors, double[] stopOpacities, boolean isRelativeToFigureBounds, AffineTransform tx) {
        this.cx = cx;
        this.cy = cy;
        this.fx = fx;
        this.fy = fy;
        this.r = r;
        this.stopOffsets = (double[])stopOffsets.clone();
        this.stopColors = (Color[])stopColors.clone();
        this.stopOpacities = (double[])stopOpacities.clone();
        this.isRelativeToFigureBounds = isRelativeToFigureBounds;
        this.transform = tx;
    }

    public void setGradientCircle(double cx, double cy, double r) {
        this.cx = cx;
        this.cy = cy;
        this.r = r;
    }

    public void setStops(double[] offsets, Color[] colors, double[] stopOpacities) {
        this.stopOffsets = (double[])offsets.clone();
        this.stopColors = (Color[])colors.clone();
        this.stopOpacities = (double[])stopOpacities.clone();
    }

    public void setRelativeToFigureBounds(boolean b) {
        this.isRelativeToFigureBounds = b;
    }

    @Override
    public void makeRelativeToFigureBounds(Figure f) {
        if (!this.isRelativeToFigureBounds) {
            this.isRelativeToFigureBounds = true;
            Rectangle2D.Double bounds = f.getBounds();
            this.cx = (this.cx - bounds.x) / bounds.width;
            this.cy = (this.cy - bounds.y) / bounds.height;
            this.r /= Math.sqrt(bounds.width * bounds.width / 2.0 + bounds.height * bounds.height / 2.0);
        }
    }

    @Override
    public Paint getPaint(Figure f, double opacity) {
        if (this.stopColors.length == 0 || this.r <= 0.0) {
            return new Color(-1600086016, true);
        }
        Color[] colors = new Color[this.stopColors.length];
        float[] fractions = new float[this.stopColors.length];
        for (int i = 0; i < this.stopColors.length; ++i) {
            fractions[i] = (float)this.stopOffsets[i];
            colors[i] = new Color(this.stopColors[i].getRGB() & 0xFFFFFF | (int)(opacity * this.stopOpacities[i] * 255.0) << 24, true);
        }
        Point2D.Double cp = new Point2D.Double(this.cx, this.cy);
        Point2D.Double fp = new Point2D.Double(this.fx, this.fy);
        double rr = this.r;
        AffineTransform t = this.transform;
        if (this.isRelativeToFigureBounds) {
            if (!t.isIdentity()) {
                System.out.println("RadialGradient " + this.hashCode() + " t=" + t);
            }
            t = new AffineTransform();
            Rectangle2D.Double bounds = f.getBounds();
            t.translate(bounds.x, bounds.y);
            t.scale(bounds.width, bounds.height);
        }
        if (this.stopColors.length == 1 || t.getDeterminant() == 0.0) {
            return colors[0];
        }
        RadialGradientPaint gp = new RadialGradientPaint(cp, (float)rr, fp, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, t);
        return gp;
    }

    public double getCX() {
        return this.cx;
    }

    public double getCY() {
        return this.cy;
    }

    public double getFX() {
        return this.fx;
    }

    public double getFY() {
        return this.fy;
    }

    public double getR() {
        return this.r;
    }

    public double[] getStopOffsets() {
        return (double[])this.stopOffsets.clone();
    }

    public Color[] getStopColors() {
        return (Color[])this.stopColors.clone();
    }

    public double[] getStopOpacities() {
        return (double[])this.stopOpacities.clone();
    }

    @Override
    public boolean isRelativeToFigureBounds() {
        return this.isRelativeToFigureBounds;
    }

    public void setTransform(AffineTransform tx) {
        this.transform = tx;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.transform == null) {
            this.transform = (AffineTransform)tx.clone();
        } else {
            this.transform.preConcatenate(tx);
        }
    }

    @Override
    public Object clone() {
        try {
            RadialGradient that = (RadialGradient)super.clone();
            that.stopOffsets = (double[])this.stopOffsets.clone();
            that.stopColors = (Color[])this.stopColors.clone();
            that.stopOpacities = (double[])this.stopOpacities.clone();
            that.transform = (AffineTransform)this.transform.clone();
            return that;
        }
        catch (CloneNotSupportedException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.cx);
        bits += Double.doubleToLongBits(this.cy) * 37L;
        bits += (long)(this.stopColors[0].hashCode() * 43);
        return (int)(bits += (long)(this.stopColors[this.stopColors.length - 1].hashCode() * 47)) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof RadialGradient) {
            return this.equals((RadialGradient)o);
        }
        return false;
    }

    public boolean equals(RadialGradient that) {
        return this.cx == that.cx && this.cy == that.cy && this.fx == that.fx && this.fy == that.fy && this.r == that.r && this.isRelativeToFigureBounds == that.isRelativeToFigureBounds && Arrays.equals(this.stopOffsets, that.stopOffsets) && Arrays.equals(this.stopOpacities, that.stopOpacities) && Arrays.equals(this.stopColors, that.stopColors) && this.transform.equals(that.transform);
    }
}

