/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.web;

import java.io.IOException;
import java.net.URL;
import org.scijava.log.LogService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.DefaultSearchAction;
import org.scijava.search.SearchAction;
import org.scijava.search.SearchActionFactory;
import org.scijava.search.SearchResult;
import org.scijava.search.web.WebSearchResult;

@Plugin(type=SearchActionFactory.class)
public class OpenInBrowserActionFactory
implements SearchActionFactory {
    @Parameter
    private PlatformService platformService;
    @Parameter
    private LogService log;

    @Override
    public boolean supports(SearchResult result) {
        return result instanceof WebSearchResult;
    }

    @Override
    public SearchAction create(SearchResult result) {
        return new DefaultSearchAction("Open in Browser", true, () -> this.openURL(result));
    }

    private void openURL(SearchResult result) {
        try {
            URL url = new URL(result.properties().get("url"));
            this.platformService.open(url);
        }
        catch (IOException exc) {
            this.log.error(exc);
        }
    }
}

