/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.web;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Scanner;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.search.web.WebSearchResult;

@Plugin(type=Searcher.class, enabled=false)
public class ImageJForumSearcher
implements Searcher {
    @Parameter
    private LogService log;

    @Override
    public String title() {
        return "ImageJ Forum";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        try {
            String[] results;
            String webSearchContent;
            URL url = new URL("http://forum.imagej.net/search?q=" + URLEncoder.encode(text, "utf-8") + "&source=imagej");
            String[] stringArray = null;
            try (Scanner s = new Scanner(url.openStream());){
                s.useDelimiter("\"topics\":");
                if (!s.hasNext()) {
                    ArrayList<SearchResult> arrayList = searchResults;
                    return arrayList;
                }
                s.next();
                if (!s.hasNext()) {
                    ArrayList<SearchResult> arrayList = searchResults;
                    return arrayList;
                }
                webSearchContent = s.next();
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            webSearchContent = webSearchContent.substring(webSearchContent.indexOf("[{") + 2, webSearchContent.indexOf("}]"));
            stringArray = results = webSearchContent.split("\\},\\{");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String result = stringArray[n2];
                HashMap<String, String> metaInfo = this.parseForumSearchResult(result);
                String forumPostUrl = "http://forum.imagej.net/t/" + metaInfo.get("slug") + "/" + metaInfo.get("id") + "/";
                String details = "Tags: " + metaInfo.get("tags") + "<br />Created: " + metaInfo.get("created_at") + "<br />Last posted: " + metaInfo.get("last_posted_at");
                LinkedHashMap<String, String> extraProps = new LinkedHashMap<String, String>();
                extraProps.put("Tags", metaInfo.get("tags"));
                extraProps.put("Created", this.formatDate(metaInfo.get("created_at")));
                extraProps.put("Last posted", this.formatDate(metaInfo.get("last_posted_at")));
                searchResults.add(new WebSearchResult(metaInfo.get("title"), forumPostUrl, details, null, extraProps));
                ++n2;
            }
            return searchResults;
        }
        catch (IOException e) {
            this.log.debug(e);
        }
        return searchResults;
    }

    private HashMap<String, String> parseForumSearchResult(String content) {
        content = content + ",";
        HashMap<String, String> map = new HashMap<String, String>();
        String currentKey = "";
        String currentValue = "";
        boolean readString = false;
        boolean readKey = true;
        boolean tagParentheses = false;
        String currentChar = " ";
        String previousChar = " ";
        for (int i = 0; i < content.length(); ++i) {
            previousChar = currentChar;
            currentChar = content.substring(i, i + 1);
            if (currentChar.equals("\"") && !previousChar.equals("\\")) {
                readString = !readString;
                continue;
            }
            if (!readString) {
                if (currentChar.equals(":")) {
                    readKey = false;
                    continue;
                }
                if (currentChar.equals(",") && !tagParentheses) {
                    readKey = true;
                    map.put(currentKey, currentValue);
                    currentKey = "";
                    currentValue = "";
                    continue;
                }
            }
            if (readString && readKey) {
                currentKey = currentKey + currentChar;
                continue;
            }
            if (currentChar.equals("[")) {
                tagParentheses = true;
            }
            if (currentChar.equals("]") && tagParentheses) {
                tagParentheses = false;
            }
            currentValue = currentValue + currentChar;
        }
        return map;
    }

    private String formatDate(String datestr) {
        Instant instant = Instant.parse(datestr);
        LocalDateTime result = LocalDateTime.ofInstant(instant, ZoneId.of(ZoneOffset.UTC.getId()));
        return result.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }
}

