/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.module;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.Context;
import org.scijava.UIDetails;
import org.scijava.app.AppService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.search.module.ModuleSearchResult;

@Plugin(type=Searcher.class, priority=10000.0)
public class ModuleSearcher
implements Searcher {
    @Parameter
    private Context context;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private AppService appService;

    @Override
    public String title() {
        return "Commands";
    }

    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        String baseDir = this.appService.getApp().getBaseDirectory().getAbsolutePath();
        LinkedHashSet matches = new LinkedHashSet();
        List modules = this.moduleService.getModules().stream().filter(UIDetails::isEnabled).filter(UIDetails::isVisible).filter(ModuleInfo::isValid).collect(Collectors.toList());
        String textLower = text.toLowerCase();
        modules.stream().filter(info -> info.getTitle().startsWith(textLower)).forEach(matches::add);
        modules.stream().filter(info -> this.matches(info.getTitle(), textLower)).forEach(matches::add);
        modules.stream().filter(info -> this.matches(info.getMenuPath().toString(), textLower)).forEach(matches::add);
        return matches.stream().map(info -> new ModuleSearchResult((ModuleInfo)info, baseDir)).collect(Collectors.toList());
    }

    private boolean matches(String actual, String desired) {
        return actual.toLowerCase().matches(".*" + desired + ".*");
    }
}

