/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.module;

import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.input.Accelerator;
import org.scijava.module.ModuleInfo;
import org.scijava.search.SearchResult;
import org.scijava.util.ClassUtils;
import org.scijava.util.FileUtils;

public class ModuleSearchResult
implements SearchResult {
    private final ModuleInfo info;
    private final String baseDir;
    private final Map<String, String> props;

    public ModuleSearchResult(ModuleInfo info, String baseDir) {
        this.info = info;
        this.baseDir = baseDir;
        this.props = new LinkedHashMap<String, String>();
        MenuPath menuPath = info.getMenuPath();
        if (menuPath != null) {
            Accelerator accelerator;
            this.props.put("Menu path", menuPath.getMenuString(false));
            MenuEntry menuLeaf = menuPath.getLeaf();
            if (menuLeaf != null && (accelerator = menuLeaf.getAccelerator()) != null) {
                this.props.put("Shortcut", accelerator.toString());
            }
        }
        this.props.put("Identifier", info.getIdentifier());
        this.props.put("Location", this.getLocation());
    }

    public ModuleInfo info() {
        return this.info;
    }

    @Override
    public String name() {
        return this.info.getTitle();
    }

    @Override
    public String identifier() {
        String menuPath = this.info.getMenuPath().getMenuString().replace(">", "\u203a");
        return menuPath.isEmpty() ? this.info.getTitle() : menuPath;
    }

    @Override
    public String iconPath() {
        String iconPath = this.info.getIconPath();
        if (iconPath != null) {
            return iconPath;
        }
        if (this.info.getMenuPath() != null && this.info.getMenuPath().getLeaf() != null) {
            return this.info.getMenuPath().getLeaf().getIconPath();
        }
        return null;
    }

    @Override
    public Map<String, String> properties() {
        return this.props;
    }

    private String getLocation() {
        URL location = ClassUtils.getLocation(this.info.getDelegateClassName());
        File file = FileUtils.urlToFile(location);
        if (file == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        if (path == null) {
            return null;
        }
        if (path.startsWith(this.baseDir)) {
            if (path.length() == this.baseDir.length()) {
                return "";
            }
            return path.substring(this.baseDir.length() + 1);
        }
        return path;
    }
}

