/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.BooleanType;
import net.imglib2.view.Views;

public class ROIUtils {
    public static <T extends BooleanType<T>> long countTrue(RandomAccessibleInterval<T> interval) {
        long sum = 0L;
        for (BooleanType t : Views.iterable(interval)) {
            if (!t.get()) continue;
            ++sum;
        }
        return sum;
    }

    public static <T> LabelingMapping<T> getLabelingMapping(RandomAccessibleInterval<LabelingType<T>> labeling) {
        return ((LabelingType)Views.iterable(labeling).firstElement()).getMapping();
    }

    public static Interval getBounds(Collection<? extends Localizable> vertices) {
        assert (vertices.size() != 0);
        int numDims = vertices.iterator().next().numDimensions();
        long[] min = new long[numDims];
        Arrays.fill(min, Long.MAX_VALUE);
        long[] max = new long[numDims];
        Arrays.fill(max, Long.MIN_VALUE);
        for (Localizable localizable : vertices) {
            for (int d = 0; d < numDims; ++d) {
                long pos = localizable.getLongPosition(d);
                if (pos < min[d]) {
                    min[d] = pos;
                }
                if (pos <= max[d]) continue;
                max[d] = pos;
            }
        }
        return new FinalInterval(min, max);
    }

    public static RealInterval getBoundsReal(Collection<? extends RealLocalizable> vertices) {
        assert (vertices.size() != 0);
        int numDims = vertices.iterator().next().numDimensions();
        double[] min = new double[numDims];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        double[] max = new double[numDims];
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        for (RealLocalizable realLocalizable : vertices) {
            for (int d = 0; d < numDims; ++d) {
                double pos = realLocalizable.getDoublePosition(d);
                if (pos < min[d]) {
                    min[d] = pos;
                }
                if (!(pos > max[d])) continue;
                max[d] = pos;
            }
        }
        return new FinalRealInterval(min, max);
    }

    public static List<Localizable> bresenham(List<? extends RealLocalizable> vertices) {
        assert (vertices.size() > 1);
        assert (vertices.iterator().next().numDimensions() == 2);
        ArrayList<Localizable> tmp = new ArrayList<Localizable>();
        for (int i = 0; i < vertices.size(); ++i) {
            long x0 = Math.round(vertices.get(i).getDoublePosition(0));
            long y0 = Math.round(vertices.get(i).getDoublePosition(1));
            long x1 = Math.round(vertices.get((i + 1) % vertices.size()).getDoublePosition(0));
            long y1 = Math.round(vertices.get((i + 1) % vertices.size()).getDoublePosition(1));
            long dx = Math.abs(x1 - x0);
            long sx = x0 < x1 ? 1L : -1L;
            long dy = -Math.abs(y1 - y0);
            long sy = y0 < y1 ? 1L : -1L;
            long err = dx + dy;
            while (true) {
                tmp.add((Localizable)new Point(new long[]{x0, y0}));
                if (x0 == x1 && y0 == y1) break;
                long e2 = 2L * err;
                if (e2 > dy) {
                    err += dy;
                    x0 += sx;
                }
                if (e2 >= dx) continue;
                err += dx;
                y0 += sy;
            }
            tmp.remove(tmp.size() - 1);
        }
        return tmp;
    }
}

