/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.imglib2.type.numeric.IntegerType;

public class LabelingMapping<T> {
    private static final int INT_NO_ENTRY_VALUE = -1;
    private final int maxNumLabelSets;
    private final HashMap<Set<T>, InternedSet<T>> internedSets;
    private final ArrayList<InternedSet<T>> setsByIndex;
    private final ArrayList<TObjectIntMap<T>> addMapsByIndex;
    private final ArrayList<TObjectIntMap<T>> subMapsByIndex;
    private final InternedSet<T> theEmptySet;

    public LabelingMapping(IntegerType<?> indexType) {
        this((int)indexType.getMaxValue());
    }

    private LabelingMapping(int maxNumLabelSets) {
        this.maxNumLabelSets = maxNumLabelSets;
        this.internedSets = new HashMap();
        this.setsByIndex = new ArrayList();
        this.addMapsByIndex = new ArrayList();
        this.subMapsByIndex = new ArrayList();
        HashSet background = new HashSet(0);
        this.theEmptySet = this.intern(background);
    }

    LabelingMapping<T> newInstance() {
        return new LabelingMapping<T>(this.maxNumLabelSets);
    }

    InternedSet<T> emptySet() {
        return this.theEmptySet;
    }

    int indexOf(Set<T> key) {
        return this.intern(key).index;
    }

    InternedSet<T> setAtIndex(int index) {
        return this.setsByIndex.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternedSet<T> intern(Set<T> src) {
        InternedSet<T> interned = this.internedSets.get(src);
        if (interned != null) {
            return interned;
        }
        LabelingMapping labelingMapping = this;
        synchronized (labelingMapping) {
            interned = this.internedSets.get(src);
            if (interned != null) {
                return interned;
            }
            int intIndex = this.setsByIndex.size();
            if (intIndex > this.maxNumLabelSets) {
                throw new AssertionError((Object)String.format("Too many labels (or types of multiply-labeled pixels): %d maximum", intIndex));
            }
            HashSet<T> srcCopy = new HashSet<T>(src);
            interned = new InternedSet<T>(srcCopy, intIndex);
            this.setsByIndex.add(interned);
            this.addMapsByIndex.add(new TObjectIntHashMap(10, 0.5f, -1));
            this.subMapsByIndex.add(new TObjectIntHashMap(10, 0.5f, -1));
            this.internedSets.put(srcCopy, interned);
            return interned;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternedSet<T> addLabelToSetAtIndex(T label, int index) {
        TObjectIntMap<T> addMap = this.addMapsByIndex.get(index);
        int i = addMap.get(label);
        if (i != -1) {
            return this.setsByIndex.get(i);
        }
        LabelingMapping labelingMapping = this;
        synchronized (labelingMapping) {
            i = addMap.get(label);
            if (i != -1) {
                return this.setsByIndex.get(i);
            }
            HashSet set = new HashSet(this.setsByIndex.get((int)index).set);
            set.add(label);
            InternedSet interned = this.intern(set);
            addMap.put(label, interned.index);
            return interned;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternedSet<T> removeLabelFromSetAtIndex(T label, int index) {
        TObjectIntMap<T> subMap = this.subMapsByIndex.get(index);
        int i = subMap.get(label);
        if (i != -1) {
            return this.setsByIndex.get(i);
        }
        LabelingMapping labelingMapping = this;
        synchronized (labelingMapping) {
            i = subMap.get(label);
            if (i != -1) {
                return this.setsByIndex.get(i);
            }
            HashSet set = new HashSet(this.setsByIndex.get((int)index).set);
            set.remove(label);
            InternedSet interned = this.intern(set);
            subMap.put(label, interned.index);
            return interned;
        }
    }

    public int numSets() {
        return this.setsByIndex.size();
    }

    public Set<T> labelsAtIndex(int index) {
        return Collections.unmodifiableSet(this.setsByIndex.get((int)index).set);
    }

    public Set<T> getLabels() {
        HashSet result = new HashSet();
        for (InternedSet<T> instance : this.setsByIndex) {
            for (Object label : instance.set) {
                result.add(label);
            }
        }
        return result;
    }

    public static class SerialisationAccess<T> {
        private final LabelingMapping<T> labelingMapping;

        protected SerialisationAccess(LabelingMapping<T> labelingMapping) {
            this.labelingMapping = labelingMapping;
        }

        protected List<Set<T>> getLabelSets() {
            ArrayList<Set<T>> labelSets = new ArrayList<Set<T>>(this.labelingMapping.numSets());
            for (InternedSet interned : ((LabelingMapping)this.labelingMapping).setsByIndex) {
                labelSets.add(interned.getSet());
            }
            return labelSets;
        }

        protected void setLabelSets(List<Set<T>> labelSets) {
            if (labelSets.isEmpty()) {
                throw new IllegalArgumentException("expected non-empty list of label-sets");
            }
            if (!labelSets.get(0).isEmpty()) {
                throw new IllegalArgumentException("label-set at index 0 expected to be the empty label set");
            }
            ((LabelingMapping)this.labelingMapping).internedSets.clear();
            ((LabelingMapping)this.labelingMapping).setsByIndex.clear();
            ((LabelingMapping)this.labelingMapping).addMapsByIndex.clear();
            ((LabelingMapping)this.labelingMapping).subMapsByIndex.clear();
            InternedSet theEmptySet = ((LabelingMapping)this.labelingMapping).theEmptySet;
            ((LabelingMapping)this.labelingMapping).setsByIndex.add(theEmptySet);
            ((LabelingMapping)this.labelingMapping).addMapsByIndex.add(new TObjectIntHashMap(10, 0.5f, -1));
            ((LabelingMapping)this.labelingMapping).subMapsByIndex.add(new TObjectIntHashMap(10, 0.5f, -1));
            ((LabelingMapping)this.labelingMapping).internedSets.put(theEmptySet.getSet(), theEmptySet);
            for (int i = 1; i < labelSets.size(); ++i) {
                Set<T> set = labelSets.get(i);
                InternedSet<T> interned = this.labelingMapping.intern(set);
                if (interned.index == i) continue;
                throw new IllegalArgumentException("no duplicates allowed in list of label-sets");
            }
        }
    }

    static class InternedSet<T> {
        final Set<T> set;
        final int hashCode;
        final int index;

        public InternedSet(Set<T> set, int index) {
            this.set = set;
            this.hashCode = set.hashCode();
            this.index = index;
        }

        public Set<T> getSet() {
            return this.set;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

