/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ConversionUtils;

@Plugin(type=Converter.class, priority=1.0E300)
public class NullConverter
extends AbstractConverter<Object, Object> {
    @Override
    public boolean canConvert(ConversionRequest request) {
        if (request == null) {
            return false;
        }
        return request.destType() == null && request.destClass() == null || request.sourceObject() == null && request.sourceClass() == null;
    }

    @Override
    public boolean canConvert(Object src, Type dest) {
        return src == null || dest == null;
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        return src == null || dest == null;
    }

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        if (src == null) {
            return false;
        }
        return dest == null;
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        if (dest == null) {
            return null;
        }
        if (src == null) {
            return ConversionUtils.getNullValue(dest);
        }
        throw new IllegalArgumentException("Attempting non-null conversion: " + src + " > " + dest + " using NullConverter.");
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<Object> getInputType() {
        return Object.class;
    }
}

