/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widgets.strings.Label;
import java.util.Collection;

public class ClasspathAddMvnMagicCommand
extends ClasspathMagicCommand {
    public static final String ADD = "add";
    public static final String MVN = "mvn";
    public static final String CLASSPATH_ADD_MVN = "%classpath add mvn";
    public static final String ADD_MVN_FORMAT_ERROR_MESSAGE = "Wrong command format, should be %classpath add mvn group name version or %classpath add mvn group:name:version";
    private MavenJarResolver.ResolverParams commandParams;

    public ClasspathAddMvnMagicCommand(MavenJarResolver.ResolverParams commandParams, KernelFunctionality kernel) {
        super(kernel);
        this.commandParams = commandParams;
    }

    @Override
    public String getMagicCommandName() {
        return CLASSPATH_ADD_MVN;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 3 && commandParts[0].equals("%classpath") && commandParts[1].equals(ADD) && commandParts[2].equals(MVN);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        MavenJarResolver.AddMvnCommandResult result;
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath(command);
        if (split.length != 6 && split.length != 4) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, ADD_MVN_FORMAT_ERROR_MESSAGE);
        }
        MavenJarResolver classpathAddMvnCommand = new MavenJarResolver(this.commandParams);
        MvnLoggerWidget progress = new MvnLoggerWidget(param.getCode().getMessage());
        if (split.length == 4) {
            String[] valuesFromGradlePattern = split[3].split(":");
            if (valuesFromGradlePattern.length != 3) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, ADD_MVN_FORMAT_ERROR_MESSAGE);
            }
            result = this.retrieve(valuesFromGradlePattern[0], valuesFromGradlePattern[1], valuesFromGradlePattern[2], classpathAddMvnCommand, progress);
        } else {
            result = this.retrieve(split[3], split[4], split[5], classpathAddMvnCommand, progress);
        }
        if (result.isJarRetrieved()) {
            Collection<String> newAddedJars = this.addJars(classpathAddMvnCommand.getPathToMavenRepo() + "/*");
            if (newAddedJars.isEmpty()) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
            }
            String textMessage = "Added jar" + (newAddedJars.size() > 1 ? "s: " : ": ") + newAddedJars + "\n";
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, textMessage);
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, result.getErrorMessage());
    }

    private MavenJarResolver.AddMvnCommandResult retrieve(String groupId, String artifactId, String version, MavenJarResolver classpathAddMvnCommand, MvnLoggerWidget progress) {
        return classpathAddMvnCommand.retrieve(groupId, artifactId, version, progress);
    }

    public class MvnLoggerWidget {
        private Label widget;

        public MvnLoggerWidget(Message parentMessage) {
            this.widget = new Label(parentMessage);
        }

        public void sendLog(String text) {
            this.widget.setValue(text);
        }

        public void display() {
            this.widget.display();
        }

        public void close() {
            this.widget.close();
        }
    }
}

