/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh;

import edu.mines.jtk.mesh.TetMesh;
import edu.mines.jtk.util.Stopwatch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TetMeshTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(TetMeshTest.class);
        TestRunner.run((Test)suite);
    }

    public void testNabors() {
        TetMesh tm = new TetMesh();
        TetMesh.Node n0 = new TetMesh.Node(1.0f, 0.0f, 0.0f);
        TetMesh.Node n1 = new TetMesh.Node(0.0f, 1.0f, 0.0f);
        TetMesh.Node n2 = new TetMesh.Node(0.0f, 0.0f, 1.0f);
        TetMesh.Node n3 = new TetMesh.Node(0.0f, 0.0f, 0.0f);
        TetMesh.Node n4 = new TetMesh.Node(1.1f, 1.1f, 1.1f);
        tm.addNode(n0);
        tm.addNode(n1);
        tm.addNode(n2);
        tm.addNode(n3);
        tm.addNode(n4);
        TetMeshTest.assertEquals((int)2, (int)tm.getTetNabors(n0).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getTetNabors(n1).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getTetNabors(n2).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(n3).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(n4).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getTetNabors(tm.findEdge(n0, n1)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getTetNabors(tm.findEdge(n1, n2)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getTetNabors(tm.findEdge(n2, n0)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findEdge(n0, n3)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findEdge(n0, n4)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findEdge(n1, n3)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findEdge(n1, n4)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findEdge(n2, n3)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findEdge(n2, n4)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getTetNabors(tm.findFace(n0, n1, n2)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findFace(n0, n2, n3)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findFace(n1, n3, n2)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findFace(n0, n3, n1)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findFace(n0, n4, n2)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findFace(n0, n1, n4)).length);
        TetMeshTest.assertEquals((int)1, (int)tm.getTetNabors(tm.findFace(n1, n2, n4)).length);
        TetMeshTest.assertEquals((int)3, (int)tm.getFaceNabors(tm.findEdge(n0, n1)).length);
        TetMeshTest.assertEquals((int)3, (int)tm.getFaceNabors(tm.findEdge(n1, n2)).length);
        TetMeshTest.assertEquals((int)3, (int)tm.getFaceNabors(tm.findEdge(n2, n0)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getFaceNabors(tm.findEdge(n0, n3)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getFaceNabors(tm.findEdge(n0, n4)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getFaceNabors(tm.findEdge(n1, n3)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getFaceNabors(tm.findEdge(n1, n4)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getFaceNabors(tm.findEdge(n2, n3)).length);
        TetMeshTest.assertEquals((int)2, (int)tm.getFaceNabors(tm.findEdge(n2, n4)).length);
        TetMeshTest.assertEquals((int)4, (int)tm.getEdgeNabors(n0).length);
        TetMeshTest.assertEquals((int)4, (int)tm.getEdgeNabors(n1).length);
        TetMeshTest.assertEquals((int)4, (int)tm.getEdgeNabors(n2).length);
        TetMeshTest.assertEquals((int)3, (int)tm.getEdgeNabors(n3).length);
        TetMeshTest.assertEquals((int)3, (int)tm.getEdgeNabors(n4).length);
        TetMeshTest.assertEquals((int)4, (int)tm.getNodeNabors(n0).length);
        TetMeshTest.assertEquals((int)4, (int)tm.getNodeNabors(n1).length);
        TetMeshTest.assertEquals((int)4, (int)tm.getNodeNabors(n2).length);
        TetMeshTest.assertEquals((int)3, (int)tm.getNodeNabors(n3).length);
        TetMeshTest.assertEquals((int)3, (int)tm.getNodeNabors(n4).length);
    }

    public void testIO() throws IOException, ClassNotFoundException {
        TetMesh.Node n000 = new TetMesh.Node(0.0f, 0.0f, 0.0f);
        TetMesh.Node n001 = new TetMesh.Node(0.0f, 0.0f, 1.0f);
        TetMesh.Node n010 = new TetMesh.Node(0.0f, 1.0f, 0.0f);
        TetMesh.Node n011 = new TetMesh.Node(0.0f, 1.0f, 1.0f);
        TetMesh.Node n100 = new TetMesh.Node(1.0f, 0.0f, 0.0f);
        TetMesh.Node n101 = new TetMesh.Node(1.0f, 0.0f, 1.0f);
        TetMesh.Node n110 = new TetMesh.Node(1.0f, 1.0f, 0.0f);
        TetMesh.Node n111 = new TetMesh.Node(1.0f, 1.0f, 1.0f);
        TetMesh tm = new TetMesh();
        tm.addNode(n000);
        tm.addNode(n001);
        tm.addNode(n010);
        tm.addNode(n011);
        tm.addNode(n100);
        tm.addNode(n101);
        tm.addNode(n110);
        tm.addNode(n111);
        int nnode = tm.countNodes();
        int ntet = tm.countTets();
        TetMeshTest.assertEquals((int)8, (int)nnode);
        TetMesh.NodePropertyMap map = tm.getNodePropertyMap("foo");
        map.put(n000, 0);
        map.put(n001, 1);
        map.put(n010, 2);
        map.put(n011, 3);
        map.put(n100, 4);
        map.put(n101, 5);
        map.put(n110, 6);
        map.put(n111, 7);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(tm);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        tm = (TetMesh)ois.readObject();
        bais.close();
        TetMeshTest.assertEquals((int)nnode, (int)tm.countNodes());
        TetMeshTest.assertEquals((int)ntet, (int)tm.countTets());
        String name = tm.getNodePropertyMapNames()[0];
        TetMeshTest.assertEquals((String)"foo", (String)name);
        map = tm.getNodePropertyMap(name);
        n000 = tm.findNodeNearest(0.0f, 0.0f, 0.0f);
        n001 = tm.findNodeNearest(0.0f, 0.0f, 1.0f);
        n010 = tm.findNodeNearest(0.0f, 1.0f, 0.0f);
        n011 = tm.findNodeNearest(0.0f, 1.0f, 1.0f);
        n100 = tm.findNodeNearest(1.0f, 0.0f, 0.0f);
        n101 = tm.findNodeNearest(1.0f, 0.0f, 1.0f);
        n110 = tm.findNodeNearest(1.0f, 1.0f, 0.0f);
        n111 = tm.findNodeNearest(1.0f, 1.0f, 1.0f);
        TetMeshTest.assertEquals((int)0, (int)((Integer)map.get(n000)));
        TetMeshTest.assertEquals((int)1, (int)((Integer)map.get(n001)));
        TetMeshTest.assertEquals((int)2, (int)((Integer)map.get(n010)));
        TetMeshTest.assertEquals((int)3, (int)((Integer)map.get(n011)));
        TetMeshTest.assertEquals((int)4, (int)((Integer)map.get(n100)));
        TetMeshTest.assertEquals((int)5, (int)((Integer)map.get(n101)));
        TetMeshTest.assertEquals((int)6, (int)((Integer)map.get(n110)));
        TetMeshTest.assertEquals((int)7, (int)((Integer)map.get(n111)));
    }

    public void testTetListener() {
        TetMesh tm = new TetMesh();
        tm.addNode(new TetMesh.Node(0.0f, 0.0f, 0.0f));
        tm.addNode(new TetMesh.Node(1.0f, 0.0f, 0.0f));
        tm.addNode(new TetMesh.Node(0.0f, 1.0f, 0.0f));
        tm.addNode(new TetMesh.Node(0.0f, 0.0f, 1.0f));
        TetListener tl = new TetListener();
        tm.addTetListener(tl);
        TetMesh.Node node = new TetMesh.Node(0.1f, 0.1f, 0.1f);
        tm.addNode(node);
        TetMeshTest.assertEquals((int)4, (int)tl.countAdded());
        TetMeshTest.assertEquals((int)1, (int)tl.countRemoved());
        tm.removeNode(node);
        TetMeshTest.assertEquals((int)5, (int)tl.countAdded());
        TetMeshTest.assertEquals((int)5, (int)tl.countRemoved());
    }

    public void testFinds() {
        TetMesh tm = new TetMesh();
        TetMesh.Node n0 = new TetMesh.Node(0.0f, 0.0f, 0.0f);
        TetMesh.Node n1 = new TetMesh.Node(1.0f, 0.0f, 0.0f);
        TetMesh.Node n2 = new TetMesh.Node(0.0f, 1.0f, 0.0f);
        TetMesh.Node n3 = new TetMesh.Node(0.0f, 0.0f, 1.0f);
        TetMesh.Node n4 = new TetMesh.Node(9.0f, 9.0f, 9.0f);
        tm.addNode(n0);
        tm.addNode(n1);
        tm.addNode(n2);
        tm.addNode(n3);
        tm.addNode(n4);
        TetMesh.Tet tet = tm.findTet(n0);
        TetMeshTest.assertTrue((tet != null ? 1 : 0) != 0);
        TetMeshTest.assertTrue((tet == tm.findTet(n0, n1) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((tet == tm.findTet(n0, n2) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((tet == tm.findTet(n0, n3) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((tet == tm.findTet(n0, n1, n3) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((tet == tm.findTet(n0, n1, n3) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((tet == tm.findTet(n0, n2, n3) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((tet == tm.findTet(n0, n1, n2, n3) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findTet(n0, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findTet(n0, n1, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findTet(n0, n2, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findTet(n0, n3, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findTet(n0, n1, n2, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findTet(n0, n1, n3, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findTet(n0, n2, n3, n4) ? 1 : 0) != 0);
        TetMesh.Edge edge = tm.findEdge(n0, n1);
        TetMesh.Edge e01 = new TetMesh.Edge(n0, n1, tet);
        TetMesh.Edge e10 = new TetMesh.Edge(n1, n0, tet);
        TetMeshTest.assertTrue((edge.equals(e01) || edge.equals(e10) ? 1 : 0) != 0);
        edge = tm.findEdge(n0, n2);
        TetMesh.Edge e02 = new TetMesh.Edge(n0, n2, tet);
        TetMesh.Edge e20 = new TetMesh.Edge(n2, n0, tet);
        TetMeshTest.assertTrue((edge.equals(e02) || edge.equals(e20) ? 1 : 0) != 0);
        edge = tm.findEdge(n0, n3);
        TetMesh.Edge e03 = new TetMesh.Edge(n0, n3, tet);
        TetMesh.Edge e30 = new TetMesh.Edge(n3, n0, tet);
        TetMeshTest.assertTrue((edge.equals(e03) || edge.equals(e30) ? 1 : 0) != 0);
        edge = tm.findEdge(n1, n2);
        TetMesh.Edge e12 = new TetMesh.Edge(n1, n2, tet);
        TetMesh.Edge e21 = new TetMesh.Edge(n2, n1, tet);
        TetMeshTest.assertTrue((edge.equals(e12) || edge.equals(e21) ? 1 : 0) != 0);
        edge = tm.findEdge(n1, n3);
        TetMesh.Edge e13 = new TetMesh.Edge(n1, n3, tet);
        TetMesh.Edge e31 = new TetMesh.Edge(n3, n1, tet);
        TetMeshTest.assertTrue((edge.equals(e13) || edge.equals(e31) ? 1 : 0) != 0);
        edge = tm.findEdge(n2, n3);
        TetMesh.Edge e23 = new TetMesh.Edge(n2, n3, tet);
        TetMesh.Edge e32 = new TetMesh.Edge(n3, n2, tet);
        TetMeshTest.assertTrue((edge.equals(e23) || edge.equals(e32) ? 1 : 0) != 0);
        TetMesh.Face face = tm.findFace(n0, n1, n2);
        TetMesh.Face f102 = new TetMesh.Face(n1, n0, n2, tet);
        TetMeshTest.assertTrue((boolean)face.equals(f102));
        face = tm.findFace(n0, n1, n3);
        TetMesh.Face f301 = new TetMesh.Face(n3, n0, n1, tet);
        TetMeshTest.assertTrue((boolean)face.equals(f301));
        face = tm.findFace(n0, n2, n3);
        TetMesh.Face f320 = new TetMesh.Face(n3, n2, n0, tet);
        TetMeshTest.assertTrue((boolean)face.equals(f320));
        TetMeshTest.assertTrue((null == tm.findFace(n0, n1, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findFace(n0, n2, n4) ? 1 : 0) != 0);
        TetMeshTest.assertTrue((null == tm.findFace(n0, n3, n4) ? 1 : 0) != 0);
    }

    public void testSimple() {
        TetMesh tm = new TetMesh();
        TetMesh.Node n0 = new TetMesh.Node(1.0f, 0.0f, 0.0f);
        TetMesh.Node n1 = new TetMesh.Node(0.0f, 1.0f, 0.0f);
        TetMesh.Node n2 = new TetMesh.Node(0.0f, 0.0f, 1.0f);
        TetMesh.Node n3 = new TetMesh.Node(0.0f, 0.0f, 0.0f);
        TetMesh.Node n4 = new TetMesh.Node(0.9f, 0.9f, 0.9f);
        tm.addNode(n0);
        tm.addNode(n1);
        tm.addNode(n2);
        tm.addNode(n3);
        tm.addNode(n4);
        tm.removeNode(n4);
        tm.validate();
    }

    public void testLine() {
        TetMesh.Node node;
        float z;
        float y;
        float x;
        int i;
        TetMesh tm = new TetMesh();
        int n = 100;
        for (i = 0; i < n; ++i) {
            x = i;
            y = 3.14f;
            z = 4.13f;
            node = new TetMesh.Node(x, y, z);
            tm.addNode(node);
        }
        tm.validate();
        for (i = 0; i < n; ++i) {
            x = i;
            y = 3.14f;
            z = 4.13f;
            node = tm.findNodeNearest(x, y, z);
            tm.removeNode(node);
        }
        tm.validate();
    }

    public void testCube() {
        TetMesh tm = new TetMesh();
        TetMesh.Node n0 = new TetMesh.Node(0.0f, 0.0f, 0.0f);
        TetMesh.Node n1 = new TetMesh.Node(1.0f, 0.0f, 0.0f);
        TetMesh.Node n2 = new TetMesh.Node(0.0f, 1.0f, 0.0f);
        TetMesh.Node n3 = new TetMesh.Node(0.0f, 0.0f, 1.0f);
        TetMesh.Node n4 = new TetMesh.Node(1.0f, 1.0f, 0.0f);
        TetMesh.Node n5 = new TetMesh.Node(1.0f, 0.0f, 1.0f);
        TetMesh.Node n6 = new TetMesh.Node(0.0f, 1.0f, 1.0f);
        TetMesh.Node n7 = new TetMesh.Node(1.0f, 1.0f, 1.0f);
        tm.addNode(n0);
        tm.addNode(n1);
        tm.addNode(n2);
        tm.addNode(n3);
        tm.addNode(n4);
        tm.addNode(n5);
        tm.addNode(n6);
        tm.addNode(n7);
        tm.removeNode(n7);
        tm.removeNode(n6);
        tm.removeNode(n5);
        tm.removeNode(n4);
        tm.removeNode(n3);
        tm.removeNode(n2);
        tm.removeNode(n1);
        tm.removeNode(n0);
        tm.validate();
    }

    public void testAddFindRemove() {
        Random random = new Random();
        TetMesh tm = new TetMesh();
        for (int niter = 0; niter < 1000; ++niter) {
            TetMesh.Node node;
            float x = random.nextFloat();
            float y = random.nextFloat();
            float z = random.nextFloat();
            if (tm.countNodes() < 10 || random.nextFloat() > 0.5f) {
                node = new TetMesh.Node(x, y, z);
                boolean ok = tm.addNode(node);
                TetMeshTest.assertTrue((boolean)ok);
                tm.validate();
                continue;
            }
            if (tm.countNodes() <= 0) continue;
            node = tm.findNodeNearest(x, y, z);
            TetMeshTest.assertTrue((node != null ? 1 : 0) != 0);
            TetMesh.Node nodeSlow = tm.findNodeNearestSlow(x, y, z);
            TetMeshTest.assertTrue((node == nodeSlow ? 1 : 0) != 0);
            tm.removeNode(node);
            tm.validate();
        }
    }

    public void benchAddNode() {
        Random random = new Random();
        for (int itest = 0; itest < 16; ++itest) {
            for (int nnode = 1000; nnode <= 64000; nnode *= 2) {
                Stopwatch sw = new Stopwatch();
                sw.reset();
                sw.start();
                TetMesh tm = new TetMesh();
                for (int inode = 0; inode < nnode; ++inode) {
                    float x = random.nextFloat();
                    float y = random.nextFloat();
                    float z = random.nextFloat();
                    TetMesh.Node node = new TetMesh.Node(x, y, z);
                    tm.addNode(node);
                }
                sw.stop();
                System.out.println("Added " + nnode + " nodes to make " + tm.countTets() + " tets in " + sw.time() + " seconds.");
                tm.validate();
            }
            try {
                System.out.println("Sleeping");
                Thread.sleep(5000L, 0);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void benchFind() {
        int nnode = 1000;
        int nfind = 10000;
        int ntest = 3;
        Random random = new Random();
        Stopwatch sw = new Stopwatch();
        TetMesh tm = new TetMesh();
        for (int inode = 0; inode < nnode; ++inode) {
            float x = random.nextFloat();
            float y = random.nextFloat();
            float z = random.nextFloat();
            TetMesh.Node node = new TetMesh.Node(x, y, z);
            tm.addNode(node);
        }
        for (int itest = 0; itest < ntest; ++itest) {
            float[] x = new float[nfind];
            float[] y = new float[nfind];
            float[] z = new float[nfind];
            for (int ifind = 0; ifind < nfind; ++ifind) {
                x[ifind] = random.nextFloat();
                y[ifind] = random.nextFloat();
                z[ifind] = random.nextFloat();
            }
            TetMesh.Node[] nfast = new TetMesh.Node[nfind];
            sw.reset();
            sw.start();
            for (int ifind = 0; ifind < nfind; ++ifind) {
                nfast[ifind] = tm.findNodeNearest(x[ifind], y[ifind], z[ifind]);
            }
            sw.stop();
            int sfast = (int)((double)nfind / sw.time());
            TetMesh.Node[] nslow = new TetMesh.Node[nfind];
            sw.reset();
            sw.start();
            for (int ifind = 0; ifind < nfind; ++ifind) {
                nslow[ifind] = tm.findNodeNearestSlow(x[ifind], y[ifind], z[ifind]);
            }
            sw.stop();
            int sslow = (int)((double)nfind / sw.time());
            for (int ifind = 0; ifind < nfind; ++ifind) {
                if (nfast[ifind] != nslow[ifind]) {
                    float xfast = nfast[ifind].x();
                    float yfast = nfast[ifind].y();
                    float zfast = nfast[ifind].z();
                    float xslow = nslow[ifind].x();
                    float yslow = nslow[ifind].y();
                    float zslow = nslow[ifind].z();
                    float dxfast = xfast - x[ifind];
                    float dyfast = yfast - y[ifind];
                    float dzfast = zfast - z[ifind];
                    float dxslow = xslow - x[ifind];
                    float dyslow = yslow - y[ifind];
                    float dzslow = zslow - z[ifind];
                    float dsfast = dxfast * dxfast + dyfast * dyfast + dzfast * dzfast;
                    float dsslow = dxslow * dxslow + dyslow * dyslow + dzslow * dzslow;
                    System.out.println("ifind=" + ifind + " fast/slow=" + dsfast + "/" + dsslow);
                }
                TetMeshTest.assertTrue((nfast[ifind] == nslow[ifind] ? 1 : 0) != 0);
            }
            System.out.println("Find fast/slow nodes per sec = " + sfast + "/" + sslow);
        }
    }

    private static class TetListener
    implements TetMesh.TetListener {
        private int _nadded;
        private int _nremoved;

        private TetListener() {
        }

        @Override
        public void tetAdded(TetMesh mesh, TetMesh.Tet tet) {
            ++this._nadded;
        }

        @Override
        public void tetRemoved(TetMesh mesh, TetMesh.Tet tet) {
            ++this._nremoved;
        }

        public int countAdded() {
            return this._nadded;
        }

        public int countRemoved() {
            return this._nremoved;
        }
    }
}

