/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.KaiserWindow;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import java.util.HashMap;

public class SincInterp {
    private static final double EWIN_FRAC = 0.9;
    private static final int NTAB_MAX = 16385;
    private Extrapolation _extrap = Extrapolation.ZERO;
    private Table _table;
    private int _lsinc;
    private int _nsinc;
    private double _dsinc;
    private float[][] _asinc;
    private double _nsincm1;
    private int _ishift;
    private static final HashMap<Design, Table> _tables = new HashMap();

    public static SincInterp fromErrorAndLength(double emax, int lmax) {
        return new SincInterp(emax, 0.0, lmax);
    }

    public static SincInterp fromErrorAndFrequency(double emax, double fmax) {
        return new SincInterp(emax, fmax, 0);
    }

    public static SincInterp fromFrequencyAndLength(double fmax, int lmax) {
        return new SincInterp(0.0, fmax, lmax);
    }

    public SincInterp() {
        this(0.0, 0.3, 8);
    }

    public double getMaximumError() {
        return this._table.design.emax;
    }

    public double getMaximumFrequency() {
        return this._table.design.fmax;
    }

    public int getMaximumLength() {
        return this._table.design.lmax;
    }

    public long getTableBytes() {
        long nbytes = 4L;
        nbytes *= (long)this._table.lsinc;
        return nbytes *= (long)this._table.nsinc;
    }

    public Extrapolation getExtrapolation() {
        return this._extrap;
    }

    public void setExtrapolation(Extrapolation extrap) {
        this._extrap = extrap;
    }

    public float interpolate(int nxu, double dxu, double fxu, float[] yu, double xi) {
        double xscale = 1.0 / dxu;
        double xshift = (double)this._lsinc - fxu * xscale;
        int nxum = nxu - this._lsinc;
        return this.interpolate(xscale, xshift, nxum, nxu, yu, xi);
    }

    public void interpolate(int nxu, double dxu, double fxu, float[] yu, int nxi, float[] xi, float[] yi) {
        double xscale = 1.0 / dxu;
        double xshift = (double)this._lsinc - fxu * xscale;
        int nxum = nxu - this._lsinc;
        for (int ixi = 0; ixi < nxi; ++ixi) {
            yi[ixi] = this.interpolate(xscale, xshift, nxum, nxu, yu, xi[ixi]);
        }
    }

    public void interpolate(int nxu, double dxu, double fxu, float[] yu, int nxi, double dxi, double fxi, float[] yi) {
        if (dxu == dxi) {
            this.shift(nxu, dxu, fxu, yu, nxi, fxi, yi);
        } else {
            double xscale = 1.0 / dxu;
            double xshift = (double)this._lsinc - fxu * xscale;
            int nxum = nxu - this._lsinc;
            for (int ixi = 0; ixi < nxi; ++ixi) {
                double xi = fxi + (double)ixi * dxi;
                yi[ixi] = this.interpolate(xscale, xshift, nxum, nxu, yu, xi);
            }
        }
    }

    public float interpolate(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, float[][] yu, double x1i, double x2i) {
        double x1scale = 1.0 / dx1u;
        double x2scale = 1.0 / dx2u;
        double x1shift = (double)this._lsinc - fx1u * x1scale;
        double x2shift = (double)this._lsinc - fx2u * x2scale;
        int nx1um = nx1u - this._lsinc;
        int nx2um = nx2u - this._lsinc;
        return this.interpolate(x1scale, x1shift, nx1um, nx1u, x2scale, x2shift, nx2um, nx2u, yu, x1i, x2i);
    }

    public float interpolate(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, int nx3u, double dx3u, double fx3u, float[][][] yu, double x1i, double x2i, double x3i) {
        double x1scale = 1.0 / dx1u;
        double x2scale = 1.0 / dx2u;
        double x3scale = 1.0 / dx3u;
        double x1shift = (double)this._lsinc - fx1u * x1scale;
        double x2shift = (double)this._lsinc - fx2u * x2scale;
        double x3shift = (double)this._lsinc - fx3u * x3scale;
        int nx1um = nx1u - this._lsinc;
        int nx2um = nx2u - this._lsinc;
        int nx3um = nx3u - this._lsinc;
        return this.interpolate(x1scale, x1shift, nx1um, nx1u, x2scale, x2shift, nx2um, nx2u, x3scale, x3shift, nx3um, nx3u, yu, x1i, x2i, x3i);
    }

    public float interpolate(Sampling sxu, float[] yu, double xi) {
        Check.argument(sxu.isUniform(), "input sampling is uniform");
        return this.interpolate(sxu.getCount(), sxu.getDelta(), sxu.getFirst(), yu, xi);
    }

    public void interpolate(Sampling sxu, float[] yu, Sampling sxi, float[] yi) {
        Check.argument(sxu.isUniform(), "input sampling is uniform");
        if (sxi.isUniform()) {
            this.interpolate(sxu.getCount(), sxu.getDelta(), sxu.getFirst(), yu, sxi.getCount(), sxi.getDelta(), sxi.getFirst(), yi);
        } else {
            int nxu = sxu.getCount();
            int nxi = sxi.getCount();
            double xscale = 1.0 / sxu.getDelta();
            double xshift = (double)this._lsinc - sxu.getFirst() * xscale;
            int nxum = nxu - this._lsinc;
            for (int ixi = 0; ixi < nxi; ++ixi) {
                double xi = sxi.getValue(ixi);
                yi[ixi] = this.interpolate(xscale, xshift, nxum, nxu, yu, xi);
            }
        }
    }

    public float interpolate(Sampling sx1u, Sampling sx2u, float[][] yu, double x1i, double x2i) {
        Check.argument(sx1u.isUniform(), "input sampling of x1 is uniform");
        Check.argument(sx2u.isUniform(), "input sampling of x2 is uniform");
        return this.interpolate(sx1u.getCount(), sx1u.getDelta(), sx1u.getFirst(), sx2u.getCount(), sx2u.getDelta(), sx2u.getFirst(), yu, x1i, x2i);
    }

    public float interpolate(Sampling sx1u, Sampling sx2u, Sampling sx3u, float[][][] yu, double x1i, double x2i, double x3i) {
        Check.argument(sx1u.isUniform(), "input sampling of x1 is uniform");
        Check.argument(sx2u.isUniform(), "input sampling of x2 is uniform");
        Check.argument(sx3u.isUniform(), "input sampling of x3 is uniform");
        return this.interpolate(sx1u.getCount(), sx1u.getDelta(), sx1u.getFirst(), sx2u.getCount(), sx2u.getDelta(), sx2u.getFirst(), sx3u.getCount(), sx3u.getDelta(), sx3u.getFirst(), yu, x1i, x2i, x3i);
    }

    public void interpolateComplex(int nxu, double dxu, double fxu, float[] yu, int nxi, double dxi, double fxi, float[] yi) {
        double xscale = 1.0 / dxu;
        double xshift = (double)this._lsinc - fxu * xscale;
        int nxum = nxu - this._lsinc;
        for (int ixi = 0; ixi < nxi; ++ixi) {
            double xi = fxi + (double)ixi * dxi;
            this.interpolateComplex(xscale, xshift, nxum, nxu, yu, ixi, xi, yi);
        }
    }

    public void interpolateComplex(int nxu, double dxu, double fxu, float[] yu, int nxi, float[] xi, float[] yi) {
        double xscale = 1.0 / dxu;
        double xshift = (double)this._lsinc - fxu * xscale;
        int nxum = nxu - this._lsinc;
        for (int ixi = 0; ixi < nxi; ++ixi) {
            this.interpolateComplex(xscale, xshift, nxum, nxu, yu, ixi, (double)xi[ixi], yi);
        }
    }

    public void interpolateComplex(Sampling sxu, float[] yu, Sampling sxi, float[] yi) {
        Check.argument(sxu.isUniform(), "input sampling is uniform");
        if (sxi.isUniform()) {
            this.interpolateComplex(sxu.getCount(), sxu.getDelta(), sxu.getFirst(), yu, sxi.getCount(), sxi.getDelta(), sxi.getFirst(), yi);
        } else {
            int nxu = sxu.getCount();
            int nxi = sxi.getCount();
            double xscale = 1.0 / sxu.getDelta();
            double xshift = (double)this._lsinc - sxu.getFirst() * xscale;
            int nxum = nxu - this._lsinc;
            for (int ixi = 0; ixi < nxi; ++ixi) {
                double xi = sxi.getValue(ixi);
                this.interpolateComplex(xscale, xshift, nxum, nxu, yu, ixi, xi, yi);
            }
        }
    }

    public void accumulate(double xa, float ya, int nxu, double dxu, double fxu, float[] yu) {
        double xscale = 1.0 / dxu;
        double xshift = (double)this._lsinc - fxu * xscale;
        int nxum = nxu - this._lsinc;
        this.accumulate(xscale, xshift, nxum, xa, ya, nxu, yu);
    }

    public void accumulate(int nxa, float[] xa, float[] ya, int nxu, double dxu, double fxu, float[] yu) {
        double xscale = 1.0 / dxu;
        double xshift = (double)this._lsinc - fxu * xscale;
        int nxum = nxu - this._lsinc;
        for (int ixa = 0; ixa < nxa; ++ixa) {
            this.accumulate(xscale, xshift, nxum, xa[ixa], ya[ixa], nxu, yu);
        }
    }

    public float[][] getTable() {
        return ArrayMath.copy(this._table.asinc);
    }

    private SincInterp(double emax, double fmax, int lmax) {
        Check.argument(emax == 0.0 && fmax != 0.0 && lmax != 0 || emax != 0.0 && fmax == 0.0 && lmax != 0 || emax != 0.0 && fmax != 0.0 && lmax == 0, "exactly one of emax, fmax, and lmax is zero");
        if (emax == 0.0) {
            Check.argument(fmax < 0.5, "fmax<0.5");
            Check.argument(lmax >= 8, "lmax>=8");
            Check.argument(lmax % 2 == 0, "lmax is even");
            Check.argument((1.0 - 2.0 * fmax) * (double)lmax > 1.0, "(1.0-2.0*fmax)*lmax>1.0");
        } else if (fmax == 0.0) {
            Check.argument(emax <= 0.1, "emax<=0.1");
            Check.argument(lmax >= 8, "lmax>=8");
            Check.argument(lmax % 2 == 0, "lmax is even");
        } else if (lmax == 0) {
            Check.argument(emax <= 0.1, "emax<=0.1");
            Check.argument(fmax < 0.5, "fmax<0.5");
        }
        this._table = SincInterp.getTable(emax, fmax, lmax);
        this._lsinc = this._table.lsinc;
        this._nsinc = this._table.nsinc;
        this._nsincm1 = this._table.nsincm1;
        this._ishift = this._table.ishift;
        this._dsinc = this._table.dsinc;
        this._asinc = this._table.asinc;
    }

    private static Table makeTable(Design design) {
        int nsinc;
        KaiserWindow kwin;
        double emax = design.emax;
        double fmax = design.fmax;
        int lmax = design.lmax;
        double wwin = 2.0 * (0.5 - fmax);
        double ewin = emax * 0.9;
        if (emax == 0.0) {
            double etabMin;
            double emaxMin;
            kwin = KaiserWindow.fromWidthAndLength(wwin, lmax);
            ewin = 3.0 * kwin.getError();
            emax = ewin / 0.9;
            if (emax < (emaxMin = (etabMin = 3.455751918948773 * fmax / 16384.0) / 0.09999999999999998)) {
                emax = emaxMin;
                ewin = emax * 0.9;
            }
        } else if (fmax == 0.0) {
            kwin = KaiserWindow.fromErrorAndLength(ewin / 3.0, lmax);
            fmax = ArrayMath.max(0.0, 0.5 - 0.5 * kwin.getWidth());
        } else {
            kwin = KaiserWindow.fromErrorAndWidth(ewin / 3.0, wwin);
            double lwin = kwin.getLength();
            for (lmax = (int)lwin; (double)lmax < lwin || lmax < 8 || lmax % 2 == 1; ++lmax) {
            }
            kwin = KaiserWindow.fromErrorAndLength(ewin / 3.0, lmax);
        }
        double etab = emax - ewin;
        double dsinc = fmax > 0.0 ? etab / (Math.PI * fmax) : 1.0;
        int nsincMin = 1 + (int)ArrayMath.ceil(1.0 / dsinc);
        for (nsinc = 2; nsinc < nsincMin; nsinc *= 2) {
        }
        int lsinc = lmax;
        Table table = SincInterp.makeTable(++nsinc, lsinc, kwin);
        table.design = new Design(emax, fmax, lmax);
        _tables.put(design, table);
        return table;
    }

    private static Table makeTable(int nsinc, int lsinc, KaiserWindow kwin) {
        float[][] asinc = new float[nsinc][lsinc];
        int nsincm1 = nsinc - 1;
        int ishift = -lsinc - lsinc / 2 + 1;
        double dsinc = 1.0 / (double)(nsinc - 1);
        for (int j = 0; j < lsinc; ++j) {
            asinc[0][j] = 0.0f;
            asinc[nsinc - 1][j] = 0.0f;
        }
        asinc[0][lsinc / 2 - 1] = 1.0f;
        asinc[nsinc - 1][lsinc / 2] = 1.0f;
        for (int isinc = 1; isinc < nsinc - 1; ++isinc) {
            double x = (double)(-lsinc / 2 + 1) - dsinc * (double)isinc;
            int i = 0;
            while (i < lsinc) {
                asinc[isinc][i] = (float)(SincInterp.sinc(x) * kwin.evaluate(x));
                ++i;
                x += 1.0;
            }
        }
        Table table = new Table();
        table.lsinc = lsinc;
        table.nsinc = nsinc;
        table.nsincm1 = nsincm1;
        table.ishift = ishift;
        table.dsinc = dsinc;
        table.asinc = asinc;
        return table;
    }

    private static double sinc(double x) {
        return x != 0.0 ? ArrayMath.sin(Math.PI * x) / (Math.PI * x) : 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table getTable(double emax, double fmax, int lmax) {
        Design design = new Design(emax, fmax, lmax);
        HashMap<Design, Table> hashMap = _tables;
        synchronized (hashMap) {
            Table table = _tables.get(design);
            if (table == null) {
                table = SincInterp.makeTable(design);
            }
            return table;
        }
    }

    private float interpolate(double xscale, double xshift, int nxum, int nxu, float[] yu, double x) {
        float yr;
        block6: {
            float[] asinc;
            int kyu;
            block7: {
                block5: {
                    double xn = xshift + x * xscale;
                    int ixn = (int)xn;
                    kyu = this._ishift + ixn;
                    double frac = xn - (double)ixn;
                    if (frac < 0.0) {
                        frac += 1.0;
                    }
                    int ksinc = (int)(frac * this._nsincm1 + 0.5);
                    asinc = this._asinc[ksinc];
                    yr = 0.0f;
                    if (kyu < 0 || kyu > nxum) break block5;
                    int isinc = 0;
                    while (isinc < this._lsinc) {
                        yr += yu[kyu] * asinc[isinc];
                        ++isinc;
                        ++kyu;
                    }
                    break block6;
                }
                if (this._extrap != Extrapolation.ZERO) break block7;
                int isinc = 0;
                while (isinc < this._lsinc) {
                    if (0 <= kyu && kyu < nxu) {
                        yr += yu[kyu] * asinc[isinc];
                    }
                    ++isinc;
                    ++kyu;
                }
                break block6;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block6;
            int isinc = 0;
            while (isinc < this._lsinc) {
                int jyu = kyu < 0 ? 0 : (nxu <= kyu ? nxu - 1 : kyu);
                yr += yu[jyu] * asinc[isinc];
                ++isinc;
                ++kyu;
            }
        }
        return yr;
    }

    private void shift(int nxu, double dxu, double fxu, float[] yu, int nxi, double fxi, float[] yi) {
        double xi;
        int ixi;
        double lxu = fxu + (double)(nxu - 1) * dxu;
        double xscale = 1.0 / dxu;
        double xshift = (double)this._lsinc - fxu * xscale;
        int nxum = nxu - this._lsinc;
        double dx = dxu;
        double x1 = fxu + dxu * (double)this._lsinc / 2.0;
        double x2 = lxu - dxu * (double)this._lsinc / 2.0;
        double x1n = (x1 - fxi) / dx;
        double x2n = (x2 - fxi) / dx;
        int ix1 = ArrayMath.max(0, ArrayMath.min(nxi, (int)x1n + 1));
        int ix2 = ArrayMath.max(0, ArrayMath.min(nxi, (int)x2n - 1));
        for (ixi = 0; ixi < ix1; ++ixi) {
            xi = fxi + (double)ixi * dx;
            yi[ixi] = this.interpolate(xscale, xshift, nxum, nxu, yu, xi);
        }
        for (ixi = ix2; ixi < nxi; ++ixi) {
            xi = fxi + (double)ixi * dx;
            yi[ixi] = this.interpolate(xscale, xshift, nxum, nxu, yu, xi);
        }
        double xn = xshift + (fxi + (double)ix1 * dx) * xscale;
        int ixn = (int)xn;
        int kyu = this._ishift + ixn;
        double frac = xn - (double)ixn;
        if (frac < 0.0) {
            frac += 1.0;
        }
        int ksinc = (int)(frac * this._nsincm1 + 0.5);
        float[] asinc = this._asinc[ksinc];
        int ix = ix1;
        while (ix < ix2) {
            float yr = 0.0f;
            int isinc = 0;
            int jyu = kyu;
            while (isinc < this._lsinc) {
                yr += yu[jyu] * asinc[isinc];
                ++isinc;
                ++jyu;
            }
            yi[ix] = yr;
            ++ix;
            ++kyu;
        }
    }

    private void accumulate(double xscale, double xshift, int nxum, double x, float y, int nxu, float[] yu) {
        block6: {
            float[] asinc;
            int kyu;
            block7: {
                block5: {
                    double xn = xshift + x * xscale;
                    int ixn = (int)xn;
                    kyu = this._ishift + ixn;
                    double frac = xn - (double)ixn;
                    if (frac < 0.0) {
                        frac += 1.0;
                    }
                    int ksinc = (int)(frac * this._nsincm1 + 0.5);
                    asinc = this._asinc[ksinc];
                    if (kyu < 0 || kyu > nxum) break block5;
                    for (int isinc = 0; isinc < this._lsinc; ++isinc) {
                        int n = kyu++;
                        yu[n] = yu[n] + y * asinc[isinc];
                    }
                    break block6;
                }
                if (this._extrap != Extrapolation.ZERO) break block7;
                int isinc = 0;
                while (isinc < this._lsinc) {
                    if (0 <= kyu && kyu < nxu) {
                        int n = kyu;
                        yu[n] = yu[n] + y * asinc[isinc];
                    }
                    ++isinc;
                    ++kyu;
                }
                break block6;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block6;
            int isinc = 0;
            while (isinc < this._lsinc) {
                int jyu;
                int n = jyu = kyu < 0 ? 0 : (nxu <= kyu ? nxu - 1 : kyu);
                yu[n] = yu[n] + y * asinc[isinc];
                ++isinc;
                ++kyu;
            }
        }
    }

    private float interpolate(double x1scale, double x1shift, int nx1um, int nx1u, double x2scale, double x2shift, int nx2um, int nx2u, float[][] yu, double x1, double x2) {
        float yr;
        block11: {
            float[] asinc2;
            float[] asinc1;
            int ky2u;
            int ky1u;
            block12: {
                block10: {
                    double x1n = x1shift + x1 * x1scale;
                    double x2n = x2shift + x2 * x2scale;
                    int ix1n = (int)x1n;
                    int ix2n = (int)x2n;
                    ky1u = this._ishift + ix1n;
                    ky2u = this._ishift + ix2n;
                    double frac1 = x1n - (double)ix1n;
                    double frac2 = x2n - (double)ix2n;
                    if (frac1 < 0.0) {
                        frac1 += 1.0;
                    }
                    if (frac2 < 0.0) {
                        frac2 += 1.0;
                    }
                    int ksinc1 = (int)(frac1 * this._nsincm1 + 0.5);
                    int ksinc2 = (int)(frac2 * this._nsincm1 + 0.5);
                    asinc1 = this._asinc[ksinc1];
                    asinc2 = this._asinc[ksinc2];
                    yr = 0.0f;
                    if (ky1u < 0 || ky1u > nx1um || ky2u < 0 || ky2u > nx2um) break block10;
                    int i2sinc = 0;
                    while (i2sinc < this._lsinc) {
                        float asinc22 = asinc2[i2sinc];
                        float[] yuk2 = yu[ky2u];
                        float yr2 = 0.0f;
                        int i1sinc = 0;
                        int my1u = ky1u;
                        while (i1sinc < this._lsinc) {
                            yr2 += yuk2[my1u] * asinc1[i1sinc];
                            ++i1sinc;
                            ++my1u;
                        }
                        yr += asinc22 * yr2;
                        ++i2sinc;
                        ++ky2u;
                    }
                    break block11;
                }
                if (this._extrap != Extrapolation.ZERO) break block12;
                int i2sinc = 0;
                while (i2sinc < this._lsinc) {
                    if (0 <= ky2u && ky2u < nx2u) {
                        int i1sinc = 0;
                        int my1u = ky1u;
                        while (i1sinc < this._lsinc) {
                            if (0 <= my1u && my1u < nx1u) {
                                yr += yu[ky2u][my1u] * asinc2[i2sinc] * asinc1[i1sinc];
                            }
                            ++i1sinc;
                            ++my1u;
                        }
                    }
                    ++i2sinc;
                    ++ky2u;
                }
                break block11;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block11;
            int i2sinc = 0;
            while (i2sinc < this._lsinc) {
                int jy2u = ky2u < 0 ? 0 : (nx2u <= ky2u ? nx2u - 2 : ky2u);
                int i1sinc = 0;
                int my1u = ky1u;
                while (i1sinc < this._lsinc) {
                    int jy1u = my1u < 0 ? 0 : (nx1u <= my1u ? nx1u - 1 : my1u);
                    yr += yu[jy2u][jy1u] * asinc2[i2sinc] * asinc1[i1sinc];
                    ++i1sinc;
                    ++my1u;
                }
                ++i2sinc;
                ++ky2u;
            }
        }
        return yr;
    }

    private float interpolate(double x1scale, double x1shift, int nx1um, int nx1u, double x2scale, double x2shift, int nx2um, int nx2u, double x3scale, double x3shift, int nx3um, int nx3u, float[][][] yu, double x1, double x2, double x3) {
        float yr;
        block16: {
            float[] asinc3;
            float[] asinc2;
            float[] asinc1;
            int ky3u;
            int ky2u;
            int ky1u;
            block17: {
                block15: {
                    double x1n = x1shift + x1 * x1scale;
                    double x2n = x2shift + x2 * x2scale;
                    double x3n = x3shift + x3 * x3scale;
                    int ix1n = (int)x1n;
                    int ix2n = (int)x2n;
                    int ix3n = (int)x3n;
                    ky1u = this._ishift + ix1n;
                    ky2u = this._ishift + ix2n;
                    ky3u = this._ishift + ix3n;
                    double frac1 = x1n - (double)ix1n;
                    double frac2 = x2n - (double)ix2n;
                    double frac3 = x3n - (double)ix3n;
                    if (frac1 < 0.0) {
                        frac1 += 1.0;
                    }
                    if (frac2 < 0.0) {
                        frac2 += 1.0;
                    }
                    if (frac3 < 0.0) {
                        frac3 += 1.0;
                    }
                    int ksinc1 = (int)(frac1 * this._nsincm1 + 0.5);
                    int ksinc2 = (int)(frac2 * this._nsincm1 + 0.5);
                    int ksinc3 = (int)(frac3 * this._nsincm1 + 0.5);
                    asinc1 = this._asinc[ksinc1];
                    asinc2 = this._asinc[ksinc2];
                    asinc3 = this._asinc[ksinc3];
                    yr = 0.0f;
                    if (ky1u < 0 || ky1u > nx1um || ky2u < 0 || ky2u > nx2um || ky3u < 0 || ky3u > nx3um) break block15;
                    int i3sinc = 0;
                    while (i3sinc < this._lsinc) {
                        float asinc33 = asinc3[i3sinc];
                        float[][] yu3 = yu[ky3u];
                        float yr2 = 0.0f;
                        int i2sinc = 0;
                        int my2u = ky2u;
                        while (i2sinc < this._lsinc) {
                            float asinc22 = asinc2[i2sinc];
                            float[] yu32 = yu3[my2u];
                            float yr1 = 0.0f;
                            int i1sinc = 0;
                            int my1u = ky1u;
                            while (i1sinc < this._lsinc) {
                                yr1 += yu32[my1u] * asinc1[i1sinc];
                                ++i1sinc;
                                ++my1u;
                            }
                            yr2 += asinc22 * yr1;
                            ++i2sinc;
                            ++my2u;
                        }
                        yr += asinc33 * yr2;
                        ++i3sinc;
                        ++ky3u;
                    }
                    break block16;
                }
                if (this._extrap != Extrapolation.ZERO) break block17;
                int i3sinc = 0;
                while (i3sinc < this._lsinc) {
                    if (0 <= ky3u && ky3u < nx3u) {
                        int i2sinc = 0;
                        int my2u = ky2u;
                        while (i2sinc < this._lsinc) {
                            if (0 <= my2u && my2u < nx2u) {
                                int i1sinc = 0;
                                int my1u = ky1u;
                                while (i1sinc < this._lsinc) {
                                    if (0 <= my1u && my1u < nx1u) {
                                        yr += yu[ky3u][my2u][my1u] * asinc3[i3sinc] * asinc2[i2sinc] * asinc1[i1sinc];
                                    }
                                    ++i1sinc;
                                    ++my1u;
                                }
                            }
                            ++i2sinc;
                            ++my2u;
                        }
                    }
                    ++i3sinc;
                    ++ky3u;
                }
                break block16;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block16;
            int i3sinc = 0;
            while (i3sinc < this._lsinc) {
                int jy3u = ky3u < 0 ? 0 : (nx3u <= ky3u ? nx3u - 2 : ky3u);
                int i2sinc = 0;
                int my2u = ky2u;
                while (i2sinc < this._lsinc) {
                    int jy2u = my2u < 0 ? 0 : (nx2u <= my2u ? nx2u - 2 : my2u);
                    int i1sinc = 0;
                    int my1u = ky1u;
                    while (i1sinc < this._lsinc) {
                        int jy1u = my1u < 0 ? 0 : (nx1u <= my1u ? nx1u - 1 : my1u);
                        yr += yu[jy3u][jy2u][jy1u] * asinc3[i3sinc] * asinc2[i2sinc] * asinc1[i1sinc];
                        ++i1sinc;
                        ++my1u;
                    }
                    ++i2sinc;
                    ++my2u;
                }
                ++i3sinc;
                ++ky3u;
            }
        }
        return yr;
    }

    private void interpolateComplex(double xscale, double xshift, int nxum, int nxu, float[] yu, int ix, double x, float[] y) {
        int isinc;
        double xn = xshift + x * xscale;
        int ixn = (int)xn;
        int kyu = this._ishift + ixn;
        double frac = xn - (double)ixn;
        if (frac < 0.0) {
            frac += 1.0;
        }
        int ksinc = (int)(frac * this._nsincm1 + 0.5);
        float[] asinc = this._asinc[ksinc];
        float yr = 0.0f;
        float yi = 0.0f;
        if (kyu >= 0 && kyu <= nxum) {
            isinc = 0;
            while (isinc < this._lsinc) {
                int jyu = 2 * kyu;
                float asinci = asinc[isinc];
                yr += yu[jyu] * asinci;
                yi += yu[jyu + 1] * asinci;
                ++isinc;
                ++kyu;
            }
        } else if (this._extrap == Extrapolation.ZERO) {
            isinc = 0;
            while (isinc < this._lsinc) {
                if (0 <= kyu && kyu < nxu) {
                    int jyu = 2 * kyu;
                    float asinci = asinc[isinc];
                    yr += yu[jyu] * asinci;
                    yi += yu[jyu + 1] * asinci;
                }
                ++isinc;
                ++kyu;
            }
        } else if (this._extrap == Extrapolation.CONSTANT) {
            isinc = 0;
            while (isinc < this._lsinc) {
                int jyu = kyu < 0 ? 0 : (nxu <= kyu ? 2 * nxu - 2 : 2 * kyu);
                float asinci = asinc[isinc];
                yr += yu[jyu] * asinci;
                yi += yu[jyu + 1] * asinci;
                ++isinc;
                ++kyu;
            }
        }
        int jx = 2 * ix;
        y[jx] = yr;
        y[jx + 1] = yi;
    }

    private static class Table {
        Design design;
        int lsinc;
        int nsinc;
        int nsincm1;
        int ishift;
        double dsinc;
        float[][] asinc;

        private Table() {
        }
    }

    private static class Design {
        double emax;
        double fmax;
        int lmax;

        Design(double emax, double fmax, int lmax) {
            this.emax = emax;
            this.fmax = fmax;
            this.lmax = lmax;
        }

        public int hashCode() {
            long lemax = Double.doubleToLongBits(this.emax);
            long lfmax = Double.doubleToLongBits(this.fmax);
            return (int)(lemax ^ lemax >>> 32) ^ (int)(lfmax ^ lfmax >>> 32) ^ this.lmax;
        }

        public boolean equals(Object object) {
            Design that = (Design)object;
            return this.emax == that.emax && this.fmax == that.fmax && this.lmax == that.lmax;
        }
    }

    public static enum Extrapolation {
        ZERO,
        CONSTANT;

    }
}

