/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Eigen;
import edu.mines.jtk.dsp.Tensors2;
import edu.mines.jtk.util.ArrayMath;

public class EigenTensors2
implements Tensors2 {
    private int _n1;
    private int _n2;
    private float[][] _au;
    private float[][] _av;
    private float[][] _u1;
    private float[][] _u2;

    public EigenTensors2(int n1, int n2) {
        this._n1 = n1;
        this._n2 = n2;
        this._au = new float[n2][n1];
        this._av = new float[n2][n1];
        this._u1 = new float[n2][n1];
        this._u2 = new float[n2][n1];
    }

    public EigenTensors2(float[][] u1, float[][] u2, float[][] au, float[][] av) {
        this(u1[0].length, u1.length);
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                float aui = au[i2][i1];
                float avi = av[i2][i1];
                float u1i = u1[i2][i1];
                float u2i = u2[i2][i1];
                this.setEigenvalues(i1, i2, aui, avi);
                this.setEigenvectorU(i1, i2, u1i, u2i);
            }
        }
    }

    public EigenTensors2(EigenTensors2 t) {
        this(t._u1, t._u2, t._au, t._av);
    }

    public int getN1() {
        return this._n1;
    }

    public int getN2() {
        return this._n2;
    }

    @Override
    public void getTensor(int i1, int i2, float[] a) {
        float au = this._au[i2][i1];
        float av = this._av[i2][i1];
        float u1 = this._u1[i2][i1];
        float u2 = this._u2[i2][i1];
        a[0] = (au -= av) * u1 * u1 + av;
        a[1] = au * u1 * u2;
        a[2] = au * u2 * u2 + av;
    }

    public float[] getTensor(int i1, int i2) {
        float[] a = new float[3];
        this.getTensor(i1, i2, a);
        return a;
    }

    public void getEigenvalues(int i1, int i2, float[] a) {
        a[0] = this._au[i2][i1];
        a[1] = this._av[i2][i1];
    }

    public float[] getEigenvalues(int i1, int i2) {
        float[] a = new float[2];
        this.getEigenvalues(i1, i2, a);
        return a;
    }

    public void getEigenvalues(float[][] au, float[][] av) {
        ArrayMath.copy(this._au, au);
        ArrayMath.copy(this._av, av);
    }

    public void getEigenvectorU(int i1, int i2, float[] u) {
        u[0] = this._u1[i2][i1];
        u[1] = this._u2[i2][i1];
    }

    public float[] getEigenvectorU(int i1, int i2) {
        float[] u = new float[2];
        this.getEigenvectorU(i1, i2, u);
        return u;
    }

    public void getEigenvectorV(int i1, int i2, float[] v) {
        v[0] = this._u2[i2][i1];
        v[1] = -this._u1[i2][i1];
    }

    public float[] getEigenvectorV(int i1, int i2) {
        float[] v = new float[2];
        this.getEigenvectorV(i1, i2, v);
        return v;
    }

    public void setTensor(int i1, int i2, float[] a) {
        this.setTensor(i1, i2, a[0], a[1], a[2]);
    }

    public void setTensor(int i1, int i2, float a11, float a12, float a22) {
        float av;
        float[][] aa = new float[][]{{a11, a12}, {a12, a22}};
        float[][] vv = new float[2][2];
        float[] ev = new float[2];
        Eigen.solveSymmetric22(aa, vv, ev);
        float[] u = vv[0];
        float au = ev[0];
        if (au < 0.0f) {
            au = 0.0f;
        }
        if ((av = ev[1]) < 0.0f) {
            av = 0.0f;
        }
        this.setEigenvectorU(i1, i2, u);
        this.setEigenvalues(i1, i2, au, av);
    }

    public void setEigenvalues(float au, float av) {
        ArrayMath.fill(au, this._au);
        ArrayMath.fill(av, this._av);
    }

    public void setEigenvalues(int i1, int i2, float au, float av) {
        this._au[i2][i1] = au;
        this._av[i2][i1] = av;
    }

    public void setEigenvalues(int i1, int i2, float[] a) {
        this.setEigenvalues(i1, i2, a[0], a[1]);
    }

    public void setEigenvalues(float[][] au, float[][] av) {
        ArrayMath.copy(au, this._au);
        ArrayMath.copy(av, this._av);
    }

    public void setEigenvectorU(int i1, int i2, float u1, float u2) {
        this._u1[i2][i1] = u1;
        this._u2[i2][i1] = u2;
    }

    public void setEigenvectorU(int i1, int i2, float[] u) {
        this.setEigenvectorU(i1, i2, u[0], u[1]);
    }

    public void scale(float[][] s) {
        for (int i2 = 0; i2 < this._n2; ++i2) {
            int i1 = 0;
            while (i1 < this._n1) {
                float si = s[i2][i1];
                float[] fArray = this._au[i2];
                int n = i1;
                fArray[n] = fArray[n] * si;
                float[] fArray2 = this._av[i2];
                int n2 = i1++;
                fArray2[n2] = fArray2[n2] * si;
            }
        }
    }

    public void invert() {
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                this._au[i2][i1] = 1.0f / this._au[i2][i1];
                this._av[i2][i1] = 1.0f / this._av[i2][i1];
            }
        }
    }

    public void invertStructure(double p0, double p1) {
        float amax = 0.0f;
        float amin = Float.MAX_VALUE;
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                float aui = this._au[i2][i1];
                float avi = this._av[i2][i1];
                if (avi < 0.0f) {
                    avi = 0.0f;
                }
                if (aui < avi) {
                    aui = avi;
                }
                if (avi < amin) {
                    amin = avi;
                }
                if (aui > amax) {
                    amax = aui;
                }
                this._au[i2][i1] = aui;
                this._av[i2][i1] = avi;
            }
        }
        float aeps = ArrayMath.max(1.4E-43f, 1.1920929E-7f * amax);
        amin += aeps;
        amax += aeps;
        float fp0 = (float)p0;
        float fp1 = (float)p1;
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                float aui = this._au[i2][i1] + aeps;
                float avi = this._av[i2][i1] + aeps;
                float a0i = ArrayMath.pow(amin / avi, fp0);
                float a1i = ArrayMath.pow(avi / aui, fp1);
                this._au[i2][i1] = a0i * a1i;
                this._av[i2][i1] = a0i;
            }
        }
    }
}

