/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imglib2.roi.LineRegionOfInterest;
import org.scijava.Context;

public class LineOverlay
extends AbstractROIOverlay<LineRegionOfInterest> {
    public LineOverlay() {
        super(new LineRegionOfInterest(new double[2], new double[2]));
    }

    public LineOverlay(Context context) {
        super(context, new LineRegionOfInterest(new double[2], new double[2]));
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    public LineOverlay(Context context, double[] ptStart, double[] ptEnd) {
        super(context, new LineRegionOfInterest(ptStart, ptEnd));
        assert (ptStart.length == ptEnd.length);
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    public void getLineStart(double[] pt) {
        ((LineRegionOfInterest)this.getRegionOfInterest()).getPoint1(pt);
    }

    public void getLineEnd(double[] pt) {
        ((LineRegionOfInterest)this.getRegionOfInterest()).getPoint2(pt);
    }

    public void setLineStart(double[] pt) {
        ((LineRegionOfInterest)this.getRegionOfInterest()).setPoint1(pt);
    }

    public void setLineEnd(double[] pt) {
        ((LineRegionOfInterest)this.getRegionOfInterest()).setPoint2(pt);
    }

    public double getLineStart(int dim) {
        return ((LineRegionOfInterest)this.getRegionOfInterest()).getPoint1(dim);
    }

    public double getLineEnd(int dim) {
        return ((LineRegionOfInterest)this.getRegionOfInterest()).getPoint2(dim);
    }

    public void setLineStart(double val, int dim) {
        ((LineRegionOfInterest)this.getRegionOfInterest()).setPoint1(val, dim);
    }

    public void setLineEnd(double val, int dim) {
        ((LineRegionOfInterest)this.getRegionOfInterest()).setPoint2(val, dim);
    }

    @Override
    public int numDimensions() {
        return ((LineRegionOfInterest)this.getRegionOfInterest()).numDimensions();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        super.writeExternal(out);
        LineRegionOfInterest roi = (LineRegionOfInterest)this.getRegionOfInterest();
        int numDims = roi.numDimensions();
        out.writeInt(numDims);
        for (i = 0; i < numDims; ++i) {
            out.writeDouble(roi.getPoint1(i));
        }
        for (i = 0; i < numDims; ++i) {
            out.writeDouble(roi.getPoint2(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        super.readExternal(in);
        int nDimensions = in.readInt();
        double[] pt1 = new double[nDimensions];
        double[] pt2 = new double[nDimensions];
        for (i = 0; i < nDimensions; ++i) {
            pt1[i] = in.readDouble();
        }
        for (i = 0; i < nDimensions; ++i) {
            pt2[i] = in.readDouble();
        }
        LineRegionOfInterest roi = (LineRegionOfInterest)this.getRegionOfInterest();
        roi.setPoint1(pt1);
        roi.setPoint1(pt2);
    }

    @Override
    public void move(double[] deltas) {
        ((LineRegionOfInterest)this.getRegionOfInterest()).move(deltas);
    }
}

