/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.webdav;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.iharder.Base64;
import net.imagej.plugins.uploaders.webdav.NetrcParser;
import net.imagej.updater.AbstractUploader;
import net.imagej.updater.FilesUploader;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.Uploadable;
import net.imagej.updater.Uploader;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.log.LogService;
import org.scijava.log.StderrLogService;
import org.scijava.plugin.Plugin;
import org.scijava.util.XML;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Plugin(type=Uploader.class)
public class WebDAVUploader
extends AbstractUploader {
    private String baseURL;
    private String username;
    private String password;
    private Set<String> existingDirectories;
    private LogService log;
    private boolean debug = false;
    private static Field methodField;

    public String getProtocol() {
        return "webdav";
    }

    public boolean login(FilesUploader uploader) {
        int colon;
        String host;
        if (!super.login(uploader)) {
            return false;
        }
        this.log = uploader.getLog();
        this.debug = this.log.isDebug();
        if (methodField == null) {
            try {
                methodField = HttpURLConnection.class.getDeclaredField("method");
                methodField.setAccessible(true);
            }
            catch (Throwable t) {
                this.log.error(t);
            }
        }
        if (!"".equals(host = uploader.getUploadHost())) {
            this.username = host;
            int colon2 = this.username.indexOf(58);
            if (colon2 < 0) {
                this.password = null;
            } else {
                this.password = this.username.substring(colon2 + 1);
                this.username = this.username.substring(0, colon2);
            }
        }
        UpdateSite site = uploader.getFilesCollection().getUpdateSite(uploader.getSiteName(), true);
        this.baseURL = site.getURL();
        if ((this.username == null || this.password == null) && (colon = this.baseURL.indexOf("://")) > 0) {
            try {
                int slash = this.baseURL.indexOf(47, colon + 3);
                String hostname = this.baseURL.substring(colon + 3, slash < 0 ? this.baseURL.length() : slash);
                NetrcParser netrcParser = new NetrcParser();
                NetrcParser.Credentials credentials = netrcParser.getCredentials(hostname, this.username);
                if (credentials != null) {
                    this.username = credentials.getUsername();
                    this.password = credentials.getPassword();
                }
            }
            catch (IOException e) {
                this.log.warn((Throwable)e);
            }
        }
        if (this.username == null) {
            uploader.getDefaultUsername();
            if (this.username == null) {
                this.username = UpdaterUserInterface.get().getString("Login for " + this.baseURL);
            }
            if (this.username == null) {
                return false;
            }
        }
        if (this.password == null) {
            String prompt = "Password for " + this.username + "@" + this.baseURL;
            this.password = UpdaterUserInterface.get().getPassword(prompt);
            if (this.password == null) {
                return false;
            }
        }
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
        this.existingDirectories = new HashSet<String>();
        if (!this.isAllowed()) {
            UpdaterUserInterface.get().error("User " + this.username + " lacks upload permissions for " + this.baseURL);
            return false;
        }
        try {
            if (!this.directoryExists("")) {
                UpdaterUserInterface.get().error(this.baseURL + " does not exist yet!");
                return false;
            }
        }
        catch (UnauthenticatedException e) {
            return false;
        }
        return true;
    }

    public void logout() {
        this.password = null;
        this.username = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void upload(List<Uploadable> sources, List<String> locks) throws IOException {
        this.timestamp = -1L;
        HashMap<Iterator<String>, String> tokens = new HashMap<Iterator<String>, String>();
        for (String lock : locks) {
            Iterator<String> path = lock + ".lock";
            String token = this.lock((String)((Object)path));
            tokens.put(path, token);
        }
        this.setTitle("Uploading");
        try {
            this.calculateTotalSize(sources);
            int count = 0;
            byte[] buf = new byte[16384];
            for (Uploadable source : sources) {
                int len;
                String target = source.getFilename();
                int slash = target.lastIndexOf(47);
                if (slash > 0 && !this.ensureDirectoryExists(target.substring(0, slash + 1))) {
                    throw new IOException("Could not make subdirectory for " + target);
                }
                this.addItem(source);
                InputStream input = source.getInputStream();
                int currentCount = 0;
                int currentTotal = (int)source.getFilesize();
                String token = (String)tokens.get(target);
                URL url = this.getURL(target, false);
                HttpURLConnection connection = token == null ? this.connect("PUT", url, null, new String[0]) : this.connect("PUT", url, null, "If", "<" + url + "> (<" + token + ">)");
                connection.setRequestProperty("Content-Length", "" + source.getFilesize());
                connection.setDoOutput(true);
                OutputStream out = connection.getOutputStream();
                while ((len = input.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                    this.setItemCount(currentCount += len, currentTotal);
                    this.setCount(count + currentCount, this.total);
                }
                input.close();
                count += currentCount;
                out.close();
                this.itemDone(source);
                int code = connection.getResponseCode();
                if (code == 201 || code == 204) continue;
                this.log.error((Object)("Code: " + code + " " + connection.getResponseMessage()));
                throw new IOException("Could not write " + target);
            }
            this.done();
            this.addItem("Moving locks");
            for (String lock : locks) {
                String source = lock + ".lock";
                if (this.move(source, lock, (String)tokens.get(source), true)) {
                    tokens.remove(source);
                    continue;
                }
                this.log.error((Object)("Could not move " + source + " to " + lock));
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
        finally {
            for (String key : tokens.keySet()) {
                String token;
                if (this.unlock(key, token = (String)tokens.get(key))) continue;
                throw new IOException("Could not unlock " + key + " with token " + token);
            }
        }
    }

    private String lock(String path) throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns='DAV:'><lockscope><exclusive/></lockscope><locktype><write/></locktype><owner><href>" + this.baseURL + "User:" + this.username + "</href></owner></lockinfo>";
        try {
            HttpURLConnection connection = this.connect("LOCK", this.getURL(path, false), xml, "Timeout", "Second-600");
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error obtaining lock for " + path + ": " + connection.getResponseCode() + " " + connection.getResponseMessage());
            }
            if (this.timestamp < 0L) {
                this.timestamp = Long.parseLong(UpdaterUtil.timestamp((long)connection.getHeaderFieldDate("Date", -1L)));
                if (this.timestamp < 0L) {
                    throw new IOException("Could not obtain date from the server");
                }
            }
            XML result = new XML(connection.getInputStream());
            String token = result.cdata("/prop/lockdiscovery/activelock/locktoken/href");
            if (this.debug) {
                this.log.info((Object)("Tried to obtain a lock (" + token + "):\n" + result));
            }
            if (token == null) {
                this.log.error((Object)("Expected lock for '" + path + "', got:\n" + result.toString()));
                throw new IOException("Could not obtain lock for " + path);
            }
            return token;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean unlock(String path, String token) {
        try {
            HttpURLConnection connection = this.connect("UNLOCK", this.getURL(path, false), null, "Lock-Token", "<" + token + ">");
            int code = connection.getResponseCode();
            if (code == 204) {
                return true;
            }
            this.log.error((Object)("Error removing lock from " + path + ": " + code + " " + connection.getResponseMessage()));
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
        return false;
    }

    private boolean move(String source, String target, String token, boolean force) {
        try {
            URL url = this.getURL(source, false);
            String targetURL = this.getURL(target, false).toString();
            HttpURLConnection connection = this.connect("MOVE", url, null, "Destination", targetURL, "Overwrite", force ? "T" : "F", "If", "<" + url + "> (<" + token + ">)");
            int code = connection.getResponseCode();
            if (code == 201 || code == 204) {
                return true;
            }
            this.log.error((Object)("Error moving " + source + " to " + target + ": " + code + " " + connection.getResponseMessage()));
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
        return false;
    }

    private boolean ensureDirectoryExists(String path) {
        if (this.existingDirectories.contains(path)) {
            return true;
        }
        try {
            if (this.directoryExists(path)) {
                this.existingDirectories.add(path);
                return true;
            }
        }
        catch (UnauthenticatedException e) {
            return false;
        }
        int slash = path.lastIndexOf(47, path.length() - 2);
        if (slash > 0 && !this.ensureDirectoryExists(path.substring(0, slash + 1))) {
            return false;
        }
        if (this.makeDirectory(path)) {
            this.existingDirectories.add(path);
            return true;
        }
        return false;
    }

    private XML propfind(String path) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><propfind xmlns=\"DAV:\"><allprop /></propfind>";
        try {
            HttpURLConnection connection = this.connect("PROPFIND", this.getURL(path, false), xml, new String[0]);
            return new XML(connection.getInputStream());
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return null;
        }
    }

    private boolean directoryExists(String path) throws UnauthenticatedException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><propfind xmlns=\"DAV:\"><prop><resourcetype/></prop></propfind>";
        try {
            HttpURLConnection connection = this.connect("PROPFIND", this.getURL(path, true), xml, new String[0]);
            try {
                XML result = new XML(connection.getInputStream());
                NodeList list = result.xpath("/multistatus/response/propstat/prop/resourcetype/collection");
                return list != null && list.getLength() > 0;
            }
            catch (IOException e) {
                if (connection.getResponseCode() == 401) {
                    throw new UnauthenticatedException();
                }
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            this.log.error((Throwable)e);
        }
        catch (SAXException e) {
            this.log.error((Throwable)e);
        }
        return false;
    }

    private boolean isAllowed() {
        try {
            HttpURLConnection connection = this.connect("OPTIONS", new URL(this.baseURL), null, new String[0]);
            connection.connect();
            String allow = connection.getHeaderField("Allow");
            if (allow == null) {
                this.log.error((Object)"Failed to retrieve OPTIONS for WebDAV actions");
                return false;
            }
            if (!allow.contains("LOCK")) {
                this.log.error((Object)("LOCK action not allowed; valid actions: " + allow));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return false;
        }
    }

    private boolean makeDirectory(String path) {
        try {
            HttpURLConnection connection = this.connect("MKCOL", this.getURL(path, true), null, new String[0]);
            connection.connect();
            return connection.getResponseCode() == 201;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return false;
        }
    }

    private URL getURL(String path, boolean isDirectory) throws MalformedURLException, UnsupportedEncodingException {
        String url = this.baseURL + URLEncoder.encode(path, "UTF-8").replaceAll("%2F", "/").replaceAll("\\+", "%20");
        if (!isDirectory || "".equals(path) && path.endsWith("/")) {
            return new URL(url);
        }
        return new URL(url + "/");
    }

    protected void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        if (this.log == null) {
            this.log = new StderrLogService();
            this.log.setLevel(4);
            this.debug = true;
        }
        if (methodField == null) {
            try {
                methodField = HttpURLConnection.class.getDeclaredField("method");
                methodField.setAccessible(true);
            }
            catch (Throwable t) {
                this.log.error(t);
            }
        }
    }

    protected HttpURLConnection connect(String method, URL url, String xml, String ... headers) throws IOException {
        if (headers != null && headers.length % 2 != 0) {
            throw new IOException("Invalid list of header pairs");
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setRequestMethod(connection, method);
        String authentication = this.username + ":" + this.password;
        connection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])authentication.getBytes("UTF-8")));
        if (headers != null) {
            for (int i = 0; i < headers.length; i += 2) {
                connection.setRequestProperty(headers[i], headers[i + 1]);
            }
        }
        if (xml == null) {
            connection.setRequestProperty("Content-Type", "application/octet-stream");
        } else {
            connection.addRequestProperty("Depth", "0");
            connection.addRequestProperty("Brief", "t");
            connection.addRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.connect();
            byte[] xmlBytes = xml.getBytes("UTF-8");
            OutputStream out = this.getOutputStream(connection);
            out.write(xmlBytes);
            out.close();
        }
        if (this.debug) {
            this.log.debug((Object)("Sent request " + connection.getRequestMethod() + " " + connection.getURL()));
            if (!"PUT".equals(connection.getRequestMethod())) {
                this.log.debug((Object)("Response: " + connection.getResponseCode() + " " + connection.getResponseMessage()));
                Map<String, List<String>> map = connection.getHeaderFields();
                for (String key : map.keySet()) {
                    this.log.debug((Object)("Header: " + key + " = " + map.get(key)));
                }
            }
        }
        return connection;
    }

    private OutputStream getOutputStream(HttpURLConnection connection) throws IOException {
        try {
            OutputStream out;
            String savedMethod = this.getRequestMethod(connection);
            this.setRequestMethod(connection, "PUT");
            try {
                out = connection.getOutputStream();
            }
            catch (IOException e) {
                this.setRequestMethod(connection, savedMethod);
                throw e;
            }
            this.setRequestMethod(connection, savedMethod);
            return out;
        }
        catch (IllegalArgumentException e) {
            this.log.error((Throwable)e);
            return null;
        }
    }

    private String getRequestMethod(HttpURLConnection connection) {
        if (methodField == null) {
            return null;
        }
        try {
            return (String)methodField.get(connection);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Throwable)e);
        }
        return null;
    }

    private void setRequestMethod(HttpURLConnection connection, String method) {
        if (methodField == null) {
            return;
        }
        try {
            methodField.set(connection, method);
        }
        catch (IllegalAccessException e) {
            this.log.error((Throwable)e);
        }
    }

    private static class UnauthenticatedException
    extends Exception {
        private static final long serialVersionUID = 8269335582341674291L;

        private UnauthenticatedException() {
        }
    }
}

