/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.Format;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Parser;
import io.scif.Reader;
import io.scif.Writer;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.ReaderFilter;
import io.scif.services.FormatService;
import io.scif.services.InitializeService;
import io.scif.services.LocationService;
import io.scif.services.TranslatorService;
import java.io.IOException;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class, priority=-100.0)
public class DefaultInitializeService
extends AbstractService
implements InitializeService {
    @Parameter
    private PluginService pluginService;
    @Parameter
    private FormatService formatService;
    @Parameter
    private TranslatorService translatorService;
    @Parameter
    private LocationService locationService;

    @Override
    public ReaderFilter initializeReader(String id) throws FormatException, IOException {
        return this.initializeReader(id, new SCIFIOConfig().checkerSetOpen(false));
    }

    @Override
    public ReaderFilter initializeReader(String id, SCIFIOConfig config) throws FormatException, IOException {
        Reader r = this.formatService.getFormat(id, config).createReader();
        r.setSource(id, config);
        return new ReaderFilter(r);
    }

    @Override
    public Writer initializeWriter(String source, String destination) throws FormatException, IOException {
        return this.initializeWriter(source, destination, new SCIFIOConfig().checkerSetOpen(false));
    }

    @Override
    public Writer initializeWriter(String source, String destination, SCIFIOConfig config) throws FormatException, IOException {
        Format sFormat = this.formatService.getFormat(source, config);
        Parser parser = sFormat.createParser();
        Metadata sourceMeta = parser.parse(source, config);
        return this.initializeWriter(sourceMeta, destination, config);
    }

    @Override
    public Writer initializeWriter(Metadata sourceMeta, String destination) throws FormatException, IOException {
        return this.initializeWriter(sourceMeta, destination, new SCIFIOConfig().checkerSetOpen(false));
    }

    @Override
    public Writer initializeWriter(Metadata sourceMeta, String destination, SCIFIOConfig config) throws FormatException, IOException {
        Format sFormat = sourceMeta.getFormat();
        Format dFormat = this.formatService.getWriterByExtension(destination).getFormat();
        Metadata destMeta = dFormat.createMetadata();
        if (sFormat == dFormat) {
            destMeta = this.castMeta(sourceMeta, destMeta.getClass());
        } else {
            destMeta = dFormat.createMetadata();
            this.translatorService.translate(sourceMeta, destMeta, false);
        }
        destMeta.setDatasetName(destination);
        Writer writer = dFormat.createWriter();
        writer.setMetadata(destMeta);
        writer.setDest(destination, config);
        return writer;
    }

    @Override
    public Metadata parseMetadata(String id) throws IOException, FormatException {
        return this.parseMetadata(id, new SCIFIOConfig().checkerSetOpen(false));
    }

    @Override
    public Metadata parseMetadata(String id, SCIFIOConfig config) throws FormatException, IOException {
        Format format = this.formatService.getFormat(id, config);
        return format.createParser().parse(id, config);
    }

    private <N extends Metadata, M extends Metadata> M castMeta(N metadata, Class<M> endType) {
        N meta = metadata;
        return (M)meta;
    }
}

