/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.converters;

import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.img.cell.loaders.ByteAccessLoader;
import io.scif.img.cell.loaders.ByteArrayLoader;
import io.scif.img.cell.loaders.CharAccessLoader;
import io.scif.img.cell.loaders.CharArrayLoader;
import io.scif.img.cell.loaders.DoubleAccessLoader;
import io.scif.img.cell.loaders.DoubleArrayLoader;
import io.scif.img.cell.loaders.FloatAccessLoader;
import io.scif.img.cell.loaders.FloatArrayLoader;
import io.scif.img.cell.loaders.IntAccessLoader;
import io.scif.img.cell.loaders.IntArrayLoader;
import io.scif.img.cell.loaders.LongAccessLoader;
import io.scif.img.cell.loaders.LongArrayLoader;
import io.scif.img.cell.loaders.ShortAccessLoader;
import io.scif.img.cell.loaders.ShortArrayLoader;
import io.scif.img.converters.AbstractPlaneConverter;
import io.scif.img.converters.PlaneConverter;
import net.imagej.ImgPlus;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.CharAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=PlaneConverter.class, name="ArrayDataAccess")
public class ArrayDataAccessConverter
extends AbstractPlaneConverter {
    @Override
    public <T extends RealType<T>> void populatePlane(Reader reader, int imageIndex, int planeIndex, byte[] source, ImgPlus<T> dest, SCIFIOConfig config) {
        ArrayImg arrayImg = (ArrayImg)dest.getImg();
        Object store = arrayImg.update(null);
        if (store instanceof ByteArray) {
            ByteArrayLoader loader = new ByteArrayLoader(reader, config.imgOpenerGetRegion());
            loader.convertBytes((ByteArray)store, source, planeIndex);
        } else if (store instanceof ShortArray) {
            ShortArrayLoader loader = new ShortArrayLoader(reader, config.imgOpenerGetRegion());
            loader.convertBytes((ShortArray)store, source, planeIndex);
        } else if (store instanceof LongArray) {
            LongArrayLoader loader = new LongArrayLoader(reader, config.imgOpenerGetRegion());
            loader.convertBytes((LongArray)store, source, planeIndex);
        } else if (store instanceof CharArray) {
            CharArrayLoader loader = new CharArrayLoader(reader, config.imgOpenerGetRegion());
            loader.convertBytes((CharArray)store, source, planeIndex);
        } else if (store instanceof DoubleArray) {
            DoubleArrayLoader loader = new DoubleArrayLoader(reader, config.imgOpenerGetRegion());
            loader.convertBytes((DoubleArray)store, source, planeIndex);
        } else if (store instanceof FloatArray) {
            FloatArrayLoader loader = new FloatArrayLoader(reader, config.imgOpenerGetRegion());
            loader.convertBytes((FloatArray)store, source, planeIndex);
        } else if (store instanceof IntArray) {
            IntArrayLoader loader = new IntArrayLoader(reader, config.imgOpenerGetRegion());
            loader.convertBytes((IntArray)store, source, planeIndex);
        } else if (store instanceof ByteAccess) {
            ByteAccessLoader loader = new ByteAccessLoader(reader, config.imgOpenerGetRegion(), ByteArray::new);
            loader.convertBytes((ByteAccess)store, source, planeIndex);
        } else if (store instanceof ShortAccess) {
            ShortAccessLoader loader = new ShortAccessLoader(reader, config.imgOpenerGetRegion(), ShortArray::new);
            loader.convertBytes((ShortAccess)store, source, planeIndex);
        } else if (store instanceof LongAccess) {
            LongAccessLoader loader = new LongAccessLoader(reader, config.imgOpenerGetRegion(), LongArray::new);
            loader.convertBytes((LongAccess)store, source, planeIndex);
        } else if (store instanceof CharAccess) {
            CharAccessLoader loader = new CharAccessLoader(reader, config.imgOpenerGetRegion(), CharArray::new);
            loader.convertBytes((CharAccess)store, source, planeIndex);
        } else if (store instanceof DoubleAccess) {
            DoubleAccessLoader loader = new DoubleAccessLoader(reader, config.imgOpenerGetRegion(), DoubleArray::new);
            loader.convertBytes((DoubleAccess)store, source, planeIndex);
        } else if (store instanceof FloatAccess) {
            FloatAccessLoader loader = new FloatAccessLoader(reader, config.imgOpenerGetRegion(), FloatArray::new);
            loader.convertBytes((FloatAccess)store, source, planeIndex);
        } else if (store instanceof IntAccess) {
            IntAccessLoader loader = new IntAccessLoader(reader, config.imgOpenerGetRegion(), IntArray::new);
            loader.convertBytes((IntAccess)store, source, planeIndex);
        }
    }
}

