/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.img.cell.cache.CacheService;
import java.util.Arrays;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.Cell;

public class SCIFIOCell<A extends ArrayDataAccess<A>>
extends Cell<A> {
    private static final long serialVersionUID = 660070520155729477L;
    private transient CacheService<SCIFIOCell<?>> service;
    private transient String cacheId;
    private transient int index;
    private transient boolean[] enabled;
    private int[] hashes;
    private long[] elementSize;

    public SCIFIOCell(CacheService<SCIFIOCell<?>> service, String cacheId, int index, int[] dimensions, long[] min, A data) {
        super(dimensions, min, data);
        this.service = service;
        this.cacheId = cacheId;
        this.index = index;
        this.enabled = new boolean[]{true};
        this.elementSize = new long[]{-1L};
        this.hashes = new int[2];
        this.markClean();
    }

    public SCIFIOCell(SCIFIOCell<A> toCopy) {
        super(toCopy.dimensions, toCopy.min, toCopy.getData());
        this.service = toCopy.service;
        this.cacheId = toCopy.cacheId;
        this.index = toCopy.index;
        this.enabled = toCopy.enabled;
        this.hashes[0] = toCopy.hashes[0];
        this.hashes[1] = toCopy.hashes[1];
        this.elementSize[0] = toCopy.elementSize[0];
    }

    public SCIFIOCell(A data, int currentHash, int cleanHash, long elementSize, int[] dimensions, long[] min) {
        super(dimensions, min, data);
        this.hashes = new int[]{cleanHash, currentHash};
        this.elementSize = new long[]{elementSize};
        this.enabled = new boolean[1];
    }

    public void cacheOnFinalize(boolean e) {
        if (this.enabled == null) {
            this.enabled = new boolean[]{e};
        } else {
            this.enabled[0] = e;
        }
    }

    public void setService(CacheService<SCIFIOCell<?>> service) {
        this.service = service;
    }

    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean[] isEnabled() {
        return this.enabled;
    }

    public void markClean() {
        this.hashes[0] = this.computeHash((ArrayDataAccess)this.getData());
        if (this.hashes[0] == -1) {
            this.hashes[0] = 0;
        }
        this.hashes[1] = this.hashes[0];
    }

    public long getElementSize() {
        return this.elementSize[0];
    }

    public int[] getHashes() {
        return this.hashes;
    }

    public int getCleanHash() {
        return this.hashes[0];
    }

    public int getCurrentHash() {
        return this.hashes[1];
    }

    public long[] getESizeArray() {
        return this.elementSize;
    }

    public int dimCount() {
        return this.n;
    }

    public boolean dirty() {
        return this.hashes[1] != this.hashes[0];
    }

    public void update() {
        this.hashes[1] = this.computeHash((ArrayDataAccess)this.getData());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SCIFIOCell) {
            SCIFIOCell otherCell = (SCIFIOCell)((Object)other);
            return this.cacheId.equals(otherCell.cacheId) && this.index == otherCell.index && this.hashes[1] == otherCell.hashes[1];
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.index;
        result = 31 * result + this.cacheId.hashCode();
        result = 31 * result + ((ArrayDataAccess)this.getData()).hashCode();
        return result;
    }

    private int computeHash(ArrayDataAccess<?> data) {
        int hashCode = -1;
        if (data instanceof ByteArray) {
            byte[] bytes = ((ByteArray)data).getCurrentStorageArray();
            this.computedataSize(8L * (long)bytes.length);
            hashCode = Arrays.hashCode(bytes);
        } else if (data instanceof CharArray) {
            char[] bytes = ((CharArray)data).getCurrentStorageArray();
            this.computedataSize(8L * (long)bytes.length);
            hashCode = Arrays.hashCode(bytes);
        } else if (data instanceof DoubleArray) {
            double[] bytes = ((DoubleArray)data).getCurrentStorageArray();
            this.computedataSize(64L * (long)bytes.length);
            hashCode = Arrays.hashCode(bytes);
        } else if (data instanceof IntArray) {
            int[] bytes = ((IntArray)data).getCurrentStorageArray();
            this.computedataSize(32L * (long)bytes.length);
            hashCode = Arrays.hashCode(bytes);
        } else if (data instanceof FloatArray) {
            float[] bytes = ((FloatArray)data).getCurrentStorageArray();
            this.computedataSize(32L * (long)bytes.length);
            hashCode = Arrays.hashCode(bytes);
        } else if (data instanceof ShortArray) {
            short[] bytes = ((ShortArray)data).getCurrentStorageArray();
            this.computedataSize(16L * (long)bytes.length);
            hashCode = Arrays.hashCode(bytes);
        } else if (data instanceof LongArray) {
            long[] bytes = ((LongArray)data).getCurrentStorageArray();
            this.computedataSize(64L * (long)bytes.length);
            hashCode = Arrays.hashCode(bytes);
        }
        return hashCode;
    }

    private void computedataSize(long bits) {
        this.elementSize[0] = bits / 8L;
    }
}

