/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.img.cell.SCIFIOCell;
import io.scif.refs.CleaningRef;
import io.scif.refs.RefProvider;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import org.scijava.plugin.Plugin;

@Plugin(type=RefProvider.class)
public class RefMapCleaningProvider
extends AbstractSCIFIOPlugin
implements RefProvider {
    @Override
    public boolean handles(Object referent, Object ... params) {
        boolean handles = SCIFIOCell.class.isAssignableFrom(referent.getClass());
        handles = handles && params.length == 2;
        handles = handles && Integer.class.isAssignableFrom(params[0].getClass());
        handles = handles && Map.class.isAssignableFrom(params[1].getClass());
        return handles;
    }

    @Override
    public Reference makeRef(Object referent, ReferenceQueue queue, Object ... params) {
        RefMapCleaner ref = new RefMapCleaner(referent, queue, params);
        return ref;
    }

    public static class RefMapCleaner<A extends ArrayDataAccess<A>>
    extends WeakReference<SCIFIOCell<A>>
    implements CleaningRef {
        private Integer key;
        private Map<Integer, RefMapCleaner<A>> refMap;

        public RefMapCleaner(Object referent, ReferenceQueue q, Object ... params) {
            super((SCIFIOCell)((Object)referent), q);
            if (params.length != 2) {
                throw new IllegalArgumentException("RefMapCleaningRef require 2 parameters: an integer key and a map of integers to CellCacheReferences");
            }
            try {
                this.key = (Integer)params[0];
                this.refMap = (Map)params[1];
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("RefMapCleaningRef - invalid parameters");
            }
        }

        @Override
        public void cleanup() {
            this.refMap.remove(this.key);
        }
    }
}

