/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.qt;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractTranslator;
import io.scif.AbstractWriter;
import io.scif.BufferedImagePlane;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.common.ReflectException;
import io.scif.common.ReflectedUniverse;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.qt.QTJavaService;
import io.scif.gui.AWTImageTools;
import io.scif.gui.BufferedImageReader;
import io.scif.io.Location;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import net.imagej.axis.Axes;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="QuickTime", priority=-100.0)
public class LegacyQTFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"mov"};
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class LegacyQTTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Parameter
        private QTJavaService qtJavaService;
        @Parameter
        private LogService log;

        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        public void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            dest.createImageMetadata(1);
            dest.get(0).setAxisLength(Axes.TIME, source.get(0).getPlaneCount());
            int w = (int)source.get(0).getAxisLength(Axes.X);
            int h = (int)source.get(0).getAxisLength(Axes.Y);
            int bpp = source.get(0).getBitsPerPixel() / 8;
            byte[][] data = new byte[(int)source.get(0).getAxisLength(Axes.CHANNEL)][w * h * bpp];
            boolean fp = FormatTools.isFloatingPoint(source.get(0).getPixelType());
            boolean little = source.get(0).isLittleEndian();
            boolean signed = FormatTools.isSigned(source.get(0).getPixelType());
            BufferedImage img = AWTImageTools.makeImage(data, w, h, bpp, fp, little, signed);
            dest.setImage(img);
        }
    }

    public static class Writer
    extends AbstractWriter<Metadata> {
        private static final int TIME_SCALE = 600;
        @Parameter
        private QTJavaService qtJavaService;
        private ReflectedUniverse r;
        private int codec = 0;
        private int quality = 512;
        private int width;
        private int height;
        private int[] pixels2 = null;

        public void setCodec(int codec) {
            this.codec = codec;
        }

        public void setQuality(int quality) {
            this.quality = quality;
        }

        @Override
        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        @Override
        protected void initialize(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            if (!this.isInitialized(imageIndex, (int)planeIndex)) {
                if (this.r == null) {
                    this.r = this.qtJavaService.getUniverse();
                }
                try {
                    this.r.exec("QTSession.open()");
                    this.width = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.X);
                    this.height = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.Y);
                    this.r.setVar("path", ((Metadata)this.getMetadata()).getDatasetName());
                    this.r.setVar("width", (float)this.width);
                    this.r.setVar("height", (float)this.height);
                    this.r.exec("movFile = new QTFile(path)");
                    this.r.exec("kMoviePlayer = StdQTConstants.kMoviePlayer");
                    int resFlag = (Integer)this.r.exec("StdQTConstants.createMovieFileDontCreateResFile");
                    this.r.setVar("flags", resFlag);
                    this.r.exec("movie = Movie.createMovieFile(movFile, kMoviePlayer, flags)");
                    this.r.setVar("timeScale", 600);
                    this.r.setVar("zero", 0);
                    this.r.setVar("zeroFloat", 0.0f);
                    this.r.exec("videoTrack = movie.addTrack(width, height, zeroFloat)");
                    this.r.exec("videoMedia = new VideoMedia(videoTrack, timeScale)");
                    this.r.exec("videoMedia.beginEdits()");
                    this.r.setVar("width", this.width);
                    this.r.setVar("height", this.height);
                    this.r.exec("bounds = new QDRect(zero, zero, width, height)");
                    this.r.exec("gw = new QDGraphics(bounds)");
                    this.r.exec("pixMap = gw.getPixMap()");
                    this.r.exec("pixSize = pixMap.getPixelSize()");
                    this.r.setVar("codec", this.codec);
                    this.r.setVar("quality", this.quality);
                    int rawImageSize = this.width * this.height * 4;
                    this.r.setVar("rawImageSize", rawImageSize);
                    this.r.setVar("boolTrue", true);
                    this.r.exec("imageHandle = new QTHandle(rawImageSize, boolTrue)");
                    this.r.exec("imageHandle.lock()");
                    this.r.exec("compressedImage = RawEncodedImage.fromQTHandle(imageHandle)");
                    this.r.setVar("rate", 30);
                    this.r.exec("seq = new CSequence(gw, bounds, pixSize, codec, CodecComponent.bestFidelityCodec, quality, quality, rate, null, zero)");
                    this.r.exec("imgDesc = seq.getDescription()");
                }
                catch (ReflectException e) {
                    this.log().debug((Object)"", (Throwable)e);
                    throw new FormatException("Legacy QuickTime writer failed", e);
                }
            }
            super.initialize(imageIndex, planeIndex, planeMin, planeMax);
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            BufferedImage img = null;
            Metadata meta = (Metadata)this.getMetadata();
            if (!(plane instanceof BufferedImagePlane)) {
                int type = meta.get(imageIndex).getPixelType();
                img = AWTImageTools.makeImage(plane.getBytes(), (int)meta.get(imageIndex).getAxisLength(Axes.X), (int)meta.get(imageIndex).getAxisLength(Axes.Y), (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL), meta.get(imageIndex).getInterleavedAxisCount() > 0, FormatTools.getBytesPerPixel(type), FormatTools.isFloatingPoint(type), meta.get(imageIndex).isLittleEndian(), FormatTools.isSigned(type));
            } else {
                img = (BufferedImage)((BufferedImagePlane)plane).getData();
            }
            if (this.r == null) {
                this.r = this.qtJavaService.getUniverse();
            }
            this.qtJavaService.checkQTLibrary();
            try {
                this.r.exec("pixelData = pixMap.getPixelData()");
                this.r.exec("intsPerRow = pixelData.getRowBytes()");
                int intsPerRow = (Integer)this.r.getVar("intsPerRow") / 4;
                byte[][] px = AWTImageTools.getBytes(img);
                int[] pixels = new int[px[0].length];
                for (int i = 0; i < pixels.length; ++i) {
                    int j;
                    byte[] b = new byte[4];
                    for (j = 0; j < px.length; ++j) {
                        b[j] = px[j][i];
                    }
                    for (j = px.length; j < 4; ++j) {
                        b[j] = px[j % px.length][i];
                    }
                    pixels[i] = Bytes.toInt((byte[])b, (boolean)true);
                }
                if (this.pixels2 == null) {
                    this.pixels2 = new int[intsPerRow * this.height];
                }
                this.r.exec("nativeLittle = EndianOrder.isNativeLittleEndian()");
                boolean nativeLittle = (Boolean)this.r.getVar("nativeLittle");
                if (nativeLittle) {
                    for (int row = 0; row < this.height; ++row) {
                        int offset1 = row * this.width;
                        int offset2 = row * intsPerRow;
                        for (int col = 0; col < this.width; ++col) {
                            this.r.setVar("thisByte", pixels[offset1++]);
                            this.r.exec("b = EndianOrder.flipBigEndianToNative32(thisByte)");
                            this.pixels2[offset2++] = (Integer)this.r.getVar("b");
                        }
                    }
                } else {
                    for (int i = 0; i < this.height; ++i) {
                        System.arraycopy(pixels, i * this.width, this.pixels2, i * intsPerRow, this.width);
                    }
                }
                this.r.setVar("pixels2", this.pixels2);
                this.r.setVar("len", intsPerRow * this.height);
                this.r.exec("pixelData.copyFromArray(zero, pixels2, zero, len)");
                this.r.exec("flags = StdQTConstants.codecFlagUpdatePrevious");
                this.r.exec("cfInfo = seq.compressFrame(gw, bounds, flags, compressedImage)");
                this.r.exec("similarity = cfInfo.getSimilarity()");
                int sim = (Integer)this.r.getVar("similarity");
                boolean sync = sim == 0;
                this.r.exec("dataSize = cfInfo.getDataSize()");
                this.r.setVar("fps", this.getFramesPerSecond());
                this.r.setVar("frameRate", 600);
                this.r.setVar("rate", 600 / this.getFramesPerSecond());
                if (sync) {
                    this.r.setVar("sync", 0);
                } else {
                    this.r.exec("sync = StdQTConstants.mediaSampleNotSync");
                }
                this.r.setVar("one", 1);
                this.r.exec("videoMedia.addSample(imageHandle, zero, dataSize, rate, imgDesc, one, sync)");
            }
            catch (ReflectException e) {
                this.log().debug((Object)"", (Throwable)e);
                throw new FormatException("Legacy QuickTime writer failed", e);
            }
            if (planeIndex == ((Metadata)this.getMetadata()).get(imageIndex).getPlaneCount() - 1L) {
                try {
                    this.r.exec("videoMedia.endEdits()");
                    this.r.exec("duration = videoMedia.getDuration()");
                    this.r.setVar("floatOne", 1.0f);
                    this.r.exec("videoTrack.insertMedia(zero, zero, duration, floatOne)");
                    this.r.exec("omf = OpenMovieFile.asWrite(movFile)");
                    this.r.exec("name = movFile.getName()");
                    this.r.exec("flags = StdQTConstants.movieInDataForkResID");
                    this.r.exec("movie.addResource(omf, flags, name)");
                    this.r.exec("QTSession.close()");
                }
                catch (ReflectException e) {
                    this.log().debug((Object)"", (Throwable)e);
                    throw new FormatException("Legacy QuickTime writer failed", e);
                }
                this.close();
            }
        }

        @Override
        public boolean canDoStacks() {
            return true;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.r = null;
            this.width = 0;
            this.height = 0;
            this.pixels2 = null;
        }
    }

    public static class Reader
    extends BufferedImageReader<Metadata> {
        @Parameter
        private QTJavaService qtJavaService;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public BufferedImagePlane openPlane(int imageIndex, long planeIndex, BufferedImagePlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            ReflectedUniverse r = this.qtJavaService.getUniverse();
            Metadata meta = (Metadata)this.getMetadata();
            try {
                r.setVar("time", meta.getTimes()[(int)planeIndex]);
                r.exec("moviePlayer.setTime(time)");
                r.exec("qtip.redraw(null)");
                r.exec("qtip.updateConsumers(null)");
            }
            catch (ReflectException re) {
                throw new FormatException("Open movie failed", re);
            }
            BufferedImage bimg = AWTImageTools.getSubimage(AWTImageTools.makeBuffered(meta.getImage()), meta.get(imageIndex).isLittleEndian(), planeMin, planeMax);
            plane.populate(meta.get(imageIndex), bimg, planeMin, planeMax);
            return plane;
        }

        @Override
        public void close(boolean fileOnly) {
            try {
                ReflectedUniverse r = this.qtJavaService.getUniverse();
                if (r != null && r.getVar("openMovieFile") != null) {
                    r.exec("openMovieFile.close()");
                    if (!fileOnly) {
                        r.exec("m.disposeQTObject()");
                        r.exec("imageTrack.disposeQTObject()");
                        r.exec("QTSession.close()");
                    }
                }
            }
            catch (ReflectException e) {
                this.log().debug((Object)"Failed to close QuickTime session", (Throwable)e);
            }
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Parameter
        private QTJavaService qtJavaService;

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            this.log().info((Object)"Checking for QuickTime Java");
            ReflectedUniverse r = this.qtJavaService.getUniverse();
            this.qtJavaService.checkQTLibrary();
            this.log().info((Object)"Reading movie dimensions");
            try {
                Integer w;
                r.exec("QTSession.open()");
                Location file = new Location(this.getContext(), stream.getFileName());
                r.setVar("path", file.getAbsolutePath());
                r.exec("qtf = new QTFile(path)");
                r.exec("openMovieFile = OpenMovieFile.asRead(qtf)");
                r.exec("m = Movie.fromFile(openMovieFile)");
                int numTracks = (Integer)r.exec("m.getTrackCount()");
                int trackMostLikely = 0;
                int trackNum = 0;
                while (++trackNum <= numTracks && trackMostLikely == 0) {
                    r.setVar("trackNum", trackNum);
                    r.exec("imageTrack = m.getTrack(trackNum)");
                    r.exec("d = imageTrack.getSize()");
                    w = (Integer)r.exec("d.getWidth()");
                    if (w <= 0) continue;
                    trackMostLikely = trackNum;
                }
                r.setVar("trackMostLikely", trackMostLikely);
                r.exec("imageTrack = m.getTrack(trackMostLikely)");
                r.exec("d = imageTrack.getSize()");
                w = (Integer)r.exec("d.getWidth()");
                Integer h = (Integer)r.exec("d.getHeight()");
                r.exec("moviePlayer = new MoviePlayer(m)");
                r.setVar("dim", new Dimension(w, h));
                ImageProducer qtip = (ImageProducer)r.exec("qtip = new QTImageProducer(moviePlayer, dim)");
                meta.setImage(Toolkit.getDefaultToolkit().createImage(qtip));
                r.setVar("zero", 0);
                r.setVar("one", 1.0f);
                r.exec("timeInfo = new TimeInfo(zero, zero)");
                r.exec("moviePlayer.setTime(zero)");
                Vector<Integer> v = new Vector<Integer>();
                int time = 0;
                Integer q = new Integer(time);
                do {
                    v.add(q);
                    r.exec("timeInfo = imageTrack.getNextInterestingTime(StdQTConstants.nextTimeMediaSample, timeInfo.time, one)");
                } while ((time = (q = (Integer)r.getVar("timeInfo.time")).intValue()) >= 0);
                meta.createImageMetadata(1);
                ImageMetadata iMeta = meta.get(0);
                iMeta.setAxisLength(Axes.TIME, (long)v.size());
                int[] times = new int[(int)iMeta.getPlaneCount()];
                for (int i = 0; i < times.length; ++i) {
                    q = (Integer)v.elementAt(i);
                    times[i] = q;
                }
                meta.setTimes(times);
            }
            catch (ReflectException e) {
                throw new FormatException("Open movie failed", e);
            }
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        @Parameter
        private QTJavaService qtJavaService;
        private int[] times;
        private Image image;

        public int[] getTimes() {
            return this.times;
        }

        public void setTimes(int[] times) {
            this.times = times;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        public void populateImageMetadata() {
            BufferedImage img = AWTImageTools.makeBuffered(this.image);
            ImageMetadata iMeta = this.get(0);
            iMeta.setAxisTypes(Axes.X, Axes.Y, Axes.CHANNEL, Axes.TIME);
            iMeta.setAxisLength(Axes.X, (long)img.getWidth());
            iMeta.setAxisLength(Axes.Y, (long)img.getHeight());
            iMeta.setAxisLength(Axes.CHANNEL, (long)img.getRaster().getNumBands());
            iMeta.setAxisLength(Axes.TIME, iMeta.getPlaneCount());
            iMeta.setPixelType(AWTImageTools.getPixelType(img));
            iMeta.setLittleEndian(false);
            iMeta.setIndexed(false);
            iMeta.setFalseColor(false);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.times = null;
                this.image = null;
            }
        }
    }
}

