/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.io.IRandomAccess;
import io.scif.io.RandomAccessInputStream;
import io.scif.services.LocationService;
import io.scif.util.FormatTools;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imagej.axis.Axes;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="Text")
public class TextFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"txt", "csv"};
    }

    private static class TextUtils {
        private static final String LABEL_X = "x";
        private static final String LABEL_Y = "y";
        private static final boolean LITTLE_ENDIAN = false;

        private TextUtils() {
        }

        private static int parseFileHeader(List<String> lines, Metadata meta, LogService log) throws FormatException {
            String[] lastTokens = null;
            double[] rowData = null;
            while (true) {
                String[] tokens;
                if ((tokens = TextUtils.getNextLine(lines, meta)) == null) {
                    throw new FormatException("No tabular data found");
                }
                if (tokens.length >= 3 && lastTokens != null && lastTokens.length == tokens.length) {
                    if (rowData == null || rowData.length != tokens.length) {
                        rowData = new double[tokens.length];
                    }
                    if (TextUtils.getRowData(tokens, rowData)) break;
                }
                lastTokens = tokens;
            }
            log.info((Object)("Found header on line " + (meta.getRow() - 1)));
            TextUtils.parseHeaderRow(lastTokens, meta);
            int headerRows = meta.getRow() - 1;
            if (meta.getxIndex() < 0) {
                throw new FormatException("No X coordinate column found");
            }
            if (meta.getyIndex() < 0) {
                throw new FormatException("No Y coordinate column found");
            }
            boolean checkRow = true;
            while (true) {
                String[] tokens;
                if (checkRow) {
                    int y;
                    int x = TextUtils.getX(rowData, meta);
                    if (x < 0) {
                        throw new FormatException("Row #" + meta.getRow() + ": invalid X: " + x);
                    }
                    if (meta.get(0).getAxisLength(Axes.X) <= (long)x) {
                        meta.get(0).setAxisLength(Axes.X, (long)(x + 1));
                    }
                    if ((y = TextUtils.getY(rowData, meta)) < 0) {
                        throw new FormatException("Row #" + meta.getRow() + ": invalid Y: " + x);
                    }
                    if (meta.get(0).getAxisLength(Axes.Y) <= (long)y) {
                        meta.get(0).setAxisLength(Axes.Y, (long)(y + 1));
                    }
                }
                if ((tokens = TextUtils.getNextLine(lines, meta)) == null) break;
                checkRow = TextUtils.getRowData(tokens, rowData);
            }
            return headerRows;
        }

        private static boolean getRowData(String[] tokens, double[] rowData) {
            try {
                for (int i = 0; i < tokens.length; ++i) {
                    rowData[i] = Double.parseDouble(tokens[i]);
                }
                return true;
            }
            catch (NumberFormatException exc) {
                return false;
            }
        }

        private static void parseHeaderRow(String[] tokens, Metadata meta) {
            meta.setRowLength(tokens.length);
            ArrayList<String> channelsList = new ArrayList<String>();
            for (int i = 0; i < meta.getRowLength(); ++i) {
                String token = tokens[i];
                if (token.equals(LABEL_X)) {
                    meta.setxIndex(i);
                    continue;
                }
                if (token.equals(LABEL_Y)) {
                    meta.setyIndex(i);
                    continue;
                }
                channelsList.add(token);
            }
            meta.setChannels(channelsList.toArray(new String[0]));
        }

        private static String[] getNextLine(List<String> lines, Metadata meta) {
            String line;
            do {
                if (meta.getRow() >= lines.size()) {
                    return null;
                }
                line = lines.get(meta.getRow());
                meta.setRow(meta.getRow() + 1);
                line = line.trim();
            } while (line.equals(""));
            return line.split("[\\s,]");
        }

        private static int getX(double[] rowData, Metadata meta) {
            return (int)rowData[meta.getxIndex()];
        }

        private static int getY(double[] rowData, Metadata meta) {
            return (int)rowData[meta.getyIndex()];
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Unknown"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            byte[] buf = (byte[])plane.getData();
            Metadata meta = (Metadata)this.getMetadata();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            float[] planeFloats = ((Metadata)this.getMetadata()).getData()[(int)planeIndex];
            int q = 0;
            for (int j = 0; j < h; ++j) {
                int yy = y + j;
                for (int i = 0; i < w; ++i) {
                    int xx = x + i;
                    int index = yy * (int)meta.get(0).getAxisLength(Axes.X) + xx;
                    int bits = Float.floatToIntBits(planeFloats[index]);
                    Bytes.unpack((long)bits, (byte[])buf, (int)q, (int)4, (boolean)false);
                    q += 4;
                }
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private static final long TIME_OFFSET = 2000L;
        @Parameter
        private LocationService locationService;

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            this.log().info((Object)"Reading file");
            List<String> lines = this.readFile(stream.getFileName());
            this.log().info((Object)"Parsing file header");
            int headerRows = TextUtils.parseFileHeader(lines, meta, this.log());
            boolean sizeZ = true;
            boolean sizeT = true;
            int sizeC = meta.getChannels().length;
            int planeCount = 1 * sizeC * 1;
            int planeSize = (int)iMeta.getAxisLength(Axes.X) * (int)iMeta.getAxisLength(Axes.Y);
            float[][] data = new float[planeCount][planeSize];
            iMeta.setAxisLength(Axes.Z, 1L);
            iMeta.setAxisLength(Axes.CHANNEL, (long)sizeC);
            iMeta.setAxisLength(Axes.TIME, 1L);
            meta.setData(data);
            for (int i = 0; i < planeCount; ++i) {
                Arrays.fill(data[i], Float.NaN);
            }
            this.parseTableData(lines, headerRows, meta);
        }

        private void parseTableData(List<String> lines, int linesToSkip, Metadata meta) {
            String[] tokens;
            meta.setRow(linesToSkip);
            double[] rowData = new double[meta.getRowLength()];
            while ((tokens = TextUtils.getNextLine(lines, meta)) != null) {
                if (tokens.length != meta.getRowLength()) {
                    this.log().warn((Object)("Ignoring deviant row #" + meta.getRow()));
                    continue;
                }
                boolean success = TextUtils.getRowData(tokens, rowData);
                if (!success) {
                    this.log().warn((Object)("Ignoring non-numeric row #" + meta.getRow()));
                    continue;
                }
                this.assignValues(rowData, meta);
            }
        }

        private void assignValues(double[] rowData, Metadata meta) {
            int x = TextUtils.getX(rowData, meta);
            int y = TextUtils.getY(rowData, meta);
            int c = 0;
            int index = (int)meta.get(0).getAxisLength(Axes.X) * y + x;
            for (int i = 0; i < meta.getRowLength(); ++i) {
                if (i == meta.getxIndex() || i == meta.getyIndex()) continue;
                meta.getData()[c++][index] = (float)rowData[i];
            }
        }

        private List<String> readFile(String id) throws IOException {
            ArrayList<String> lines = new ArrayList<String>();
            long time = System.currentTimeMillis();
            IRandomAccess handle = this.locationService.getMappedFile(id);
            if (handle == null) {
                String mapId = this.locationService.getMappedId(id);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mapId), "UTF-8"));
                int no = 0;
                while (true) {
                    time = this.checkTime(time, ++no, 0L, 0L);
                    String line = in.readLine();
                    if (line == null) break;
                    lines.add(line);
                }
                in.close();
            } else {
                RandomAccessInputStream in = new RandomAccessInputStream(this.getContext(), handle);
                int no = 0;
                while (true) {
                    time = this.checkTime(time, ++no, in.getFilePointer(), in.length());
                    String line = in.readLine();
                    if (line == null) break;
                    lines.add(line);
                }
                in.close();
            }
            return lines;
        }

        private long checkTime(long time, int no, long pos, long len) {
            long t = System.currentTimeMillis();
            if (t - time > 2000L) {
                if (len > 0L) {
                    int percent = (int)(100L * pos / len);
                    this.log().info((Object)("Reading line " + no + " (" + percent + "%)"));
                } else {
                    this.log().info((Object)("Reading line " + no));
                }
                time = t;
            }
            return time;
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            int blockLen = 8192;
            if (!FormatTools.validStream(stream, 8192, false)) {
                return false;
            }
            String data = stream.readString(8192);
            List<String> lines = Arrays.asList(data.split("\n"));
            Metadata meta = null;
            try {
                meta = (Metadata)this.getFormat().createMetadata();
            }
            catch (FormatException e) {
                this.log().error((Object)"Failed to create TextMetadata", (Throwable)e);
                return false;
            }
            meta.createImageMetadata(1);
            meta.setRow(0);
            String[] line = TextUtils.getNextLine(lines, meta);
            if (line == null) {
                return false;
            }
            int headerRows = 0;
            try {
                headerRows = TextUtils.parseFileHeader(lines, meta, this.log());
            }
            catch (FormatException formatException) {
                // empty catch block
            }
            return headerRows > 0;
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private float[][] data;
        private int row;
        private int rowLength;
        private int xIndex = -1;
        private int yIndex = -1;
        private String[] channels;
        private int sizeX;
        private int sizeY;

        public float[][] getData() {
            return this.data;
        }

        public void setData(float[][] data) {
            this.data = data;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getRowLength() {
            return this.rowLength;
        }

        public void setRowLength(int rowLength) {
            this.rowLength = rowLength;
        }

        public int getxIndex() {
            return this.xIndex;
        }

        public void setxIndex(int xIndex) {
            this.xIndex = xIndex;
        }

        public int getyIndex() {
            return this.yIndex;
        }

        public void setyIndex(int yIndex) {
            this.yIndex = yIndex;
        }

        public String[] getChannels() {
            return this.channels;
        }

        public void setChannels(String[] channels) {
            this.channels = channels;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public void setSizeX(int sizeX) {
            this.sizeX = sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public void setSizeY(int sizeY) {
            this.sizeY = sizeY;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            iMeta.setPlanarAxisCount(2);
            iMeta.setPixelType(6);
            iMeta.setBitsPerPixel(32);
            iMeta.setOrderCertain(true);
            iMeta.setLittleEndian(false);
            iMeta.setMetadataComplete(true);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.data = null;
                this.rowLength = 0;
                this.yIndex = -1;
                this.xIndex = -1;
                this.channels = null;
                this.sizeY = 0;
                this.sizeX = 0;
                this.row = 0;
            }
        }
    }
}

