/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.DefaultTranslator;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Translator;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.MinimalTIFFFormat;
import io.scif.io.Location;
import io.scif.io.RandomAccessInputStream;
import io.scif.services.FormatService;
import io.scif.services.TranslatorService;
import io.scif.util.FormatTools;
import io.scif.xml.BaseHandler;
import io.scif.xml.XMLService;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import net.imagej.axis.Axes;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.DigestUtils;
import org.scijava.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@Plugin(type=Format.class, name="Micro-Manager")
public class MicromanagerFormat
extends AbstractFormat {
    private static final String METADATA = "metadata.txt";
    private static final String XML = "Acqusition.xml";

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"tif", "tiff", "txt", "xml"};
    }

    private static class Index {
        public int z;
        public int c;
        public int t;

        public Index(int[] zct) {
            this.z = zct[0];
            this.c = zct[1];
            this.t = zct[2];
        }
    }

    public static class Position {
        public String baseTiff;
        public Vector<String> tiffs;
        public HashMap<Index, String> fileNameMap = new HashMap();
        public String metadataFile;
        public String xmlFile;
        public String[] channels;
        public String comment;
        public String time;
        public Double exposureTime;
        public Double sliceThickness;
        public Double pixelSize;
        public Double[] timestamps;
        public int gain;
        public String binning;
        public String detectorID;
        public String detectorModel;
        public String detectorManufacturer;
        public double temperature;
        public Vector<Double> voltage;
        public String cameraRef;
        public String cameraMode;

        public String getFile(Metadata meta, int imageIndex, long planeIndex) {
            long[] zct = FormatTools.rasterToPosition(imageIndex, planeIndex, meta);
            for (Index key : this.fileNameMap.keySet()) {
                if ((long)key.z != zct[0] || (long)key.c != zct[1] || (long)key.t != zct[2]) continue;
                String file = this.fileNameMap.get(key);
                if (this.tiffs == null) continue;
                for (String tiff : this.tiffs) {
                    if (!tiff.endsWith(File.separator + file)) continue;
                    return tiff;
                }
            }
            return this.fileNameMap.size() == 0 ? this.tiffs.get((int)planeIndex) : null;
        }
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class MicromanagerTranslator
    extends DefaultTranslator {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Parameter
        private FormatService formatService;
        private MinimalTIFFFormat.Reader<?> tiffReader;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Light Microscopy"};
        }

        @Override
        public void setMetadata(Metadata meta) throws IOException {
            this.tiffReader = null;
            super.setMetadata(meta);
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            byte[] buf = plane.getBytes();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            String file = meta.getPositions().get(imageIndex).getFile(meta, imageIndex, planeIndex);
            if (file != null && new Location(this.getContext(), file).exists()) {
                this.tiffReader.setSource(file, config);
                return this.tiffReader.openPlane(imageIndex, 0L, plane, planeMin, planeMax);
            }
            this.log().warn((Object)("File for image #" + planeIndex + " (" + file + ") is missing."));
            return plane;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (this.tiffReader != null) {
                this.tiffReader.close(fileOnly);
            }
        }

        @Override
        public long getOptimalTileWidth(int imageIndex) {
            if (this.tiffReader == null || this.tiffReader.getCurrentFile() == null) {
                this.setupReader(imageIndex);
            }
            return this.tiffReader.getOptimalTileWidth(imageIndex);
        }

        @Override
        public long getOptimalTileHeight(int imageIndex) {
            if (this.tiffReader == null || this.tiffReader.getCurrentFile() == null) {
                this.setupReader(imageIndex);
            }
            return this.tiffReader.getOptimalTileHeight(imageIndex);
        }

        @Override
        public boolean hasCompanionFiles() {
            return true;
        }

        private void setupReader(int imageIndex) {
            try {
                String file = ((Metadata)this.getMetadata()).getPositions().get(imageIndex).getFile((Metadata)this.getMetadata(), imageIndex, 0L);
                if (this.tiffReader == null) {
                    this.tiffReader = (MinimalTIFFFormat.Reader)this.formatService.getFormatFromClass(MinimalTIFFFormat.class).createReader();
                }
                this.tiffReader.setSource(file);
            }
            catch (Exception e) {
                this.log().debug((Object)"", (Throwable)e);
            }
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        public static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
        @Parameter
        private TranslatorService translatorService;
        @Parameter
        private XMLService xmlService;

        public void populateMetadata(String[] jsonData, Metadata source, io.scif.Metadata dest) throws FormatException, IOException {
            source.createImageMetadata(jsonData.length);
            Vector<Position> positions = new Vector<Position>();
            for (int pos = 0; pos < jsonData.length; ++pos) {
                Position p = new Position();
                p.metadataFile = "Position #" + (pos + 1);
                positions.add(p);
                this.parsePosition(jsonData[pos], source, pos);
            }
            this.translatorService.translate(source, dest, true);
        }

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            Vector<Position> positions = new Vector<Position>();
            meta.setPositions(positions);
            this.log().info((Object)"Reading metadata file");
            Location file = new Location(this.getContext(), stream.getFileName()).getAbsoluteFile();
            Location parentFile = file.getParentFile();
            String metadataFile = MicromanagerFormat.METADATA;
            if (!file.exists()) {
                throw new IllegalStateException("MicromanagerFormat: No companion metadata file");
            }
            metadataFile = new Location(this.getContext(), parentFile, MicromanagerFormat.METADATA).getAbsolutePath();
            if (parentFile.getName().contains("Pos_")) {
                parentFile = parentFile.getParentFile();
                Object[] dirs = parentFile.list(true);
                Arrays.sort(dirs);
                for (Object dir : dirs) {
                    if (!((String)dir).contains("Pos_")) continue;
                    Position pos = new Position();
                    Location posDir = new Location(this.getContext(), parentFile, (String)dir);
                    pos.metadataFile = new Location(this.getContext(), posDir, MicromanagerFormat.METADATA).getAbsolutePath();
                    positions.add(pos);
                }
            } else {
                Position pos = new Position();
                pos.metadataFile = metadataFile;
                positions.add(pos);
            }
            int imageCount = positions.size();
            meta.createImageMetadata(imageCount);
            for (int i = 0; i < imageCount; ++i) {
                this.parsePosition(meta, i);
            }
        }

        @Override
        public String[] getImageUsedFiles(int imageIndex, boolean noPixels) {
            FormatTools.assertId(this.getSource(), true, 1);
            Vector<String> files = new Vector<String>();
            for (Position pos : ((Metadata)this.getMetadata()).getPositions()) {
                files.add(pos.metadataFile);
                if (pos.xmlFile != null) {
                    files.add(pos.xmlFile);
                }
                if (noPixels) continue;
                for (String tiff : pos.tiffs) {
                    if (!new Location(this.getContext(), tiff).exists()) continue;
                    files.add(tiff);
                }
            }
            return files.toArray(new String[files.size()]);
        }

        @Override
        public boolean isSingleFile(String id) {
            return false;
        }

        @Override
        public int fileGroupOption(String id) {
            return 0;
        }

        @Override
        public boolean hasCompanionFiles() {
            return true;
        }

        private void parsePosition(Metadata meta, int posIndex) throws IOException, FormatException {
            Position p = meta.getPositions().get(posIndex);
            byte[] bytes = FileUtils.readFile((File)new File(p.metadataFile));
            String s = DigestUtils.string((byte[])bytes);
            this.parsePosition(s, meta, posIndex);
            this.buildTIFFList(meta, posIndex);
        }

        private void buildTIFFList(Metadata meta, int posIndex) throws FormatException {
            Position p = meta.getPositions().get(posIndex);
            ImageMetadata ms = meta.get(posIndex);
            String parent = new Location(this.getContext(), p.metadataFile).getParent();
            this.log().info((Object)"Finding image file names");
            p.tiffs = new Vector();
            this.buildTIFFList(meta, posIndex, parent + File.separator + p.baseTiff);
            if (p.tiffs.size() == 0) {
                Vector<String> uniqueZ = new Vector<String>();
                Vector<String> uniqueC = new Vector<String>();
                Vector<String> uniqueT = new Vector<String>();
                Location dir = new Location(this.getContext(), p.metadataFile).getAbsoluteFile().getParentFile();
                Object[] files = dir.list(true);
                Arrays.sort(files);
                for (Object f : files) {
                    if (!FormatTools.checkSuffix((String)f, "tif") && !FormatTools.checkSuffix((String)f, "tiff")) continue;
                    String[] blocks = ((String)f).split("_");
                    if (!uniqueT.contains(blocks[1])) {
                        uniqueT.add(blocks[1]);
                    }
                    if (!uniqueC.contains(blocks[2])) {
                        uniqueC.add(blocks[2]);
                    }
                    if (!uniqueZ.contains(blocks[3])) {
                        uniqueZ.add(blocks[3]);
                    }
                    p.tiffs.add(new Location(this.getContext(), dir, (String)f).getAbsolutePath());
                }
                ms.setAxisLength(Axes.Z, (long)uniqueZ.size());
                ms.setAxisLength(Axes.CHANNEL, (long)uniqueC.size());
                ms.setAxisLength(Axes.TIME, (long)uniqueT.size());
                if (p.tiffs.size() == 0) {
                    throw new FormatException("Could not find TIFF files.");
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parsePosition(String jsonData, Metadata meta, int posIndex) throws IOException, FormatException {
            Position p = meta.getPositions().get(posIndex);
            ImageMetadata ms = meta.get(posIndex);
            String parent = new Location(this.getContext(), p.metadataFile).getParent();
            this.log().info((Object)"Populating metadata");
            Vector<Double> stamps = new Vector<Double>();
            p.voltage = new Vector();
            StringTokenizer st = new StringTokenizer(jsonData, "\n");
            int[] slice = new int[3];
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                boolean open = token.contains("[");
                boolean closed = token.contains("]");
                if (open || !open && !closed && !token.equals("{") && !token.startsWith("}")) {
                    int quote = token.indexOf("\"") + 1;
                    String key = token.substring(quote, token.indexOf("\"", quote));
                    String value = null;
                    if (open == closed) {
                        value = token.substring(token.indexOf(":") + 1);
                    } else if (!closed) {
                        StringBuilder valueBuffer = new StringBuilder();
                        while (!closed) {
                            token = st.nextToken();
                            closed = token.contains("]");
                            valueBuffer.append(token);
                        }
                        value = valueBuffer.toString();
                        value = value.replaceAll("\n", "");
                    }
                    if (value == null) continue;
                    int startIndex = value.indexOf("[");
                    int endIndex = value.indexOf("]");
                    if (endIndex == -1) {
                        endIndex = value.length();
                    }
                    if ((value = value.substring(startIndex + 1, endIndex).trim()).length() == 0) continue;
                    value = value.substring(0, value.length() - 1);
                    if ((value = value.replaceAll("\"", "")).endsWith(",")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    meta.getTable().put(key, value);
                    if (key.equals("Channels")) {
                        ms.setAxisLength(Axes.CHANNEL, (long)Integer.parseInt(value));
                    } else if (key.equals("ChNames")) {
                        p.channels = value.split(",");
                        for (int q = 0; q < p.channels.length; ++q) {
                            p.channels[q] = p.channels[q].replaceAll("\"", "").trim();
                        }
                    } else if (key.equals("Frames")) {
                        ms.setAxisLength(Axes.TIME, (long)Integer.parseInt(value));
                    } else if (key.equals("Slices")) {
                        ms.setAxisLength(Axes.Z, (long)Integer.parseInt(value));
                    } else if (key.equals("PixelSize_um")) {
                        p.pixelSize = new Double(value);
                    } else if (key.equals("z-step_um")) {
                        p.sliceThickness = new Double(value);
                    } else if (key.equals("Time")) {
                        p.time = value;
                    } else if (key.equals("Comment")) {
                        p.comment = value;
                    } else if (key.equals("FileName")) {
                        p.fileNameMap.put(new Index(slice), value);
                        if (p.baseTiff == null) {
                            p.baseTiff = value;
                        }
                    } else if (key.equals("Width")) {
                        ms.setAxisLength(Axes.X, (long)Integer.parseInt(value));
                    } else if (key.equals("Height")) {
                        ms.setAxisLength(Axes.Y, (long)Integer.parseInt(value));
                    } else if (key.equals("IJType")) {
                        int type = Integer.parseInt(value);
                        switch (type) {
                            case 0: {
                                ms.setPixelType(1);
                                break;
                            }
                            case 1: {
                                ms.setPixelType(3);
                                break;
                            }
                            default: {
                                throw new FormatException("Unknown type: " + type);
                            }
                        }
                    }
                }
                if (!token.startsWith("\"FrameKey")) continue;
                int dash = token.indexOf("-") + 1;
                int nextDash = token.indexOf("-", dash);
                slice[2] = Integer.parseInt(token.substring(dash, nextDash));
                dash = nextDash + 1;
                nextDash = token.indexOf("-", dash);
                slice[1] = Integer.parseInt(token.substring(dash, nextDash));
                dash = nextDash + 1;
                slice[0] = Integer.parseInt(token.substring(dash, token.indexOf("\"", dash)));
                token = st.nextToken().trim();
                String key = "";
                String value = "";
                boolean valueArray = false;
                int nestedCount = 0;
                while (!token.startsWith("}") || nestedCount > 0) {
                    block69: {
                        if (token.trim().endsWith("{")) {
                            ++nestedCount;
                            token = st.nextToken().trim();
                            continue;
                        }
                        if (token.trim().startsWith("}")) {
                            --nestedCount;
                            token = st.nextToken().trim();
                            continue;
                        }
                        if (valueArray) {
                            if (token.trim().equals("],")) {
                                valueArray = false;
                                break block69;
                            } else {
                                value = value + token.trim().replaceAll("\"", "");
                                token = st.nextToken().trim();
                                continue;
                            }
                        }
                        int colon = token.indexOf(":");
                        key = token.substring(1, colon).trim();
                        value = token.substring(colon + 1, token.length() - 1).trim();
                        key = key.replaceAll("\"", "");
                        value = value.replaceAll("\"", "");
                        if (token.trim().endsWith("[")) {
                            valueArray = true;
                            token = st.nextToken().trim();
                            continue;
                        }
                    }
                    meta.getTable().put(key, value);
                    if (key.equals("Exposure-ms")) {
                        double t = Double.parseDouble(value);
                        p.exposureTime = new Double(t / 1000.0);
                    } else if (key.equals("ElapsedTime-ms")) {
                        double t = Double.parseDouble(value);
                        stamps.add(new Double(t / 1000.0));
                    } else if (key.equals("Core-Camera")) {
                        p.cameraRef = value;
                    } else if (key.equals(p.cameraRef + "-Binning")) {
                        p.binning = value.contains("x") ? value : value + "x" + value;
                    } else if (key.equals(p.cameraRef + "-CameraID")) {
                        p.detectorID = value;
                    } else if (key.equals(p.cameraRef + "-CameraName")) {
                        p.detectorModel = value;
                    } else if (key.equals(p.cameraRef + "-Gain")) {
                        p.gain = (int)Double.parseDouble(value);
                    } else if (key.equals(p.cameraRef + "-Name")) {
                        p.detectorManufacturer = value;
                    } else if (key.equals(p.cameraRef + "-Temperature")) {
                        p.temperature = Double.parseDouble(value);
                    } else if (key.equals(p.cameraRef + "-CCDMode")) {
                        p.cameraMode = value;
                    } else if (key.startsWith("DAC-") && key.endsWith("-Volts")) {
                        p.voltage.add(new Double(value));
                    } else if (key.equals("FileName")) {
                        p.fileNameMap.put(new Index(slice), value);
                        if (p.baseTiff == null) {
                            p.baseTiff = value;
                        }
                    }
                    token = st.nextToken().trim();
                }
            }
            p.timestamps = stamps.toArray(new Double[stamps.size()]);
            Arrays.sort((Object[])p.timestamps);
            if (new Location(this.getContext(), parent, MicromanagerFormat.XML).exists()) {
                p.xmlFile = new Location(this.getContext(), parent, MicromanagerFormat.XML).getAbsolutePath();
                this.parseXMLFile(meta, posIndex);
            }
        }

        private void buildTIFFList(Metadata meta, int posIndex, String baseTiff) {
            this.log().info((Object)"Building list of TIFFs");
            Position p = meta.getPositions().get(posIndex);
            String prefix = "";
            if (baseTiff.contains(File.separator)) {
                prefix = baseTiff.substring(0, baseTiff.lastIndexOf(File.separator) + 1);
                baseTiff = baseTiff.substring(baseTiff.lastIndexOf(File.separator) + 1);
            }
            String[] blocks = baseTiff.split("_");
            StringBuilder filename = new StringBuilder();
            int t = 0;
            while ((long)t < meta.get(posIndex).getAxisLength(Axes.TIME)) {
                int c = 0;
                while ((long)c < meta.get(posIndex).getAxisLength(Axes.CHANNEL)) {
                    int z = 0;
                    while ((long)z < meta.get(posIndex).getAxisLength(Axes.Z)) {
                        filename.append(prefix);
                        if (!prefix.endsWith(File.separator) && !blocks[0].startsWith(File.separator)) {
                            filename.append(File.separator);
                        }
                        filename.append(blocks[0]);
                        filename.append("_");
                        int zeros = blocks[1].length() - String.valueOf(t).length();
                        for (int q = 0; q < zeros; ++q) {
                            filename.append("0");
                        }
                        filename.append(t);
                        filename.append("_");
                        String channel = p.channels[c];
                        if (channel.contains("-")) {
                            channel = channel.substring(0, channel.indexOf("-"));
                        }
                        filename.append(channel);
                        filename.append("_");
                        zeros = blocks[3].length() - String.valueOf(z).length() - 4;
                        for (int q = 0; q < zeros; ++q) {
                            filename.append("0");
                        }
                        filename.append(z);
                        filename.append(".tif");
                        p.tiffs.add(filename.toString());
                        filename.delete(0, filename.length());
                        ++z;
                    }
                    ++c;
                }
                ++t;
            }
        }

        private void parseXMLFile(Metadata meta, int imageIndex) throws IOException {
            Position p = meta.getPositions().get(imageIndex);
            byte[] bytes = FileUtils.readFile((File)new File(p.xmlFile));
            String xmlData = DigestUtils.string((byte[])bytes);
            xmlData = this.xmlService.sanitizeXML(xmlData);
            MicromanagerHandler handler = new MicromanagerHandler();
            this.xmlService.parseXML(xmlData, (DefaultHandler)handler);
        }

        private class MicromanagerHandler
        extends BaseHandler {
            public MicromanagerHandler() {
                super(Parser.this.log());
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if (qName.equals("entry")) {
                    String key = attributes.getValue("key");
                    String value = attributes.getValue("value");
                    ((Metadata)Parser.this.getMetadata()).getTable().put(key, value);
                }
            }
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Parameter
        private FormatService formatService;

        @Override
        public boolean isFormat(String name, SCIFIOConfig config) {
            if (!config.checkerIsOpen()) {
                return false;
            }
            if (name.equals(MicromanagerFormat.METADATA) || name.endsWith(File.separator + MicromanagerFormat.METADATA) || name.equals(MicromanagerFormat.XML) || name.endsWith(File.separator + MicromanagerFormat.XML)) {
                int blockSize = 0x100000;
                try {
                    RandomAccessInputStream stream = new RandomAccessInputStream(this.getContext(), name);
                    long length = stream.length();
                    String data = stream.readString((int)Math.min(0x100000L, length));
                    stream.close();
                    return length > 0L && (data.contains("Micro-Manager") || data.contains("micromanager"));
                }
                catch (IOException e) {
                    return false;
                }
            }
            try {
                Location parent = new Location(this.getContext(), name).getAbsoluteFile().getParentFile();
                Location metaFile = new Location(this.getContext(), parent, MicromanagerFormat.METADATA);
                RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), name);
                boolean validTIFF = this.isFormat(s);
                try {
                    io.scif.Checker checker = this.formatService.getFormatFromClass(MinimalTIFFFormat.class).createChecker();
                    validTIFF = checker.isFormat(s);
                }
                catch (FormatException e) {
                    this.log().error((Object)"Failed to create a MinimalTIFFChecker", (Throwable)e);
                    validTIFF = false;
                }
                s.close();
                return validTIFF && metaFile.exists() && this.isFormat(metaFile.getAbsolutePath(), config);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            return false;
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private Vector<Position> positions;

        public Vector<Position> getPositions() {
            return this.positions;
        }

        public void setPositions(Vector<Position> positions) {
            this.positions = positions;
        }

        @Override
        public void populateImageMetadata() {
            for (int i = 0; i < this.getImageCount(); ++i) {
                ImageMetadata ms = this.get(i);
                ms.setAxisTypes(Axes.X, Axes.Y, Axes.Z, Axes.CHANNEL, Axes.TIME);
                ms.setPlanarAxisCount(2);
                ms.setLittleEndian(false);
                ms.setIndexed(false);
                ms.setFalseColor(false);
                ms.setMetadataComplete(true);
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.positions = null;
            }
        }
    }
}

