/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Field;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Kontron")
public class KontronFormat
extends AbstractFormat {
    public static final byte[] KONTRON_ID = new byte[]{1, 0, 71, 18, 109, -80};
    public static final int HEADER_BYTES = 128;

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"img"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Scanning Electron Microscopy (SEM)"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            RandomAccessInputStream stream = this.getStream();
            stream.seek(128L);
            return this.readPlane(stream, imageIndex, planeMin, planeMax, plane);
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            byte[] fileStart = new byte[KONTRON_ID.length];
            int read = stream.read(fileStart);
            if (read != KONTRON_ID.length) {
                return false;
            }
            for (int i = 0; i < KONTRON_ID.length; ++i) {
                if (fileStart[i] == KONTRON_ID[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        public void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            stream.order(true);
            stream.seek(KONTRON_ID.length);
            short width = stream.readShort();
            short height = stream.readShort();
            meta.setWidth(width);
            meta.setHeight(height);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        @Field(label="Width from file header")
        private long width;
        @Field(label="Height from file header")
        private long height;

        public long getWidth() {
            return this.width;
        }

        public long getHeight() {
            return this.height;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata metadata = this.get(0);
            metadata.setLittleEndian(true);
            metadata.setBitsPerPixel(8);
            metadata.setPixelType(1);
            metadata.setOrderCertain(true);
            metadata.setPlanarAxisCount(2);
            metadata.setAxes(new CalibratedAxis[]{new DefaultLinearAxis(Axes.X), new DefaultLinearAxis(Axes.Y)});
            metadata.setAxisLengths(new long[]{this.width, this.height});
        }
    }
}

