/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractTranslator;
import io.scif.AbstractWriter;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.common.DateTools;
import io.scif.config.SCIFIOConfig;
import io.scif.img.axes.SCIFIOAxes;
import io.scif.io.Location;
import io.scif.io.RandomAccessInputStream;
import io.scif.io.RandomAccessOutputStream;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Image Cytometry Standard")
public class ICSFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"ics", "ids"};
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class ICSTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        public void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            Hashtable<String, String> keyValPairs = null;
            keyValPairs = dest.getKeyValPairs() == null ? new Hashtable() : dest.getKeyValPairs();
            int numAxes = source.get(0).getAxes().size();
            String order = "";
            String sizes = "";
            String units = "";
            for (int i = 0; i < numAxes; ++i) {
                CalibratedAxis axis = source.get(0).getAxis(i);
                AxisType axisType = axis.type();
                if (axisType.equals(Axes.X)) {
                    order = order + "x";
                } else if (axisType.equals(Axes.Y)) {
                    order = order + "y";
                } else if (axisType.equals(Axes.Z)) {
                    order = order + "z";
                } else if (axisType.equals(Axes.TIME)) {
                    order = order + "t";
                } else if (axisType.equals(Axes.CHANNEL)) {
                    if (source.get(0).isMultichannel()) {
                        order = "c " + order;
                        sizes = source.get(0).getAxisLength(i) + " " + sizes;
                        units = units + axis.unit() + " ";
                        continue;
                    }
                    order = order + "c";
                } else {
                    order = axisType.equals(SCIFIOAxes.PHASE) ? order + "p" : (axisType.equals(SCIFIOAxes.FREQUENCY) ? order + "f" : (axisType.getLabel().equals("bits") ? order + "bits" : order + "u"));
                }
                order = order + " ";
                sizes = sizes + source.get(0).getAxisLength(i) + " ";
                units = units + axis.unit() + " ";
            }
            keyValPairs.put("layout sizes", sizes);
            keyValPairs.put("layout order", order);
            keyValPairs.put("parameter units", units);
            keyValPairs.put("layout significant_bits", "" + source.get(0).getBitsPerPixel());
            if (source.get(0).getAxisLength(SCIFIOAxes.LIFETIME) > 1L) {
                keyValPairs.put("history type", "time resolved");
            }
            boolean signed = false;
            boolean fPoint = false;
            switch (source.get(0).getPixelType()) {
                case 0: 
                case 2: 
                case 4: {
                    signed = true;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    fPoint = true;
                    signed = true;
                }
            }
            keyValPairs.put("representation sign", signed ? "signed" : "");
            keyValPairs.put("representation format", fPoint ? "real" : "");
            keyValPairs.put("representation compression", "");
            String byteOrder = "0";
            if (source.get(0).isLittleEndian()) {
                byteOrder = fPoint ? "1" : "0";
            } else {
                String string = byteOrder = fPoint ? "0" : "1";
            }
            if (source.get(0).getBitsPerPixel() < 32) {
                byteOrder = byteOrder.equals("0") ? "1" : "0";
            }
            keyValPairs.put("representation byte_order", byteOrder);
            List<CalibratedAxis> axes = source.get(0).getAxes();
            String scale = "";
            for (int i = 0; i < axes.size(); ++i) {
                scale = scale + axes.get(i).averageScale(0.0, 1.0) + " ";
            }
            keyValPairs.put("parameter scale", scale);
            dest.setKeyValPairs(keyValPairs);
        }
    }

    public static class ICSUtils {
        private static final String[] NL = new String[]{"\n", "\r\n"};
        public static final String LEAF = "VALID_LEAF";
        public static final String[] DATE_FORMATS = new String[]{"EEEE, MMMM dd, yyyy HH:mm:ss", "EEE dd MMMM yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EE dd MMM yyyy HH:mm:ss z", "HH:mm:ss dd\\MM\\yy"};
        public static String[][] OTHER_KEYS = new String[][]{{"cube", "descriptio"}, {"cube", "description"}, {"image", "form"}, {"refinxlensmedium"}, {"refinxmedium"}, {"scil_type"}, {"source"}};
        public static final Map<String, Object> keys = ICSUtils.createKeyMap();

        private static Map<String, Object> createKeyMap() {
            HashMap<String, Object> root = new HashMap<String, Object>();
            ICSUtils.addKey(root, "ics_version");
            ICSUtils.addKey(root, "parameter", "ch");
            ICSUtils.addKey(root, "parameter", "scale");
            ICSUtils.addKey(root, "parameter", "t");
            ICSUtils.addKey(root, "parameter", "units");
            ICSUtils.addKey(root, "parameter", "labels");
            ICSUtils.addKey(root, "sensor", "s_params", "lambdaem");
            ICSUtils.addKey(root, "sensor", "s_params", "lambdaex");
            ICSUtils.addKey(root, "sensor", "s_params", "pinholeradius");
            ICSUtils.addKey(root, "representation", "byte_order");
            ICSUtils.addKey(root, "representation", "compression");
            ICSUtils.addKey(root, "representation", "format");
            ICSUtils.addKey(root, "representation", "sign");
            ICSUtils.addKey(root, "history", "author");
            ICSUtils.addKey(root, "history", "camera", "manufcaturer");
            ICSUtils.addKey(root, "history", "camera", "model");
            ICSUtils.addKey(root, "history", "cube", "emm", "nm");
            ICSUtils.addKey(root, "history", "cube", "exc", "nm");
            ICSUtils.addKey(root, "history", "date");
            ICSUtils.addKey(root, "history", "creation", "date");
            ICSUtils.addKey(root, "history", "created", "on");
            ICSUtils.addKey(root, "history", "experimenter");
            ICSUtils.addKey(root, "history", "exposure");
            ICSUtils.addKey(root, "history", "extents");
            ICSUtils.addKey(root, "history", "filterset");
            ICSUtils.addKey(root, "history", "filterset", "dichroic", "name");
            ICSUtils.addKey(root, "history", "filterset", "emm", "name");
            ICSUtils.addKey(root, "history", "filterset", "exc", "name");
            ICSUtils.addKey(root, "history", "gain");
            ICSUtils.addKey(root, "history", "laser", "manufacturer");
            ICSUtils.addKey(root, "history", "laser", "model");
            ICSUtils.addKey(root, "history", "laser", "rep", "rate");
            ICSUtils.addKey(root, "history", "laser", "power");
            ICSUtils.addKey(root, "history", "labels");
            ICSUtils.addKey(root, "history", "manufacturer");
            ICSUtils.addKey(root, "history", "microscope");
            ICSUtils.addKey(root, "history", "objective", "type");
            ICSUtils.addKey(root, "history", "objective", "immersion");
            ICSUtils.addKey(root, "history", "objective", "na");
            ICSUtils.addKey(root, "history", "objective", "workingdistance");
            ICSUtils.addKey(root, "history", "objective", "magnification");
            ICSUtils.addKey(root, "history", "objective", "mag");
            ICSUtils.addKey(root, "history", "other", "text");
            ICSUtils.addKey(root, "history", "stage", "positionx");
            ICSUtils.addKey(root, "history", "stage", "positiony");
            ICSUtils.addKey(root, "history", "stage", "positionz");
            ICSUtils.addKey(root, "history", "stage_xyzum");
            ICSUtils.addKey(root, "history", "step");
            ICSUtils.addKey(root, "history", "type");
            ICSUtils.addKey(root, "history", "wavelength*");
            ICSUtils.addKey(root, "layout", "order");
            ICSUtils.addKey(root, "layout", "significant_bits");
            ICSUtils.addKey(root, "layout", "sizes");
            return root;
        }

        private static void addKey(Map<String, Object> parent, String ... keys) {
            if (keys.length == 0) {
                parent.put(LEAF, LEAF);
            } else {
                String node = keys[0];
                Object o = parent.get(node);
                HashMap<String, Object> child = null;
                if (o == null) {
                    child = new HashMap<String, Object>();
                    parent.put(node, child);
                } else {
                    child = (HashMap<String, Object>)o;
                }
                ICSUtils.addKey(child, Arrays.copyOfRange(keys, 1, keys.length));
            }
        }
    }

    public static class Writer
    extends AbstractWriter<Metadata> {
        private long dimensionOffset;
        private int dimensionLength;
        private long pixelOffset;
        private long lastPlane = -1L;
        private RandomAccessOutputStream pixels;

        @Override
        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        @Override
        protected void initialize(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            if (!this.isInitialized(imageIndex, (int)planeIndex) && !SCIFIOMetadataTools.wholePlane(imageIndex, this.getMetadata(), planeMin, planeMax)) {
                this.pixels.seek(this.pixelOffset + (planeIndex + 1L) * ((Metadata)this.getMetadata()).get(imageIndex).getPlaneSize());
            }
            super.initialize(imageIndex, planeIndex, planeMin, planeMax);
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            this.checkParams(imageIndex, planeIndex, plane.getBytes(), planeMin, planeMax);
            Metadata meta = (Metadata)this.getMetadata();
            boolean interleaved = plane.getImageMetadata().getInterleavedAxisCount() > 0;
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            int rgbChannels = 1;
            if (meta.get(imageIndex).isMultichannel()) {
                int cIndex = meta.get(imageIndex).getAxisIndex(Axes.CHANNEL);
                rgbChannels = (int)(planeMax[cIndex] - planeMin[cIndex]);
            }
            int sizeX = (int)meta.get(imageIndex).getAxisLength(Axes.X);
            int pixelType = ((Metadata)this.getMetadata()).get(imageIndex).getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            int planeSize = (int)(meta.get(0).getSize() / meta.get(0).getPlaneCount());
            this.pixels.seek(this.pixelOffset + planeIndex * (long)planeSize);
            if (SCIFIOMetadataTools.wholePlane(imageIndex, meta, planeMin, planeMax) && (interleaved || rgbChannels == 1)) {
                this.pixels.write(plane.getBytes());
            } else {
                this.pixels.skipBytes(bytesPerPixel * rgbChannels * sizeX * y);
                for (int row = 0; row < h; ++row) {
                    ByteArrayOutputStream strip = new ByteArrayOutputStream();
                    for (int col = 0; col < w; ++col) {
                        for (int c = 0; c < rgbChannels; ++c) {
                            int index = interleaved ? rgbChannels * (row * w + col) + c : w * (c * h + row) + col;
                            strip.write(plane.getBytes(), index * bytesPerPixel, bytesPerPixel);
                        }
                    }
                    this.pixels.skipBytes(bytesPerPixel * rgbChannels * x);
                    this.pixels.write(strip.toByteArray());
                    this.pixels.skipBytes(bytesPerPixel * rgbChannels * (sizeX - w - x));
                }
            }
            this.lastPlane = planeIndex;
        }

        @Override
        public boolean canDoStacks() {
            return true;
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{0, 1, 2, 3, 4, 5, 6};
        }

        public void close(int imageIndex) throws IOException {
            if (this.lastPlane != ((Metadata)this.getMetadata()).get(imageIndex).getPlaneCount() - 1L && this.getStream() != null) {
                this.overwriteDimensions((Metadata)this.getMetadata(), imageIndex);
            }
            super.close();
            this.pixelOffset = 0L;
            this.lastPlane = -1L;
            this.dimensionOffset = 0L;
            this.dimensionLength = 0;
            if (this.pixels != null) {
                this.pixels.close();
            }
            this.pixels = null;
        }

        @Override
        public void setDest(String id) throws FormatException, IOException {
            if (FormatTools.checkSuffix(id, "ids")) {
                String metadataFile = this.makeIcsId(id);
                this.setDest(metadataFile);
                return;
            }
            this.updateMetadataIds(id);
            super.setDest(id);
        }

        @Override
        public void setDest(String id, int imageIndex) throws FormatException, IOException {
            if (FormatTools.checkSuffix(id, "ids")) {
                String metadataFile = this.makeIcsId(id);
                this.setDest(metadataFile, imageIndex);
                return;
            }
            this.updateMetadataIds(id);
            super.setDest(id, imageIndex);
        }

        @Override
        public void setDest(String id, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            if (FormatTools.checkSuffix(id, "ids")) {
                String metadataFile = this.makeIcsId(id);
                this.setDest(metadataFile, imageIndex, config);
                return;
            }
            this.updateMetadataIds(id);
            super.setDest(id, imageIndex, config);
        }

        @Override
        public void setDest(RandomAccessOutputStream out, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            String currentId = ((Metadata)this.getMetadata()).idsId != null ? ((Metadata)this.getMetadata()).idsId : ((Metadata)this.getMetadata()).icsId;
            super.setDest(out, imageIndex, config);
            if (out.length() == 0L) {
                out.writeBytes("\t\n");
                if (FormatTools.checkSuffix(currentId, "ids")) {
                    out.writeBytes("ics_version\t1.0\n");
                } else {
                    out.writeBytes("ics_version\t2.0\n");
                }
                out.writeBytes("filename\t" + currentId + "\n");
                out.writeBytes("layout\tparameters\t6\n");
                Metadata meta = (Metadata)this.getMetadata();
                int pixelType = meta.get(imageIndex).getPixelType();
                this.dimensionOffset = out.getFilePointer();
                int[] sizes = this.overwriteDimensions(meta, imageIndex);
                this.dimensionLength = (int)(out.getFilePointer() - this.dimensionOffset);
                if (this.getValidBits() != 0) {
                    out.writeBytes("layout\tsignificant_bits\t" + this.getValidBits() + "\n");
                }
                boolean signed = FormatTools.isSigned(pixelType);
                boolean littleEndian = meta.get(imageIndex).isLittleEndian();
                out.writeBytes("representation\tformat\t" + (pixelType == 6 ? "real\n" : "integer\n"));
                out.writeBytes("representation\tsign\t" + (signed ? "signed\n" : "unsigned\n"));
                out.writeBytes("representation\tcompression\tuncompressed\n");
                out.writeBytes("representation\tbyte_order\t");
                for (int i = 0; i < sizes[0] / 8; ++i) {
                    if (littleEndian && (sizes[0] < 32 || pixelType == 6) || !littleEndian && sizes[0] >= 32 && pixelType != 6) {
                        out.writeBytes(i + 1 + "\t");
                        continue;
                    }
                    out.writeBytes(sizes[0] / 8 - i + "\t");
                }
                out.writeBytes("\nparameter\tscale\t1.000000\t");
                StringBuilder units = new StringBuilder();
                for (CalibratedAxis axis : meta.get(imageIndex).getAxes()) {
                    Double value = 1.0;
                    if (axis.type() == Axes.X) {
                        value = axis.averageScale(0.0, 1.0);
                    } else if (axis.type() == Axes.Y) {
                        value = axis.averageScale(0.0, 1.0);
                    } else if (axis.type() == Axes.Z) {
                        value = axis.averageScale(0.0, 1.0);
                    } else if (axis.type() == Axes.TIME) {
                        value = axis.averageScale(0.0, 1.0);
                    }
                    units.append(axis.unit() + "\t");
                    out.writeBytes(value + "\t");
                }
                out.writeBytes("\nparameter\tunits\tbits\t" + units.toString() + "\n");
                out.writeBytes("\nend\n");
                this.pixelOffset = out.getFilePointer();
            } else if (FormatTools.checkSuffix(currentId, "ics")) {
                RandomAccessInputStream in = new RandomAccessInputStream(this.getContext(), currentId);
                in.findString("\nend\n");
                this.pixelOffset = in.getFilePointer();
                in.close();
            }
            if (FormatTools.checkSuffix(currentId, "ids")) {
                this.pixelOffset = 0L;
            }
            if (this.pixels == null) {
                this.pixels = new RandomAccessOutputStream(this.getContext(), currentId);
            }
        }

        private void updateMetadataIds(String id) {
            ((Metadata)this.getMetadata()).idsId = FormatTools.checkSuffix(id, "ids") ? id : this.makeIdsId(id);
            ((Metadata)this.getMetadata()).icsId = FormatTools.checkSuffix(id, "ics") ? id : this.makeIcsId(id);
        }

        private int[] overwriteDimensions(Metadata meta, int imageIndex) throws IOException {
            this.getStream().seek(this.dimensionOffset);
            int pixelType = meta.get(imageIndex).getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            StringBuilder dimOrder = new StringBuilder();
            int[] sizes = new int[6];
            int nextSize = 0;
            sizes[nextSize++] = 8 * bytesPerPixel;
            if (meta.get(imageIndex).isMultichannel()) {
                dimOrder.append("ch\t");
                sizes[nextSize++] = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            }
            for (CalibratedAxis axis : meta.get(imageIndex).getAxes()) {
                if (axis.type() == Axes.CHANNEL) {
                    if (dimOrder.indexOf("ch") != -1) continue;
                    sizes[nextSize++] = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
                    dimOrder.append("ch");
                } else {
                    sizes[nextSize++] = (int)meta.get(imageIndex).getAxisLength(axis.type());
                    dimOrder.append(String.valueOf(axis.type().getLabel().charAt(0)).toLowerCase());
                }
                dimOrder.append("\t");
            }
            this.getStream().writeBytes("layout\torder\tbits\t" + dimOrder.toString() + "\n");
            this.getStream().writeBytes("layout\tsizes\t");
            for (Object size : (Object)sizes) {
                this.getStream().writeBytes((int)size + "\t");
            }
            while (this.getStream().getFilePointer() - this.dimensionOffset < (long)(this.dimensionLength - 1)) {
                this.getStream().writeBytes(" ");
            }
            this.getStream().writeBytes("\n");
            return sizes;
        }

        private String makeIcsId(String idsId) {
            return this.setIdExtension(idsId, ".ics");
        }

        private String makeIdsId(String icsId) {
            return this.setIdExtension(icsId, ".ids");
        }

        private String setIdExtension(String id, String extension) {
            id = id.substring(0, id.lastIndexOf("."));
            id = id + extension;
            return id;
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        private long prevPlane;
        private boolean gzip;
        private GZIPInputStream gzipStream;
        private boolean invertY;
        private byte[] data;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Light Microscopy", "Fluorescence-Lifetime Imaging", "Unknown"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, ((byte[])plane.getData()).length, planeMin, planeMax);
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            int bpp = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
            int len = (int)FormatTools.getPlaneSize(this, imageIndex);
            int rowLen = (int)FormatTools.getPlaneSize((io.scif.Metadata)meta, w, 1, imageIndex);
            long[] coordinates = FormatTools.rasterToPosition(imageIndex, planeIndex, meta);
            long[] prevCoordinates = FormatTools.rasterToPosition(imageIndex, this.prevPlane, meta);
            if (!this.gzip) {
                this.getStream().seek(((Metadata)this.getMetadata()).offset + planeIndex * (long)len);
            } else {
                long toSkip = (planeIndex - this.prevPlane - 1L) * (long)len;
                if (this.gzipStream == null || planeIndex <= this.prevPlane) {
                    FileInputStream fis = null;
                    toSkip = planeIndex * (long)len;
                    if (((Metadata)this.getMetadata()).versionTwo) {
                        fis = new FileInputStream(((Metadata)this.getMetadata()).icsId);
                        fis.skip(((Metadata)this.getMetadata()).offset);
                    } else {
                        fis = new FileInputStream(((Metadata)this.getMetadata()).idsId);
                        toSkip += ((Metadata)this.getMetadata()).offset;
                    }
                    try {
                        this.gzipStream = new GZIPInputStream(fis);
                    }
                    catch (IOException e) {
                        this.gzip = false;
                        this.getStream().seek(((Metadata)this.getMetadata()).offset + planeIndex * (long)len);
                        this.gzipStream = null;
                    }
                }
                if (this.gzipStream != null) {
                    while (toSkip > 0L) {
                        toSkip -= this.gzipStream.skip(toSkip);
                    }
                    this.data = new byte[(int)((long)len * (meta.storedRGB() ? meta.get(imageIndex).getAxisLength(Axes.CHANNEL) : 1L))];
                    for (int toRead = this.data.length; toRead > 0; toRead -= this.gzipStream.read(this.data, this.data.length - toRead, toRead)) {
                    }
                }
            }
            int sizeC = (int)(meta.getLifetime() ? 1L : meta.get(imageIndex).getAxisLength(Axes.CHANNEL));
            if (!((Metadata)this.getMetadata()).get(imageIndex).isMultichannel() && ((Metadata)this.getMetadata()).storedRGB()) {
                this.getStream().seek(((Metadata)this.getMetadata()).offset + (long)len * FormatTools.positionToRaster(0, this, new long[]{coordinates[0], 0L, coordinates[2]}));
                if (!this.gzip && this.data == null) {
                    this.data = new byte[(int)((long)len * ((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL))];
                    this.getStream().read(this.data);
                } else if (!(this.gzip || coordinates[0] == prevCoordinates[0] && coordinates[2] == prevCoordinates[2])) {
                    this.getStream().read(this.data);
                }
                for (int row = y; row < h + y; ++row) {
                    for (int col = x; col < w + x; ++col) {
                        int src = (int)((long)bpp * (planeIndex % meta.get(imageIndex).getAxisLength(Axes.CHANNEL) + (long)sizeC * ((long)row * ((long)row * meta.get(imageIndex).getAxisLength(Axes.X) + (long)col))));
                        int dest = bpp * ((row - y) * w + (col - x));
                        System.arraycopy(this.data, src, plane.getBytes(), dest, bpp);
                    }
                }
            } else if (this.gzip) {
                RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), this.data);
                this.readPlane(s, imageIndex, planeMin, planeMax, plane);
                s.close();
            } else {
                this.readPlane(this.getStream(), imageIndex, planeMin, planeMax, plane);
            }
            if (this.invertY) {
                byte[] row = new byte[rowLen];
                for (int r = 0; r < h / 2; ++r) {
                    int topOffset = r * rowLen;
                    int bottomOffset = (h - r - 1) * rowLen;
                    System.arraycopy(plane.getBytes(), topOffset, row, 0, rowLen);
                    System.arraycopy(plane.getBytes(), bottomOffset, plane.getBytes(), topOffset, rowLen);
                    System.arraycopy(row, 0, plane.getBytes(), bottomOffset, rowLen);
                }
            }
            this.prevPlane = planeIndex;
            return plane;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.data = null;
                this.gzip = false;
                this.invertY = false;
                this.prevPlane = 0L;
                if (this.gzipStream != null) {
                    this.gzipStream.close();
                }
                this.gzipStream = null;
            }
        }

        @Override
        public void setMetadata(Metadata meta) throws IOException {
            super.setMetadata(meta);
            this.gzip = ((Metadata)this.getMetadata()).get("representation compression").equals("gzip");
            this.prevPlane = -1L;
            this.gzipStream = null;
            this.invertY = false;
            this.data = null;
        }

        @Override
        public void setSource(RandomAccessInputStream stream, SCIFIOConfig config) throws IOException {
            if (!((Metadata)this.getMetadata()).versionTwo) {
                stream.close();
                super.setSource(new RandomAccessInputStream(this.getContext(), ((Metadata)this.getMetadata()).idsId), config);
            } else {
                super.setSource(stream, config);
            }
        }

        @Override
        public String[] getDomains() {
            FormatTools.assertStream(this.getStream(), true, 0);
            String[] domain = new String[]{"Graphics"};
            if (((Metadata)this.getMetadata()).get(0).getAxisLength(SCIFIOAxes.LIFETIME) > 1L) {
                domain[0] = "Fluorescence-Lifetime Imaging";
            } else if (((Metadata)this.getMetadata()).hasInstrumentData) {
                domain[0] = "Light Microscopy";
            }
            return domain;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            this.findCompanion(stream, meta);
            RandomAccessInputStream reader = new RandomAccessInputStream(this.getContext(), meta.getIcsId());
            reader.seek(0L);
            String line = reader.findString(ICSUtils.NL);
            while (line != null && !line.trim().equals("end") && reader.getFilePointer() < reader.length() - 1L) {
                line = line.trim().toLowerCase();
                String[] tokens = line.split("[ \t]");
                StringBuilder key = new StringBuilder();
                Map keyMap = ICSUtils.keys;
                boolean validKey = false;
                for (int q = 0; q < tokens.length; ++q) {
                    tokens[q] = tokens[q].trim();
                    if (tokens[q].length() == 0) continue;
                    Object o = keyMap.get(tokens[q]);
                    if (o == null) {
                        if (!validKey) break;
                        StringBuilder value = new StringBuilder(tokens[q++]);
                        while (q < tokens.length) {
                            value.append(" ");
                            value.append(tokens[q].trim());
                            ++q;
                        }
                        String k = key.toString().trim().replaceAll("\t", " ");
                        String v = value.toString().trim();
                        meta.getTable().put(k, v);
                        meta.keyValPairs.put(k.toLowerCase(), v);
                        continue;
                    }
                    keyMap = (Map)o;
                    if (keyMap.get("VALID_LEAF") != null) {
                        validKey = true;
                    }
                    key.append(tokens[q]);
                    key.append(" ");
                }
                line = reader.findString(ICSUtils.NL);
            }
            Object icsVersion = meta.getTable().get("ics_version");
            if (icsVersion == null) {
                reader.close();
                throw new FormatException("Cannot discern ICS version");
            }
            if (icsVersion.equals("1.0")) {
                meta.setVersionTwo(false);
                String idsId = meta.getIdsId();
                if (!new Location(this.getContext(), idsId).exists()) {
                    reader.close();
                    throw new FormatException("Data file does not exist: " + idsId);
                }
                reader.close();
                this.getSource().close();
                this.updateSource(meta.getIdsId());
            } else if (icsVersion.equals("2.0")) {
                meta.setVersionTwo(true);
                meta.setIdsId(meta.getIcsId());
                meta.setSource(reader);
            } else {
                reader.close();
                throw new FormatException("Unsupported ICS version: " + icsVersion);
            }
            meta.offset = this.getSource().getFilePointer();
            this.getSource().seek(0L);
            meta.hasInstrumentData = this.nullKeyCheck(new String[]{"history cube emm nm", "history cube exc nm", "history objective NA", "history stage xyzum", "history objective magnification", "history objective mag", "history objective WorkingDistance", "history objective type", "history objective", "history objective immersion"});
        }

        private boolean nullKeyCheck(String[] testKeys) {
            for (String key : testKeys) {
                if (((Metadata)this.getMetadata()).get(key) == null) continue;
                return true;
            }
            return false;
        }

        private void findCompanion(RandomAccessInputStream stream, Metadata meta) throws FormatException {
            char[] c;
            String ext;
            if (stream.getFileName() == null) {
                return;
            }
            String idsId = stream.getFileName();
            String icsId = idsId;
            int dot = icsId.lastIndexOf(".");
            String string = ext = dot < 0 ? "" : icsId.substring(dot + 1).toLowerCase();
            if (ext.equals("ics")) {
                c = idsId.toCharArray();
                int n = c.length - 2;
                c[n] = (char)(c[n] + '\u0001');
                idsId = new String(c);
                meta.setIdsId(idsId);
            } else if (ext.equals("ids")) {
                c = icsId.toCharArray();
                int n = c.length - 2;
                c[n] = (char)(c[n] - '\u0001');
                icsId = new String(c);
            }
            Location icsFile = new Location(this.getContext(), icsId);
            if (!icsFile.exists()) {
                throw new FormatException("ICS file not found.");
            }
            meta.setIcsId(icsId);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private static final String MICRO_TIME = "micro-time";
        private boolean versionTwo = false;
        private long offset = -1L;
        private boolean hasInstrumentData = false;
        private boolean storedRGB;
        private String icsId = "";
        private String idsId = "";
        private Hashtable<String, String> keyValPairs = new Hashtable();

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata imageMeta = this.get(0);
            double[] axesSizes = this.getAxesSizes();
            String[] axes = this.getAxes();
            imageMeta.setAxes(new CalibratedAxis[0], new long[0]);
            AxisType xAxis = Axes.X;
            AxisType yAxis = Axes.Y;
            AxisType zAxis = Axes.Z;
            Double[] pixelSizes = this.getPixelSizes();
            if (pixelSizes == null) {
                pixelSizes = new Double[]{1.0, 1.0, 1.0, 1.0};
            }
            String[] paramLabels = this.getParamLabels();
            boolean lifetime = this.getLifetime();
            String label = this.getLabels();
            if (this.noMicroTime(paramLabels) && lifetime && label != null) {
                if (label.equalsIgnoreCase("t x y")) {
                    xAxis = SCIFIOAxes.LIFETIME;
                    yAxis = Axes.X;
                    zAxis = Axes.Y;
                } else if (label.equalsIgnoreCase("x y t")) {
                    zAxis = SCIFIOAxes.LIFETIME;
                } else {
                    this.log().debug((Object)("Lifetime data, unexpected 'history labels' " + label));
                }
            }
            int bitsPerPixel = 0;
            String[] units = this.getUnits();
            for (int n = 0; n < axes.length; ++n) {
                String axis = axes[n].toLowerCase();
                if (axis.equals("x")) {
                    imageMeta.addAxis(xAxis, (long)((int)axesSizes[n]));
                    FormatTools.calibrate(imageMeta.getAxis(xAxis), pixelSizes[n], 0.0, units == null ? "um" : units[n]);
                } else if (axis.equals("y")) {
                    imageMeta.addAxis(yAxis, (long)((int)axesSizes[n]));
                    FormatTools.calibrate(imageMeta.getAxis(yAxis), pixelSizes[n], 0.0, units == null ? "um" : units[n]);
                } else if (axis.equals("z") && axesSizes[n] > 1.0) {
                    imageMeta.addAxis(zAxis, (long)((int)axesSizes[n]));
                    FormatTools.calibrate(imageMeta.getAxis(zAxis), pixelSizes[n], 0.0, units == null ? "um" : units[n]);
                } else if (axis.equals("t") && axesSizes[n] > 1.0) {
                    int tIndex = imageMeta.getAxisIndex(Axes.TIME);
                    if (tIndex == -1) {
                        imageMeta.addAxis(Axes.TIME, (long)((int)axesSizes[n]));
                    } else {
                        long timeLength = imageMeta.getAxisLength(Axes.TIME) * (long)((int)axesSizes[n]);
                        imageMeta.setAxisLength(Axes.TIME, timeLength);
                    }
                    imageMeta.getAxis(Axes.TIME).setUnit(units == null ? "seconds" : units[n]);
                } else if (axis.equals("bits")) {
                    bitsPerPixel = (int)axesSizes[n];
                    while (bitsPerPixel % 8 != 0) {
                        ++bitsPerPixel;
                    }
                    if (bitsPerPixel == 24 || bitsPerPixel == 48) {
                        bitsPerPixel /= 3;
                    }
                } else {
                    if (imageMeta.getAxisIndex(Axes.X) == -1) {
                        this.setStoredRGB(true);
                    }
                    AxisType type = null;
                    type = axis.startsWith("c") ? Axes.CHANNEL : (axis.startsWith("p") ? SCIFIOAxes.PHASE : (axis.startsWith("f") ? SCIFIOAxes.FREQUENCY : Axes.unknown()));
                    imageMeta.addAxis(type, (long)axesSizes[n]);
                    imageMeta.getAxis(type).setUnit(units == null ? "unknown" : units[n]);
                }
                if (paramLabels[n] == null || !paramLabels[n].equals(MICRO_TIME)) continue;
                imageMeta.setAxisType(imageMeta.getAxes().size() - 1, SCIFIOAxes.LIFETIME);
            }
            if (this.getBitsPerPixel() != null) {
                bitsPerPixel = this.getBitsPerPixel();
            }
            imageMeta.setBitsPerPixel(bitsPerPixel);
            if (imageMeta.isMultichannel() && this.getEMWaves() != null && (long)this.getEMWaves().length == imageMeta.getAxisLength(Axes.CHANNEL)) {
                imageMeta.setAxisLength(Axes.CHANNEL, 1L);
                this.setStoredRGB(true);
            }
            imageMeta.setIndexed(false);
            imageMeta.setFalseColor(false);
            imageMeta.setMetadataComplete(true);
            imageMeta.setLittleEndian(true);
            String byteOrder = this.getByteOrder();
            String rFormat = this.getRepFormat();
            if (byteOrder != null) {
                String firstByte = byteOrder.split(" ")[0];
                int first = Integer.parseInt(firstByte);
                boolean little = rFormat.equals("real") ? first == 1 : first != 1;
                imageMeta.setLittleEndian(little);
            }
            int bytes = bitsPerPixel / 8;
            if (bitsPerPixel < 32) {
                imageMeta.setLittleEndian(!this.get(0).isLittleEndian());
            }
            boolean floatingPt = rFormat.equals("real");
            boolean signed = this.isSigned();
            try {
                imageMeta.setPixelType(FormatTools.pixelTypeFromBytes(bytes, signed, floatingPt));
            }
            catch (FormatException e) {
                this.log().error((Object)("Could not get pixel type from bytes: " + bytes), (Throwable)e);
            }
        }

        private boolean noMicroTime(String[] labels) {
            for (String s : labels) {
                if (s == null || !s.equals(MICRO_TIME)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.keyValPairs = new Hashtable();
            }
        }

        public boolean storedRGB() {
            return this.storedRGB;
        }

        public void setStoredRGB(boolean rgb) {
            this.storedRGB = rgb;
        }

        public String get(String key) {
            return this.keyValPairs.get(key);
        }

        public String getIcsId() {
            return this.icsId;
        }

        public void setIcsId(String icsId) {
            this.icsId = icsId;
        }

        public String getIdsId() {
            return this.idsId;
        }

        public void setIdsId(String idsId) {
            this.idsId = idsId;
        }

        public boolean hasInstrumentData() {
            return this.hasInstrumentData;
        }

        public void setHasInstrumentData(boolean hasInstrumentData) {
            this.hasInstrumentData = hasInstrumentData;
        }

        public boolean isVersionTwo() {
            return this.versionTwo;
        }

        public void setVersionTwo(boolean versionTwo) {
            this.versionTwo = versionTwo;
        }

        public void setKeyValPairs(Hashtable<String, String> keyValPairs) {
            this.keyValPairs = keyValPairs;
        }

        public Hashtable<String, String> getKeyValPairs() {
            return this.keyValPairs;
        }

        public void put(String key, String value) {
            if (value != null) {
                this.keyValPairs.put(key, value);
            }
        }

        public void putDate(String value) {
            this.put("history date", value);
        }

        public void putDescription(String value) {
            this.put("history other text", value);
        }

        public void putMicroscopeModel(String value) {
            this.put("history microscope", value);
        }

        public void putMicroscopeManufacturer(String value) {
            this.put("history manufacturer", value);
        }

        public void putExperimentType(String value) {
            this.put("history type", value);
        }

        public void putLifetime(boolean lifetime) {
            if (lifetime) {
                this.put("history type", "time resolved");
            }
        }

        public void putPixelSizes(Double[] pixelSizes) {
            this.put("parameter scale", this.merge(pixelSizes));
        }

        public void putUnits(String[] units) {
            this.put("parameter units", this.merge(units));
        }

        public void putAxes(String[] axes) {
            this.put("layout order", this.merge(axes));
        }

        public void putAxesSizes(double[] axesSizes) {
            this.put("layout sizes", this.mergePrimitiveDoubles(axesSizes));
        }

        public void putPhysicalPixelSizes(double[] physSizes) {
            this.put("history extents", this.mergePrimitiveDoubles(physSizes));
        }

        public void putTimestamps(Double[] timeStamp) {
            this.put("parameter t", this.merge(timeStamp));
        }

        public void putChannelNames(Hashtable<Integer, String> cNames) {
            this.put("parameter ch", this.merge(cNames.values()));
        }

        public void putPinholes(Hashtable<Integer, Double> pins) {
            this.put("sensor s_params pinholeradius", this.merge(pins.values()));
        }

        public void putEMWaves(Integer[] emWaves) {
            this.put("sensor s_params lambdaem", this.merge(emWaves));
        }

        public void putEMSingleton(Integer[] em) {
            this.put("history cube emm nm", this.merge(em));
        }

        public void putEXWaves(Integer[] exWaves) {
            this.put("sensor s_params LambdaEx", this.merge(exWaves));
        }

        public void putEXSingleton(Integer[] ex) {
            this.put("history cube exc nm", this.merge(ex));
        }

        public void putWavelengths(Hashtable<Integer, Integer> waves) {
            this.put("history wavelength*", this.merge(waves.values()));
        }

        public void putByteOrder(String byteOrder) {
            this.put("representation byte_order", byteOrder);
        }

        public void putRepFormat(String repFormat) {
            this.put("representation format", repFormat);
        }

        public void putCompression(String cmp) {
            this.put("representation compression", cmp);
        }

        public void putSigned(boolean signed) {
            this.put("representation sign", String.valueOf(signed));
        }

        public void putLaserManufacturer(String laserMan) {
            this.put("history laser manufacturer", laserMan);
        }

        public void putLaserModel(String laserMod) {
            this.put("history laser model", laserMod);
        }

        public void putLaserRepetitionRate(Double laserRep) {
            this.put("history laser rep rate", laserRep.toString());
        }

        public void putLaserPower(Double laserPower) {
            this.put("history laser power", laserPower.toString());
        }

        public void putDichroicModel(String diModel) {
            this.put("history filterset dichroic name", diModel);
        }

        public void putExcitationModel(String exModel) {
            this.put("history filterset exc name", exModel);
        }

        public void putEmissionModel(String emModel) {
            this.put("history filterset emm name", emModel);
        }

        public void putFilterSetModel(String fltrModel) {
            this.put("history filterset", fltrModel);
        }

        public void putObjectiveModel(String objModel) {
            this.put("history objective type", objModel);
        }

        public void putImmersion(String immersion) {
            this.put("history objective immersion", immersion);
        }

        public void putLensNA(Double lensNA) {
            this.put("history objective na", lensNA.toString());
        }

        public void putWorkingDistance(Double wd) {
            this.put("history objective workingdistance", wd.toString());
        }

        public void putMagnification(Double mag) {
            this.put("history objective magnification", mag.toString());
        }

        public void putDetectorManufacturer(String detMan) {
            this.put("history camera manufacturer", detMan);
        }

        public void putDetectorModel(String detModel) {
            this.put("history camera model", detModel);
        }

        public void putBitsPerPixel(Integer bpp) {
            this.put("layout significant_bits", bpp.toString());
        }

        public void putGains(Hashtable<Integer, Double> gains) {
            this.put("history gain", this.merge(gains.values()));
        }

        public void putAuthorLastName(String lastName) {
            this.put("history author", lastName);
        }

        public void putStagePositions(Double[] positions) {
            this.put("history stage_xyzum", this.merge(positions));
        }

        public void putStageX(Double stageX) {
            this.put("history stage positionx", stageX.toString());
        }

        public void putStageY(Double stageY) {
            this.put("history stage positiony", stageY.toString());
        }

        public void putStageZ(Double stageZ) {
            this.put("history stage positionz", stageZ.toString());
        }

        public void putExposureTime(Double expTime) {
            this.put("history exposure", expTime.toString());
        }

        public String getDate() {
            String date = null;
            String[] kv = this.findValueForKey("history date", "history created on", "history creation date");
            if (kv != null) {
                if (kv[0].equalsIgnoreCase("history date") || kv[0].equalsIgnoreCase("history created on")) {
                    if (kv[1].indexOf(" ") > 0) {
                        date = kv[1].substring(0, kv[1].lastIndexOf(" "));
                    }
                } else if (kv[0].equalsIgnoreCase("history creation date")) {
                    date = kv[1];
                }
            }
            if (date != null) {
                date = DateTools.formatDate(date, ICSUtils.DATE_FORMATS);
            }
            return date;
        }

        public String getDescription() {
            return this.findStringValueForKey("history other text");
        }

        public String getMicroscopeModel() {
            return this.findStringValueForKey("history microscope");
        }

        public String getMicroscopeManufacturer() {
            return this.findStringValueForKey("history manufacturer");
        }

        public boolean getLifetime() {
            String[] kv = this.findValueForKey("history type");
            boolean lifetime = false;
            if (kv != null && (kv[1].equalsIgnoreCase("time resolved") || kv[1].equalsIgnoreCase("FluorescenceLifetime"))) {
                lifetime = true;
            }
            return lifetime;
        }

        public String[] getParamLabels() {
            String pLabels = this.findStringValueForKey("parameter labels");
            if (pLabels == null) {
                return new String[this.getAxes().length];
            }
            return pLabels.split(" ");
        }

        public String getLabels() {
            return this.findStringValueForKey("history labels");
        }

        public String getExperimentType() {
            return this.findStringValueForKey("history type");
        }

        public Double[] getPixelSizes() {
            String[] kv = this.findValueForKey("parameter scale");
            return kv == null ? null : this.splitDoubles(kv[1]);
        }

        public String[] getUnits() {
            String[] kv = this.findValueForKey("parameter units");
            return kv == null ? null : kv[1].split("\\s+");
        }

        public String[] getAxes() {
            String[] kv = this.findValueForKey("layout order");
            String[] axes = null;
            if (kv != null) {
                StringTokenizer t = new StringTokenizer(kv[1]);
                axes = new String[t.countTokens()];
                for (int n = 0; n < axes.length; ++n) {
                    axes[n] = t.nextToken().trim();
                }
            }
            return axes;
        }

        public double[] getAxesSizes() {
            String[] kv = this.findValueForKey("layout sizes");
            double[] sizes = null;
            if (kv != null) {
                String[] lengths = kv[1].split(" ");
                sizes = new double[lengths.length];
                for (int n = 0; n < sizes.length; ++n) {
                    try {
                        sizes[n] = Double.parseDouble(lengths[n].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse axis length", (Throwable)e);
                    }
                }
            }
            return sizes;
        }

        public double[] getPhysicalPixelSizes() {
            String[] kv = this.findValueForKey("history extents");
            double[] sizes = null;
            if (kv != null) {
                String[] lengths = kv[1].split(" ");
                sizes = new double[lengths.length];
                for (int n = 0; n < sizes.length; ++n) {
                    try {
                        sizes[n] = Double.parseDouble(lengths[n].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse pixel sizes", (Throwable)e);
                    }
                }
            }
            return sizes;
        }

        public Double[] getTimestamps() {
            String[] kv = this.findValueForKey("parameter t");
            return kv == null ? null : this.splitDoubles(kv[1]);
        }

        public Hashtable<Integer, String> getChannelNames() {
            String[] kv = this.findValueForKey("parameter ch");
            Hashtable<Integer, String> channelNames = new Hashtable<Integer, String>();
            if (kv != null) {
                String[] names = kv[1].split(" ");
                for (int n = 0; n < names.length; ++n) {
                    channelNames.put(new Integer(n), names[n].trim());
                }
            }
            return channelNames;
        }

        public void addStepChannel(Hashtable<Integer, String> channelNames) {
            String[] kv = this.findValueIteration("history step", "name");
            if (kv != null) {
                channelNames.put(new Integer(kv[0].substring(12, kv[0].indexOf(" ", 12))), kv[1]);
            }
        }

        public void addCubeChannel(Hashtable<Integer, String> channelNames) {
            String[] kv = this.findValueForKey("history cube");
            if (kv != null) {
                channelNames.put(new Integer(channelNames.size()), kv[1]);
            }
        }

        public Hashtable<Integer, Double> getPinholes() {
            String[] kv = this.findValueForKey("sensor s_params pinholeradius");
            Hashtable<Integer, Double> pinholes = new Hashtable<Integer, Double>();
            if (kv != null) {
                String[] pins = kv[1].split(" ");
                int channel = 0;
                for (String pin : pins) {
                    if (pin.trim().equals("")) continue;
                    try {
                        pinholes.put(channel++, new Double(pin));
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse pinhole", (Throwable)e);
                    }
                }
            }
            return pinholes;
        }

        public Integer[] getEMWaves() {
            String[] kv = this.findValueForKey("sensor s_params lambdaem");
            Integer[] emWaves = null;
            if (kv != null) {
                String[] waves = kv[1].split(" ");
                emWaves = new Integer[waves.length];
                for (int n = 0; n < emWaves.length; ++n) {
                    try {
                        emWaves[n] = new Integer((int)Double.parseDouble(waves[n]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse emission wavelength", (Throwable)e);
                    }
                }
            }
            return emWaves;
        }

        public Integer[] getEMSingleton() {
            String[] kv = this.findValueForKey("history cube emm nm");
            Integer[] emWaves = null;
            if (kv != null) {
                emWaves = new Integer[]{new Integer(kv[1].split(" ")[1].trim())};
            }
            return emWaves;
        }

        public Integer[] getEXWaves() {
            String[] kv = this.findValueForKey("sensor s_params lambdaex");
            Integer[] exWaves = null;
            if (kv != null) {
                String[] waves = kv[1].split(" ");
                exWaves = new Integer[waves.length];
                for (int n = 0; n < exWaves.length; ++n) {
                    try {
                        exWaves[n] = new Integer((int)Double.parseDouble(waves[n]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse excitation wavelength", (Throwable)e);
                    }
                }
            }
            return exWaves;
        }

        public Integer[] getEXSingleton() {
            String[] kv = this.findValueForKey("history cube exc nm");
            Integer[] exWaves = null;
            if (kv != null) {
                exWaves = new Integer[]{new Integer(kv[1].split(" ")[1].trim())};
            }
            return exWaves;
        }

        public Hashtable<Integer, Integer> getWavelengths() {
            String[] kv = this.findValueForKey("history wavelength*");
            Hashtable<Integer, Integer> wavelengths = new Hashtable<Integer, Integer>();
            if (kv != null) {
                String[] waves = kv[1].split(" ");
                for (int n = 0; n < waves.length; ++n) {
                    wavelengths.put(new Integer(n), new Integer(waves[n]));
                }
            }
            return wavelengths;
        }

        public void addLaserWavelength(Hashtable<Integer, Integer> wavelengths) {
            String[] kv = this.findValueIteration("history laser", "wavelength");
            if (kv != null) {
                int laser = Integer.parseInt(kv[0].substring(13, kv[0].indexOf(" ", 13))) - 1;
                kv[1] = kv[1].replaceAll("nm", "").trim();
                try {
                    wavelengths.put(new Integer(laser), new Integer(kv[1]));
                }
                catch (NumberFormatException e) {
                    this.log().debug((Object)"Could not parse wavelength", (Throwable)e);
                }
            }
        }

        public String getByteOrder() {
            return this.findStringValueForKey("representation byte_order");
        }

        public String getRepFormat() {
            return this.findStringValueForKey("representation format");
        }

        public String getCompression() {
            return this.findStringValueForKey("representation compression");
        }

        public boolean isSigned() {
            String signed = this.findStringValueForKey("representation sign");
            return signed != null && signed.equals("signed");
        }

        public String getLaserManufacturer() {
            return this.findStringValueForKey("history laser manufacturer");
        }

        public String getLaserModel() {
            return this.findStringValueForKey("history laser model");
        }

        public Double getLaserRepetitionRate() {
            return this.findDoubleValueForKey("history laser rep rate");
        }

        public Double getLaserPower() {
            return this.findDoubleValueForKey("history laser power");
        }

        public String getDichroicModel() {
            return this.findStringValueForKey("history filterset dichroic name");
        }

        public String getExcitationModel() {
            return this.findStringValueForKey("history filterset exc name");
        }

        public String getEmissionModel() {
            return this.findStringValueForKey("history filterset emm name");
        }

        public String getFilterSetModel() {
            return this.findStringValueForKey("history filterset");
        }

        public String getObjectiveModel() {
            return this.findStringValueForKey("history objective type", "history objective");
        }

        public String getImmersion() {
            return this.findStringValueForKey("history objective immersion");
        }

        public Double getLensNA() {
            return this.findDoubleValueForKey("history objective na");
        }

        public Double getWorkingDistance() {
            return this.findDoubleValueForKey("history objective workingdistance");
        }

        public Double getMagnification() {
            return this.findDoubleValueForKey("history objective magnification", "history objective mag");
        }

        public String getDetectorManufacturer() {
            return this.findStringValueForKey("history camera manufacturer");
        }

        public String getDetectorModel() {
            return this.findStringValueForKey("history camera model");
        }

        public Integer getBitsPerPixel() {
            return this.findIntValueForKey("layout significant_bits");
        }

        public Hashtable<Integer, Double> getGains() {
            String[] kv = this.findValueForKey("history gain");
            Hashtable<Integer, Double> gains = new Hashtable<Integer, Double>();
            if (kv != null) {
                Integer n = new Integer(0);
                try {
                    n = new Integer(kv[0].substring(12).trim());
                    n = new Integer(n - 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                gains.put(n, new Double(kv[1]));
            }
            return gains;
        }

        public String getAuthorLastName() {
            return this.findStringValueForKey("history author", "history experimenter");
        }

        public Double[] getStagePositions() {
            String[] kv = this.findValueForKey("history stage_xyzum");
            Double[] stagePos = null;
            if (kv != null) {
                String[] positions = kv[1].split(" ");
                stagePos = new Double[positions.length];
                for (int n = 0; n < stagePos.length; ++n) {
                    try {
                        stagePos[n] = new Double(positions[n]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse stage position", (Throwable)e);
                    }
                }
            }
            return stagePos;
        }

        public Double getStageX() {
            return this.findDoubleValueForKey("history stage positionx");
        }

        public Double getStageY() {
            return this.findDoubleValueForKey("history stage positiony");
        }

        public Double getStageZ() {
            return this.findDoubleValueForKey("history stage positionz");
        }

        public Double getExposureTime() {
            String expTime;
            String[] kv = this.findValueForKey("history exposure");
            Double exposureTime = null;
            if (kv != null && (expTime = kv[1]).contains(" ")) {
                exposureTime = new Double(expTime.indexOf(" "));
            }
            return exposureTime;
        }

        String[] findKeyValue(String[] tokens, String[][] regexesArray) {
            String[] keyValue = this.findKeyValueForCategory(tokens, regexesArray);
            if (null == keyValue) {
                keyValue = this.findKeyValueOther(tokens, ICSUtils.OTHER_KEYS);
            }
            if (null == keyValue) {
                String key = tokens[0];
                String value = this.concatenateTokens(tokens, 1, tokens.length);
                keyValue = new String[]{key, value};
            }
            return keyValue;
        }

        private String concatenateTokens(String[] tokens, int start, int stop) {
            StringBuilder returnValue = new StringBuilder();
            for (int i = start; i < tokens.length && i < stop; ++i) {
                returnValue.append(tokens[i]);
                if (i >= stop - 1) continue;
                returnValue.append(' ');
            }
            return returnValue.toString();
        }

        private Double findDoubleValueForKey(String ... keys) {
            String[] kv = this.findValueForKey(keys);
            return kv == null ? null : new Double(kv[1]);
        }

        private Integer findIntValueForKey(String ... keys) {
            String[] kv = this.findValueForKey(keys);
            return kv == null ? null : new Integer(kv[1]);
        }

        private String findStringValueForKey(String ... keys) {
            String[] kv = this.findValueForKey(keys);
            return kv == null ? null : kv[1];
        }

        private String[] findValueForKey(String ... keys) {
            for (String key : keys) {
                String value = this.keyValPairs.get(key);
                if (value == null) continue;
                return new String[]{key, value};
            }
            return null;
        }

        private String[] findValueIteration(String starts, String ends) {
            for (String key : this.keyValPairs.keySet()) {
                if (starts != null && !key.startsWith(starts) || ends != null && !key.endsWith(ends)) continue;
                return new String[]{key, this.keyValPairs.get(key)};
            }
            return null;
        }

        private String[] findKeyValueForCategory(String[] tokens, String[][] regexesArray) {
            String[] keyValue = null;
            for (String[] regexes : regexesArray) {
                if (!this.compareTokens(tokens, 1, regexes, 0)) continue;
                int splitIndex = 1 + regexes.length;
                String key = this.concatenateTokens(tokens, 0, splitIndex);
                String value = this.concatenateTokens(tokens, splitIndex, tokens.length);
                keyValue = new String[]{key, value};
                break;
            }
            return keyValue;
        }

        private String[] findKeyValueOther(String[] tokens, String[][] regexesArray) {
            String[] keyValue = null;
            for (String[] regexes : regexesArray) {
                for (int i = 1; i < tokens.length - regexes.length; ++i) {
                    if (!tokens[i].toLowerCase().matches(regexes[0]) || 1 != regexes.length && !this.compareTokens(tokens, i + 1, regexes, 1)) continue;
                    int splitIndex = i + regexes.length;
                    String key = this.concatenateTokens(tokens, 0, splitIndex);
                    String value = this.concatenateTokens(tokens, splitIndex, tokens.length);
                    keyValue = new String[]{key, value};
                    break;
                }
                if (null != keyValue) break;
            }
            return keyValue;
        }

        private boolean compareTokens(String[] tokens, int tokenIndex, String[] regexes, int regexesIndex) {
            boolean returnValue = true;
            int i = tokenIndex;
            for (int j = regexesIndex; j < regexes.length; ++j) {
                if (i >= tokens.length || !tokens[i].toLowerCase().matches(regexes[j])) {
                    returnValue = false;
                    break;
                }
                ++i;
            }
            return returnValue;
        }

        private Double[] splitDoubles(String v) {
            StringTokenizer t = new StringTokenizer(v);
            Double[] values = new Double[t.countTokens()];
            for (int n = 0; n < values.length; ++n) {
                String token = t.nextToken().trim();
                try {
                    values[n] = new Double(token);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.log().debug((Object)("Could not parse double value '" + token + "'"), (Throwable)e);
                }
            }
            return values;
        }

        private String mergePrimitiveDoubles(double ... doubles) {
            Double[] d = new Double[doubles.length];
            for (int i = 0; i < doubles.length; ++i) {
                d[i] = doubles[i];
            }
            return this.merge(d);
        }

        private <T> String merge(Collection<T> collection) {
            Object[] array = collection.toArray();
            return this.merge(array);
        }

        private <T> String merge(T ... values) {
            String s = "";
            for (T v : values) {
                s = s + v.toString() + " ";
            }
            return s;
        }
    }
}

