/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractTranslator;
import io.scif.AbstractWriter;
import io.scif.BufferedImagePlane;
import io.scif.Field;
import io.scif.FieldPrinter;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.common.DataTools;
import io.scif.config.SCIFIOConfig;
import io.scif.gui.AWTImageTools;
import io.scif.gui.BufferedImageReader;
import io.scif.io.RandomAccessInputStream;
import io.scif.io.RandomAccessOutputStream;
import io.scif.io.StreamTools;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageIO;
import net.imagej.axis.Axes;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="Animated PNG")
public class APNGFormat
extends AbstractFormat {
    public static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"png"};
    }

    public static class IENDChunk
    extends APNGChunk {
        public IENDChunk() {
            super(new byte[]{73, 69, 78, 68});
        }
    }

    public static class FDATChunk
    extends APNGChunk {
        @Field(label="sequence_number")
        private int sequenceNumber;

        public FDATChunk() {
            super(new byte[]{102, 100, 65, 84});
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }
    }

    public static class ACTLChunk
    extends APNGChunk {
        @Field(label="sequence_number")
        private int sequenceNumber;
        @Field(label="num_frames")
        private int numFrames;
        @Field(label="num_plays")
        private int numPlays;

        public ACTLChunk() {
            super(new byte[]{97, 99, 84, 76});
        }

        public int getNumFrames() {
            return this.numFrames;
        }

        public void setNumFrames(int numFrames) {
            this.numFrames = numFrames;
        }

        public int getNumPlays() {
            return this.numPlays;
        }

        public void setNumPlays(int numPlays) {
            this.numPlays = numPlays;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }
    }

    public static class IDATChunk
    extends APNGChunk {
        public IDATChunk() {
            super(new byte[]{73, 68, 65, 84});
        }
    }

    public static class FCTLChunk
    extends APNGChunk {
        @Field(label="sequence_number")
        private int sequenceNumber;
        @Field(label="width")
        private int width;
        @Field(label="height")
        private int height;
        @Field(label="x_offset")
        private int xOffset;
        @Field(label="y_offset")
        private int yOffset;
        @Field(label="delay_num")
        private short delayNum;
        @Field(label="delay_den")
        private short delayDen;
        @Field(label="dispose_op")
        private byte disposeOp;
        @Field(label="blend_op")
        private byte blendOp;
        private final List<FDATChunk> fdatChunks = new ArrayList<FDATChunk>();

        public FCTLChunk() {
            super(new byte[]{102, 99, 84, 76});
        }

        public void addChunk(FDATChunk chunk) {
            this.fdatChunks.add(chunk);
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getxOffset() {
            return this.xOffset;
        }

        public void setxOffset(int xOffset) {
            this.xOffset = xOffset;
        }

        public int getyOffset() {
            return this.yOffset;
        }

        public void setyOffset(int yOffset) {
            this.yOffset = yOffset;
        }

        public short getDelayNum() {
            return this.delayNum;
        }

        public void setDelayNum(short delayNum) {
            this.delayNum = delayNum;
        }

        public short getDelayDen() {
            return this.delayDen;
        }

        public void setDelayDen(short delayDen) {
            this.delayDen = delayDen;
        }

        public byte getDisposeOp() {
            return this.disposeOp;
        }

        public void setDisposeOp(byte disposeOp) {
            this.disposeOp = disposeOp;
        }

        public byte getBlendOp() {
            return this.blendOp;
        }

        public void setBlendOp(byte blendOp) {
            this.blendOp = blendOp;
        }

        public List<FDATChunk> getFdatChunks() {
            return this.fdatChunks;
        }

        @Override
        public int[] getFrameCoordinates() {
            return new int[]{this.xOffset, this.yOffset, this.width, this.height};
        }
    }

    public static class PLTEChunk
    extends APNGChunk {
        private byte[] red;
        private byte[] green;
        private byte[] blue;

        public PLTEChunk() {
            super(new byte[]{80, 76, 84, 69});
        }

        public byte[] getRed() {
            return this.red;
        }

        public void setRed(byte[] red) {
            this.red = red;
        }

        public byte[] getGreen() {
            return this.green;
        }

        public void setGreen(byte[] green) {
            this.green = green;
        }

        public byte[] getBlue() {
            return this.blue;
        }

        public void setBlue(byte[] blue) {
            this.blue = blue;
        }
    }

    public static class IHDRChunk
    extends APNGChunk {
        @Field(label="Width")
        private int width;
        @Field(label="height")
        private int height;
        @Field(label="Bit depth")
        private byte bitDepth;
        @Field(label="Colour type")
        private byte colourType;
        @Field(label="Compression Method")
        private byte compressionMethod;
        @Field(label="Filter method")
        private byte filterMethod;
        @Field(label="Interlace method")
        private byte interlaceMethod;

        public IHDRChunk() {
            super(new byte[]{73, 72, 68, 82});
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public byte getBitDepth() {
            return this.bitDepth;
        }

        public void setBitDepth(byte bitDepth) {
            this.bitDepth = bitDepth;
        }

        public byte getColourType() {
            return this.colourType;
        }

        public void setColourType(byte colourType) {
            this.colourType = colourType;
        }

        public byte getCompressionMethod() {
            return this.compressionMethod;
        }

        public void setCompressionMethod(byte compressionMethod) {
            this.compressionMethod = compressionMethod;
        }

        public byte getFilterMethod() {
            return this.filterMethod;
        }

        public void setFilterMethod(byte filterMethod) {
            this.filterMethod = filterMethod;
        }

        public byte getInterlaceMethod() {
            return this.interlaceMethod;
        }

        public void setInterlaceMethod(byte interlaceMethod) {
            this.interlaceMethod = interlaceMethod;
        }
    }

    public static class APNGChunk {
        private long offset;
        private int length;
        private final byte[] chunkSignature;

        public APNGChunk(byte[] signature) {
            this.chunkSignature = signature;
        }

        public byte[] getCHUNK_SIGNATURE() {
            return this.chunkSignature;
        }

        public int[] getFrameCoordinates() {
            return new int[0];
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return new FieldPrinter(this).toString();
        }
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class APNGTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        public void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            IHDRChunk ihdr = dest.getIhdr() == null ? new IHDRChunk() : dest.getIhdr();
            PLTEChunk plte = dest.getPlte() == null ? new PLTEChunk() : dest.getPlte();
            ACTLChunk actl = dest.getActl() == null ? new ACTLChunk() : dest.getActl();
            ArrayList<FCTLChunk> fctl = new ArrayList<FCTLChunk>();
            dest.setIhdr(ihdr);
            dest.setPlte(plte);
            dest.setActl(actl);
            dest.setFctl(fctl);
            ihdr.setWidth((int)source.get(0).getAxisLength(Axes.X));
            ihdr.setHeight((int)source.get(0).getAxisLength(Axes.Y));
            ihdr.setBitDepth((byte)source.get(0).getBitsPerPixel());
            ihdr.setFilterMethod((byte)0);
            ihdr.setCompressionMethod((byte)0);
            ihdr.setInterlaceMethod((byte)0);
            long sizec = source.get(0).isMultichannel() ? source.get(0).getAxisLength(Axes.CHANNEL) : 1L;
            boolean indexed = source.get(0).isIndexed();
            if (indexed) {
                ihdr.setColourType((byte)3);
            } else if (sizec == 2L) {
                ihdr.setColourType((byte)4);
                ihdr.setBitDepth((byte)(ihdr.getBitDepth() / 2));
            } else if (sizec == 4L) {
                ihdr.setColourType((byte)6);
                ihdr.setBitDepth((byte)(ihdr.getBitDepth() / 2));
            } else if (sizec != 3L) {
                ihdr.setColourType((byte)0);
            } else {
                ihdr.setColourType((byte)2);
            }
            actl.setNumFrames((int)source.get(0).getPlaneCount());
            for (int i = 0; i < actl.getNumFrames(); ++i) {
                FCTLChunk frame = new FCTLChunk();
                frame.setHeight(ihdr.getHeight());
                frame.setWidth(ihdr.getWidth());
                frame.setxOffset(0);
                frame.setyOffset(0);
                frame.setSequenceNumber(i);
                frame.setDelayDen((short)0);
                frame.setDelayNum((short)0);
                frame.setBlendOp((byte)0);
                frame.setDisposeOp((byte)0);
                fctl.add(frame);
            }
            dest.setLittleEndian(source.get(0).isLittleEndian());
            boolean signed = FormatTools.isSigned(source.get(0).getPixelType());
            dest.setSigned(signed);
            Object separateDefault = source.get(0).getTable().get("separate default");
            dest.setSeparateDefault(separateDefault == null ? false : (Boolean)separateDefault);
        }
    }

    public static class Writer
    extends AbstractWriter<Metadata> {
        private int numFrames = 0;
        private long numFramesPointer = 0L;
        private int nextSequenceNumber;

        @Override
        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        @Override
        protected void initialize(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            if (!this.isInitialized(imageIndex, planeIndex) && this.numFrames == 0) {
                if (!((Metadata)this.getMetadata()).isSeparateDefault()) {
                    this.writeFCTL(planeIndex);
                }
                this.writePLTE();
            }
            super.initialize(imageIndex, planeIndex, planeMin, planeMax);
        }

        @Override
        public void setDest(RandomAccessOutputStream out, int imageIndex, SCIFIOConfig config) throws IOException, FormatException {
            super.setDest(out, imageIndex, config);
            if (out.length() == 0L) {
                int width = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.X);
                int height = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.Y);
                int bytesPerPixel = FormatTools.getBytesPerPixel(((Metadata)this.getMetadata()).get(imageIndex).getPixelType());
                int nChannels = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL);
                boolean indexed = this.getColorModel() != null && this.getColorModel() instanceof IndexColorModel;
                out.write(PNG_SIGNATURE);
                out.writeInt(13);
                byte[] b = new byte[17];
                b[0] = 73;
                b[1] = 72;
                b[2] = 68;
                b[3] = 82;
                Bytes.unpack((long)width, (byte[])b, (int)4, (int)4, (boolean)false);
                Bytes.unpack((long)height, (byte[])b, (int)8, (int)4, (boolean)false);
                b[12] = (byte)(bytesPerPixel * 8);
                if (indexed) {
                    b[13] = 3;
                } else if (nChannels == 1) {
                    b[13] = 0;
                } else if (nChannels == 2) {
                    b[13] = 4;
                } else if (nChannels == 3) {
                    b[13] = 2;
                } else if (nChannels == 4) {
                    b[13] = 6;
                }
                b[14] = ((Metadata)this.getMetadata()).getIhdr().getCompressionMethod();
                b[15] = ((Metadata)this.getMetadata()).getIhdr().getFilterMethod();
                b[16] = ((Metadata)this.getMetadata()).getIhdr().getInterlaceMethod();
                out.write(b);
                out.writeInt(this.crc(b));
                ACTLChunk actl = ((Metadata)this.getMetadata()).getActl();
                out.writeInt(8);
                out.writeBytes("acTL");
                this.numFramesPointer = out.getFilePointer();
                out.writeInt(actl == null ? 0 : actl.getNumFrames());
                out.writeInt(actl == null ? 0 : actl.getNumPlays());
                out.writeInt(0);
            }
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            this.checkParams(imageIndex, planeIndex, plane.getBytes(), planeMin, planeMax);
            if (!SCIFIOMetadataTools.wholePlane(imageIndex, this.getMetadata(), planeMin, planeMax)) {
                throw new FormatException("APNGWriter does not yet support saving image tiles.");
            }
            if (this.numFrames == 0) {
                this.writePixels(imageIndex, "IDAT", plane, planeMin, planeMax);
            } else {
                this.writeFCTL(planeIndex);
                this.writePixels(imageIndex, "fdAT", plane, planeMin, planeMax);
            }
            ++this.numFrames;
        }

        @Override
        public boolean canDoStacks() {
            return true;
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{0, 1, 2, 3};
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            if (this.getStream() != null) {
                this.writeFooter();
            }
            super.close(fileOnly);
            this.numFrames = 0;
            this.numFramesPointer = 0L;
            this.nextSequenceNumber = 0;
        }

        private int crc(byte[] buf) {
            return this.crc(buf, 0, buf.length);
        }

        private int crc(byte[] buf, int off, int len) {
            CRC32 crc = new CRC32();
            crc.update(buf, off, len);
            return (int)crc.getValue();
        }

        private void writeFCTL(long planeIndex) throws IOException {
            this.getStream().writeInt(26);
            FCTLChunk fctl = ((Metadata)this.getMetadata()).getFctl().get((int)(((Metadata)this.getMetadata()).isSeparateDefault() ? planeIndex - 1L : planeIndex));
            byte[] b = new byte[30];
            Bytes.unpack((long)22L, (byte[])b, (int)0, (int)4, (boolean)false);
            b[0] = 102;
            b[1] = 99;
            b[2] = 84;
            b[3] = 76;
            Bytes.unpack((long)this.nextSequenceNumber++, (byte[])b, (int)4, (int)4, (boolean)false);
            Bytes.unpack((long)fctl.getWidth(), (byte[])b, (int)8, (int)4, (boolean)false);
            Bytes.unpack((long)fctl.getHeight(), (byte[])b, (int)12, (int)4, (boolean)false);
            Bytes.unpack((long)fctl.getxOffset(), (byte[])b, (int)16, (int)4, (boolean)false);
            Bytes.unpack((long)fctl.getyOffset(), (byte[])b, (int)20, (int)4, (boolean)false);
            Bytes.unpack((long)fctl.getDelayNum(), (byte[])b, (int)24, (int)2, (boolean)false);
            Bytes.unpack((long)fctl.getDelayDen(), (byte[])b, (int)26, (int)2, (boolean)false);
            b[28] = fctl.getDisposeOp();
            b[29] = fctl.getBlendOp();
            this.getStream().write(b);
            this.getStream().writeInt(this.crc(b));
        }

        private void writePLTE() throws IOException {
            if (!(this.getColorModel() instanceof IndexColorModel)) {
                return;
            }
            IndexColorModel model = (IndexColorModel)this.getColorModel();
            byte[][] lut = new byte[3][256];
            model.getReds(lut[0]);
            model.getGreens(lut[1]);
            model.getBlues(lut[2]);
            this.getStream().writeInt(768);
            byte[] b = new byte[772];
            b[0] = 80;
            b[1] = 76;
            b[2] = 84;
            b[3] = 69;
            for (int i = 0; i < lut[0].length; ++i) {
                for (int j = 0; j < lut.length; ++j) {
                    b[i * lut.length + j + 4] = lut[j][i];
                }
            }
            this.getStream().write(b);
            this.getStream().writeInt(this.crc(b));
        }

        private void writePixels(int imageIndex, String chunk, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            byte[] stream = plane.getBytes();
            long rgbCCount = ((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL);
            boolean interleaved = plane.getImageMetadata().getInterleavedAxisCount() > 0;
            int pixelType = ((Metadata)this.getMetadata()).get(imageIndex).getPixelType();
            boolean signed = FormatTools.isSigned(pixelType);
            if (!SCIFIOMetadataTools.wholePlane(imageIndex, this.getMetadata(), planeMin, planeMax)) {
                throw new FormatException("APNGWriter does not support writing tiles.");
            }
            int width = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.X);
            int height = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.Y);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            s.write(chunk.getBytes());
            if (chunk.equals("fdAT")) {
                s.write(Bytes.fromInt((int)this.nextSequenceNumber++, (boolean)false));
            }
            DeflaterOutputStream deflater = new DeflaterOutputStream(s);
            long planeSize = (long)stream.length / rgbCCount;
            int rowLen = stream.length / height;
            int bytesPerPixel = stream.length / (int)((long)(width * height) * rgbCCount);
            byte[] rowBuf = new byte[rowLen];
            for (int i = 0; i < height; ++i) {
                deflater.write(0);
                if (interleaved) {
                    if (((Metadata)this.getMetadata()).get(0).isLittleEndian()) {
                        int col = 0;
                        while ((long)col < (long)width * rgbCCount) {
                            int offset = (int)((long)i * rgbCCount * (long)width + (long)col) * bytesPerPixel;
                            int pixel = Bytes.toInt((byte[])stream, (int)offset, (int)bytesPerPixel, (boolean)((Metadata)this.getMetadata()).get(0).isLittleEndian());
                            Bytes.unpack((long)pixel, (byte[])rowBuf, (int)(col * bytesPerPixel), (int)bytesPerPixel, (boolean)false);
                            ++col;
                        }
                    } else {
                        System.arraycopy(stream, i * rowLen, rowBuf, 0, rowLen);
                    }
                } else {
                    int max = (int)Math.pow(2.0, bytesPerPixel * 8 - 1);
                    for (int col = 0; col < width; ++col) {
                        int c = 0;
                        while ((long)c < rgbCCount) {
                            int offset = (int)((long)c * planeSize + (long)((i * width + col) * bytesPerPixel));
                            int pixel = Bytes.toInt((byte[])stream, (int)offset, (int)bytesPerPixel, (boolean)((Metadata)this.getMetadata()).get(0).isLittleEndian());
                            if (signed) {
                                pixel = pixel < max ? (pixel += max) : (pixel -= max);
                            }
                            int output = (int)((long)col * rgbCCount + (long)c) * bytesPerPixel;
                            DataTools.unpackBytes(pixel, rowBuf, output, bytesPerPixel, false);
                            ++c;
                        }
                    }
                }
                deflater.write(rowBuf);
            }
            deflater.finish();
            byte[] b = s.toByteArray();
            this.getStream().writeInt(b.length - 4);
            this.getStream().write(b);
            this.getStream().writeInt(this.crc(b));
        }

        private void writeFooter() throws IOException {
            this.getStream().writeInt(0);
            this.getStream().writeBytes("IEND");
            this.getStream().writeInt(this.crc("IEND".getBytes()));
            this.getStream().seek(this.numFramesPointer);
            this.getStream().writeInt(this.numFrames);
            this.getStream().skipBytes(4);
            byte[] b = new byte[12];
            b[0] = 97;
            b[1] = 99;
            b[2] = 84;
            b[3] = 76;
            Bytes.unpack((long)this.numFrames, (byte[])b, (int)4, (int)4, (boolean)false);
            Bytes.unpack((long)(((Metadata)this.getMetadata()).getActl() == null ? 0L : (long)((Metadata)this.getMetadata()).getActl().getNumPlays()), (byte[])b, (int)8, (int)4, (boolean)false);
            this.getStream().writeInt(this.crc(b));
        }
    }

    public static class Reader
    extends BufferedImageReader<Metadata> {
        private BufferedImagePlane lastPlane;
        private long lastPlaneIndex = -1L;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public void setMetadata(Metadata meta) throws IOException {
            this.lastPlaneIndex = -1L;
            this.lastPlane = null;
            super.setMetadata(meta);
        }

        @Override
        public BufferedImagePlane openPlane(int imageIndex, long planeIndex, BufferedImagePlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, -1, planeMin, planeMax);
            if (planeIndex == this.lastPlaneIndex && this.lastPlane != null) {
                BufferedImage subImage = AWTImageTools.getSubimage((BufferedImage)this.lastPlane.getData(), meta.get(imageIndex).isLittleEndian(), planeMin, planeMax);
                plane.setData(subImage);
                return plane;
            }
            if (this.lastPlane == null) {
                PLTEChunk plte;
                this.lastPlane = this.createPlane(planeMin, planeMax);
                if (((Metadata)this.getMetadata()).get(imageIndex).isIndexed() && (plte = meta.getPlte()) != null) {
                    ColorTable8 ct = new ColorTable8((byte[][])new byte[][]{plte.getRed(), plte.getGreen(), plte.getBlue()});
                    plane.setColorTable((ColorTable)ct);
                }
            }
            if (planeIndex == 0L) {
                this.getStream().seek(0L);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(this.getStream(), 4096));
                BufferedImage subImg = ImageIO.read(dis);
                this.lastPlane.populate(meta.get(imageIndex), subImg, planeMin, planeMax);
                this.lastPlaneIndex = 0L;
                plane.setData((BufferedImage)this.lastPlane.getData());
                if (!SCIFIOMetadataTools.wholePlane(imageIndex, meta, planeMin, planeMax)) {
                    subImg = AWTImageTools.getSubimage((BufferedImage)this.lastPlane.getData(), meta.get(imageIndex).isLittleEndian(), planeMin, planeMax);
                    plane.setData(subImg);
                }
                return plane;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(PNG_SIGNATURE);
            int[] coords = ((Metadata)this.getMetadata()).getFctl().get((int)planeIndex).getFrameCoordinates();
            IHDRChunk ihdr = ((Metadata)this.getMetadata()).getIhdr();
            this.processChunk(imageIndex, ihdr.getLength(), ihdr.getOffset(), coords, stream, true);
            FCTLChunk fctl = ((Metadata)this.getMetadata()).getFctl().get((int)(((Metadata)this.getMetadata()).isSeparateDefault() ? planeIndex - 1L : planeIndex));
            for (FDATChunk fdat : fctl.getFdatChunks()) {
                this.getStream().seek(fdat.getOffset() + 4L);
                byte[] b = new byte[fdat.getLength() + 8];
                Bytes.unpack((long)(fdat.getLength() - 4), (byte[])b, (int)0, (int)4, (boolean)((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian());
                b[4] = 73;
                b[5] = 68;
                b[6] = 65;
                b[7] = 84;
                this.getStream().read(b, 8, b.length - 12);
                int crc = (int)this.computeCRC(b, b.length - 4);
                Bytes.unpack((long)crc, (byte[])b, (int)(b.length - 4), (int)4, (boolean)((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian());
                stream.write(b);
                b = null;
            }
            PLTEChunk plte = ((Metadata)this.getMetadata()).getPlte();
            if (plte != null) {
                this.processChunk(imageIndex, plte.getLength(), plte.getOffset(), coords, stream, false);
            }
            RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), stream.toByteArray());
            DataInputStream dis = new DataInputStream(new BufferedInputStream(s, 4096));
            BufferedImage bi = ImageIO.read(dis);
            dis.close();
            long[] firstPlaneLengths = meta.get(imageIndex).getAxesLengthsPlanar();
            long[] firstPlaneOffsets = new long[firstPlaneLengths.length];
            this.openPlane(imageIndex, 0L, firstPlaneOffsets, firstPlaneLengths, config);
            WritableRaster firstRaster = ((BufferedImage)this.lastPlane.getData()).getRaster();
            WritableRaster currentRaster = bi.getRaster();
            firstRaster.setDataElements(coords[0], coords[1], currentRaster);
            BufferedImage bImg = new BufferedImage(((BufferedImage)this.lastPlane.getData()).getColorModel(), firstRaster, false, null);
            this.lastPlane.populate(((Metadata)this.getMetadata()).get(imageIndex), bImg, planeMin, planeMax);
            this.lastPlaneIndex = planeIndex;
            return (BufferedImagePlane)plane.populate(this.lastPlane);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.lastPlane = null;
                this.lastPlaneIndex = -1L;
            }
        }

        private long computeCRC(byte[] buf, int len) {
            CRC32 crc = new CRC32();
            crc.update(buf, 0, len);
            return crc.getValue();
        }

        private void processChunk(int imageIndex, int length, long offset, int[] coords, ByteArrayOutputStream stream, boolean isIHDR) throws IOException {
            byte[] b = new byte[length + 12];
            Bytes.unpack((long)length, (byte[])b, (int)0, (int)4, (boolean)((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian());
            byte[] typeBytes = isIHDR ? "IHDR".getBytes() : "PLTE".getBytes();
            System.arraycopy(typeBytes, 0, b, 4, 4);
            this.getStream().seek(offset);
            this.getStream().read(b, 8, b.length - 12);
            if (isIHDR) {
                Bytes.unpack((long)coords[2], (byte[])b, (int)8, (int)4, (boolean)((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian());
                Bytes.unpack((long)coords[3], (byte[])b, (int)12, (int)4, (boolean)((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian());
            }
            int crc = (int)this.computeCRC(b, b.length - 4);
            Bytes.unpack((long)crc, (byte[])b, (int)(b.length - 4), (int)4, (boolean)((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian());
            stream.write(b);
            b = null;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            byte[] signature = new byte[8];
            stream.read(signature);
            if (signature[0] != -119 || signature[1] != 80 || signature[2] != 78 || signature[3] != 71 || signature[4] != 13 || signature[5] != 10 || signature[6] != 26 || signature[7] != 10) {
                throw new FormatException("Invalid PNG signature.");
            }
            boolean sawFctl = false;
            while (stream.getFilePointer() < stream.length()) {
                int length = stream.readInt();
                String type = stream.readString(4);
                long offset = stream.getFilePointer();
                APNGChunk chunk = null;
                if (type.equals("acTL")) {
                    chunk = new ACTLChunk();
                    ACTLChunk actl = chunk;
                    actl.setNumFrames(stream.readInt());
                    actl.setNumPlays(stream.readInt());
                    meta.setActl(actl);
                } else if (type.equals("fcTL")) {
                    sawFctl = true;
                    chunk = new FCTLChunk();
                    FCTLChunk fctl = (FCTLChunk)chunk;
                    fctl.setSequenceNumber(stream.readInt());
                    fctl.setWidth(stream.readInt());
                    fctl.setHeight(stream.readInt());
                    fctl.setxOffset(stream.readInt());
                    fctl.setyOffset(stream.readInt());
                    fctl.setDelayNum(stream.readShort());
                    fctl.setDelayDen(stream.readShort());
                    fctl.setDisposeOp(stream.readByte());
                    fctl.setBlendOp(stream.readByte());
                    meta.getFctl().add(fctl);
                } else if (type.equals("IDAT")) {
                    meta.setSeparateDefault(!sawFctl);
                    chunk = new IDATChunk();
                    meta.addIdat((IDATChunk)chunk);
                    stream.skipBytes(length);
                } else if (type.equals("fdAT")) {
                    chunk = new FDATChunk();
                    ((FDATChunk)chunk).setSequenceNumber(stream.readInt());
                    meta.getFctl().get(meta.getFctl().size() - 1).addChunk((FDATChunk)chunk);
                    stream.skipBytes(length - 4);
                } else if (type.equals("IHDR")) {
                    chunk = new IHDRChunk();
                    IHDRChunk ihdr = (IHDRChunk)chunk;
                    ihdr.setWidth(stream.readInt());
                    ihdr.setHeight(stream.readInt());
                    ihdr.setBitDepth(stream.readByte());
                    ihdr.setColourType(stream.readByte());
                    ihdr.setCompressionMethod(stream.readByte());
                    ihdr.setFilterMethod(stream.readByte());
                    ihdr.setInterlaceMethod(stream.readByte());
                    meta.setIhdr(ihdr);
                } else if (type.equals("PLTE")) {
                    chunk = new PLTEChunk();
                    PLTEChunk plte = (PLTEChunk)chunk;
                    byte[] red = new byte[length / 3];
                    byte[] blue = new byte[length / 3];
                    byte[] green = new byte[length / 3];
                    for (int i = 0; i < length / 3; ++i) {
                        red[i] = stream.readByte();
                        green[i] = stream.readByte();
                        blue[i] = stream.readByte();
                    }
                    plte.setRed(red);
                    plte.setGreen(green);
                    plte.setBlue(blue);
                    meta.setPlte(plte);
                } else if (type.equals("IEND")) {
                    chunk = new IENDChunk();
                    stream.skipBytes((int)(stream.length() - stream.getFilePointer()));
                    meta.setIend((IENDChunk)chunk);
                } else {
                    stream.skipBytes(length);
                }
                if (chunk != null) {
                    chunk.setOffset(offset);
                    chunk.setLength(length);
                }
                if (stream.getFilePointer() >= stream.length() - 4L) continue;
                stream.skipBytes(4);
            }
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            int blockLen = 8;
            if (!StreamTools.validStream(stream, 8, false)) {
                return false;
            }
            byte[] signature = new byte[8];
            stream.read(signature);
            return signature[0] == -119 && signature[1] == 80 && signature[2] == 78 && signature[3] == 71 && signature[4] == 13 && signature[5] == 10 && signature[6] == 26 && signature[7] == 10;
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        public static final String DEFAULT_KEY = "separate default";
        private List<IDATChunk> idat;
        private List<FCTLChunk> fctl = new ArrayList<FCTLChunk>();
        private ACTLChunk actl;
        private IHDRChunk ihdr;
        private PLTEChunk plte;
        private IENDChunk iend;
        private boolean separateDefault;
        private boolean signed = false;
        private boolean littleEndian = false;

        public Metadata() {
            this.idat = new ArrayList<IDATChunk>();
        }

        public boolean isSigned() {
            return this.signed;
        }

        public void setSigned(boolean signed) {
            this.signed = signed;
        }

        public boolean isSeparateDefault() {
            return this.separateDefault;
        }

        public void setSeparateDefault(boolean separateDefault) {
            this.separateDefault = separateDefault;
        }

        public boolean isLittleEndian() {
            return this.littleEndian;
        }

        public void setLittleEndian(boolean littleEndian) {
            this.littleEndian = littleEndian;
        }

        @Override
        public void populateImageMetadata() {
            ACTLChunk actl;
            this.createImageMetadata(1);
            ImageMetadata imageMeta = this.get(0);
            imageMeta.setOrderCertain(true);
            imageMeta.setFalseColor(false);
            imageMeta.setThumbnail(false);
            imageMeta.setLittleEndian(this.isLittleEndian());
            boolean indexed = false;
            boolean rgb = true;
            int sizec = 1;
            byte bpp = this.getIhdr().getBitDepth();
            switch (this.getIhdr().getColourType()) {
                case 0: {
                    rgb = false;
                    break;
                }
                case 2: {
                    sizec = 3;
                    break;
                }
                case 3: {
                    indexed = true;
                    sizec = 1;
                    break;
                }
                case 4: {
                    rgb = false;
                    sizec = 2;
                    break;
                }
                case 6: {
                    sizec = 4;
                }
            }
            imageMeta.setAxisTypes(Axes.X, Axes.Y);
            imageMeta.setAxisLengths(new long[]{this.getIhdr().getWidth(), this.getIhdr().getHeight()});
            imageMeta.setPlanarAxisCount(2);
            imageMeta.setBitsPerPixel(bpp);
            try {
                imageMeta.setPixelType(FormatTools.pixelTypeFromBytes(bpp / 8, this.isSigned(), false));
            }
            catch (FormatException e) {
                this.log().error((Object)("Failed to find pixel type from bytes: " + bpp / 8), (Throwable)e);
            }
            if (rgb) {
                imageMeta.addAxis(Axes.CHANNEL, (long)sizec);
                imageMeta.setPlanarAxisCount(3);
            }
            if ((actl = this.getActl()) != null) {
                imageMeta.addAxis(Axes.TIME, (long)actl.getNumFrames());
            }
            imageMeta.setIndexed(indexed);
            imageMeta.setMetadataComplete(false);
            this.get(0).getTable().put(DEFAULT_KEY, this.isSeparateDefault());
        }

        public List<IDATChunk> getIdat() {
            return this.idat;
        }

        public void setIdat(List<IDATChunk> idat) {
            this.idat = idat;
        }

        public void addIdat(IDATChunk idat) {
            this.idat.add(idat);
        }

        public List<FCTLChunk> getFctl() {
            return this.fctl;
        }

        public void setFctl(List<FCTLChunk> fctl) {
            this.fctl = fctl;
        }

        public ACTLChunk getActl() {
            return this.actl;
        }

        public void setActl(ACTLChunk actl) {
            this.actl = actl;
        }

        public IHDRChunk getIhdr() {
            return this.ihdr;
        }

        public void setIhdr(IHDRChunk ihdr) {
            this.ihdr = ihdr;
        }

        public PLTEChunk getPlte() {
            return this.plte;
        }

        public void setPlte(PLTEChunk plte) {
            this.plte = plte;
        }

        public IENDChunk getIend() {
            return this.iend;
        }

        public void setIend(IENDChunk iend) {
            this.iend = iend;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.fctl = new ArrayList<FCTLChunk>();
                this.idat = new ArrayList<IDATChunk>();
            }
        }
    }
}

