/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.FormatException;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.ChannelFillerMetadata;
import io.scif.filters.Filter;
import io.scif.filters.MetadataWrapper;
import java.io.IOException;
import java.util.Arrays;
import net.imagej.axis.Axes;
import net.imglib2.display.ColorTable;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Filter.class)
public class ChannelFiller
extends AbstractReaderFilter {
    private int lastImageIndex = -1;
    private long lastPlaneIndex = -1L;
    private Plane lastPlane = null;
    private long[] lastPlaneOffsets = null;
    private long[] lastPlaneLengths = null;

    public ChannelFiller() {
        super((Class<? extends MetadataWrapper>)ChannelFillerMetadata.class);
    }

    @Override
    public boolean isCompatible(Class<?> c) {
        return ByteArrayReader.class.isAssignableFrom(c);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, long[] offsets, long[] lengths) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, offsets, lengths, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] offsets, long[] lengths) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, offsets, lengths, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        int planarAxes = this.getMetadata().get(imageIndex).getPlanarAxisCount();
        return this.openPlane(imageIndex, planeIndex, new long[planarAxes], this.getMetadata().get(imageIndex).getAxesLengthsPlanar(), config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        int planarAxes = this.getMetadata().get(imageIndex).getPlanarAxisCount();
        return this.openPlane(imageIndex, planeIndex, plane, new long[planarAxes], this.getMetadata().get(imageIndex).getAxesLengthsPlanar(), config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, long[] offsets, long[] lengths, SCIFIOConfig config) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, this.createPlane(this.getMetadata().get(imageIndex), offsets, lengths), offsets, lengths, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] offsets, long[] lengths, SCIFIOConfig config) throws FormatException, IOException {
        if (this.getParentMeta().get(imageIndex).isFalseColor() || !this.getParentMeta().get(imageIndex).isIndexed()) {
            if (!this.haveCached(imageIndex, planeIndex, offsets, lengths)) {
                this.lastPlaneOffsets = Arrays.copyOf(offsets, offsets.length);
                this.lastPlaneLengths = Arrays.copyOf(lengths, lengths.length);
                this.lastPlaneIndex = planeIndex;
                this.lastImageIndex = imageIndex;
                this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, offsets, lengths, config);
            }
            return this.lastPlane;
        }
        int lutLength = ((ChannelFillerMetadata)this.getMetadata()).getLutLength();
        if (!this.haveCached(imageIndex, planeIndex, offsets, lengths)) {
            this.updateLastPlaneInfo(imageIndex, lutLength, offsets, lengths);
            this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, this.lastPlaneOffsets, this.lastPlaneLengths, config);
            this.lastPlaneIndex = planeIndex;
            this.lastImageIndex = imageIndex;
            this.lastPlaneOffsets = Arrays.copyOf(offsets, offsets.length);
            this.lastPlaneLengths = Arrays.copyOf(lengths, lengths.length);
        }
        if (!ByteArrayPlane.class.isAssignableFrom(plane.getClass())) {
            plane = new ByteArrayPlane(this.getContext(), this.getMetadata().get(imageIndex), offsets, lengths);
        }
        byte[] buf = plane.getBytes();
        int pt = 0;
        int bytesPerIndex = this.getParentMeta().get(imageIndex).getBitsPerPixel() / 8;
        ColorTable lut = this.lastPlane.getColorTable();
        byte[] index = this.lastPlane.getBytes();
        if (this.getMetadata().get(imageIndex).getInterleavedAxisCount() > 0) {
            for (int i = 0; i < index.length / bytesPerIndex && pt < buf.length; ++i) {
                int iVal = Bytes.toInt((byte[])index, (int)(i * bytesPerIndex), (int)bytesPerIndex, (boolean)this.getMetadata().get(imageIndex).isLittleEndian());
                for (int j = 0; j < lutLength; ++j) {
                    buf[pt++] = (byte)lut.get(j, iVal);
                }
            }
        } else {
            for (int j = 0; j < lutLength; ++j) {
                for (int i = 0; i < index.length / bytesPerIndex && pt < buf.length; ++i) {
                    int iVal = Bytes.toInt((byte[])index, (int)(i * bytesPerIndex), (int)bytesPerIndex, (boolean)this.getMetadata().get(imageIndex).isLittleEndian());
                    buf[pt++] = (byte)lut.get(j, iVal);
                }
            }
        }
        plane.setColorTable(null);
        return plane;
    }

    @Override
    protected void setSourceHelper(String source, SCIFIOConfig config) {
        try {
            this.cleanUp();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double getPriority() {
        return 1.0;
    }

    private void updateLastPlaneInfo(int imageIndex, int lutLength, long[] offsets, long[] lengths) {
        this.lastPlaneOffsets = Arrays.copyOf(offsets, offsets.length);
        this.lastPlaneLengths = Arrays.copyOf(lengths, lengths.length);
        int cIndex = this.getMetadata().get(imageIndex).getAxisIndex(Axes.CHANNEL);
        this.lastPlaneOffsets[cIndex] = this.lastPlaneOffsets[cIndex] / (long)lutLength;
        this.lastPlaneLengths[cIndex] = this.lastPlaneLengths[cIndex] / (long)lutLength;
    }

    private boolean haveCached(int imageIndex, long planeIndex, long[] offsets, long[] lengths) {
        boolean matches = planeIndex == this.lastPlaneIndex;
        boolean bl = matches = matches && imageIndex == this.lastImageIndex;
        if (this.lastPlane != null && this.lastPlaneOffsets != null && this.lastPlaneLengths != null) {
            for (int i = 0; i < offsets.length && matches; ++i) {
                matches = matches && offsets[i] == this.lastPlaneOffsets[i];
                matches = matches && offsets[i] + lengths[i] == this.lastPlaneOffsets[i] + this.lastPlaneLengths[i];
            }
        } else {
            matches = false;
        }
        return matches;
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.lastPlaneIndex = 0L;
        this.lastImageIndex = 0;
        this.lastPlane = null;
        this.lastPlaneLengths = null;
        this.lastPlaneOffsets = null;
    }
}

